/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.webtypes.registry;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.util.io.HttpRequests;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.URI;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/vuejs/model/webtypes/registry/VueWebTypesJsonsCache;", "", "()V", "Companion", "intellij.vuejs"})
public final class VueWebTypesJsonsCache {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0004H\u0002J\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0004\u00a8\u0006\t"}, d2={"Lorg/jetbrains/vuejs/model/webtypes/registry/VueWebTypesJsonsCache$Companion;", "", "()V", "downloadWebTypesJson", "", "tarball", "getWebTypesJson", "Ljava/io/InputStream;", "url", "intellij.vuejs"})
    public static final class Companion {
        @NotNull
        public final InputStream getWebTypesJson(@NotNull String url) {
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            if (StringsKt.endsWith$default((String)url, (String)"json", (boolean)false, (int)2, null) && StringsKt.startsWith$default((String)url, (String)"file:", (boolean)false, (int)2, null)) {
                return new FileInputStream(new File(new URI(url)));
            }
            File downloadedJson = new File(PathManager.getSystemPath(), "web-types/" + FilesKt.getNameWithoutExtension((File)new File(url)) + ".web-types.json");
            if (!downloadedJson.exists()) {
                downloadedJson.getParentFile().mkdirs();
                String content = this.downloadWebTypesJson(url);
                ObjectMapper mapper = new ObjectMapper();
                JsonNode webTypesJson = mapper.readTree(content);
                mapper.writer().writeValue(downloadedJson, (Object)webTypesJson);
            }
            return new FileInputStream(downloadedJson);
        }

        private final String downloadWebTypesJson(String tarball) {
            byte[] contents = HttpRequests.request((String)tarball).readBytes(null);
            BufferedInputStream bi = new BufferedInputStream(new ByteArrayInputStream(contents));
            GzipCompressorInputStream gzi = new GzipCompressorInputStream((InputStream)bi);
            TarArchiveInputStream input = new TarArchiveInputStream((InputStream)gzi);
            ArchiveEntry e = input.getNextEntry();
            while (e != null) {
                String string = e.getName();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"e.name");
                if (StringsKt.endsWith$default((String)string, (String)".web-types.json", (boolean)false, (int)2, null) && input.canReadEntryData(e)) {
                    return FileUtil.loadTextAndClose((InputStream)((InputStream)input));
                }
                e = input.getNextEntry();
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

