/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.webtypes.json;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.vuejs.model.webtypes.json.Contributions;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"framework", "name", "version", "contributions"})
public class WebTypes {
    @JsonProperty(value="framework")
    @JsonPropertyDescription(value="Framework, for which the components are provided by the library")
    private Framework framework;
    @JsonProperty(value="name")
    @JsonPropertyDescription(value="Name of the library")
    private String name;
    @JsonProperty(value="version")
    @JsonPropertyDescription(value="Version of the library, for which web-types are provided")
    private String version;
    @JsonProperty(value="contributions")
    private Contributions contributions;
    @JsonIgnore
    private Map<String, Object> additionalProperties = new HashMap<String, Object>();

    @JsonProperty(value="framework")
    public Framework getFramework() {
        return this.framework;
    }

    @JsonProperty(value="framework")
    public void setFramework(Framework framework) {
        this.framework = framework;
    }

    @JsonProperty(value="name")
    public String getName() {
        return this.name;
    }

    @JsonProperty(value="name")
    public void setName(String name) {
        this.name = name;
    }

    @JsonProperty(value="version")
    public String getVersion() {
        return this.version;
    }

    @JsonProperty(value="version")
    public void setVersion(String version) {
        this.version = version;
    }

    @JsonProperty(value="contributions")
    public Contributions getContributions() {
        return this.contributions;
    }

    @JsonProperty(value="contributions")
    public void setContributions(Contributions contributions) {
        this.contributions = contributions;
    }

    @JsonAnyGetter
    public Map<String, Object> getAdditionalProperties() {
        return this.additionalProperties;
    }

    @JsonAnySetter
    public void setAdditionalProperty(String name, Object value) {
        this.additionalProperties.put(name, value);
    }

    public static enum Framework {
        VUE("vue");

        private final String value;
        private static final Map<String, Framework> CONSTANTS;

        private Framework(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static Framework fromValue(String value) {
            Framework constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, Framework>();
            for (Framework c : Framework.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

