/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.webtypes.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyDescription;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.vuejs.model.webtypes.json.HtmlAttribute;
import org.jetbrains.vuejs.model.webtypes.json.HtmlTag;
import org.jetbrains.vuejs.model.webtypes.json.HtmlVueFilter;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonPropertyOrder(value={"types-syntax", "description-markup", "tags", "attributes", "vue-filters"})
public class Html {
    @JsonProperty(value="types-syntax")
    @JsonPropertyDescription(value="Language in which types as specified.")
    private TypesSyntax typesSyntax;
    @JsonProperty(value="description-markup")
    @JsonPropertyDescription(value="Markup language in which descriptions are formatted")
    private DescriptionMarkup descriptionMarkup = DescriptionMarkup.fromValue("none");
    @JsonProperty(value="tags")
    private List<HtmlTag> tags = new ArrayList<HtmlTag>();
    @JsonProperty(value="attributes")
    private List<HtmlAttribute> attributes = new ArrayList<HtmlAttribute>();
    @JsonProperty(value="vue-filters")
    private List<HtmlVueFilter> vueFilters = new ArrayList<HtmlVueFilter>();

    @JsonProperty(value="types-syntax")
    public TypesSyntax getTypesSyntax() {
        return this.typesSyntax;
    }

    @JsonProperty(value="types-syntax")
    public void setTypesSyntax(TypesSyntax typesSyntax) {
        this.typesSyntax = typesSyntax;
    }

    @JsonProperty(value="description-markup")
    public DescriptionMarkup getDescriptionMarkup() {
        return this.descriptionMarkup;
    }

    @JsonProperty(value="description-markup")
    public void setDescriptionMarkup(DescriptionMarkup descriptionMarkup) {
        this.descriptionMarkup = descriptionMarkup;
    }

    @JsonProperty(value="tags")
    public List<HtmlTag> getTags() {
        return this.tags;
    }

    @JsonProperty(value="tags")
    public void setTags(List<HtmlTag> tags) {
        this.tags = tags;
    }

    @JsonProperty(value="attributes")
    public List<HtmlAttribute> getAttributes() {
        return this.attributes;
    }

    @JsonProperty(value="attributes")
    public void setAttributes(List<HtmlAttribute> attributes) {
        this.attributes = attributes;
    }

    @JsonProperty(value="vue-filters")
    public List<HtmlVueFilter> getVueFilters() {
        return this.vueFilters;
    }

    @JsonProperty(value="vue-filters")
    public void setVueFilters(List<HtmlVueFilter> vueFilters) {
        this.vueFilters = vueFilters;
    }

    public static enum TypesSyntax {
        TYPESCRIPT("typescript");

        private final String value;
        private static final Map<String, TypesSyntax> CONSTANTS;

        private TypesSyntax(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static TypesSyntax fromValue(String value) {
            TypesSyntax constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, TypesSyntax>();
            for (TypesSyntax c : TypesSyntax.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }

    public static enum DescriptionMarkup {
        HTML("html"),
        MARKDOWN("markdown"),
        NONE("none");

        private final String value;
        private static final Map<String, DescriptionMarkup> CONSTANTS;

        private DescriptionMarkup(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }

        @JsonValue
        public String value() {
            return this.value;
        }

        @JsonCreator
        public static DescriptionMarkup fromValue(String value) {
            DescriptionMarkup constant = CONSTANTS.get(value);
            if (constant == null) {
                throw new IllegalArgumentException(value);
            }
            return constant;
        }

        static {
            CONSTANTS = new HashMap<String, DescriptionMarkup>();
            for (DescriptionMarkup c : DescriptionMarkup.values()) {
                CONSTANTS.put(c.value, c);
            }
        }
    }
}

