/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.model.source;

import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.JSSpreadExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSVariable;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.lang.javascript.psi.types.JSStringLiteralTypeImpl;
import com.intellij.lang.javascript.psi.types.evaluable.JSApplyIndexedAccessType;
import com.intellij.lang.javascript.psi.types.evaluable.JSReferenceType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.index.VueComponentsIndex;
import org.jetbrains.vuejs.index.VueIndexData;
import org.jetbrains.vuejs.index.VueIndexKt;
import org.jetbrains.vuejs.lang.html.VueFileType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0004\u0018\u0000 \u00032\u00020\u0001:\u0002\u0003\u0004B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation;", "", "()V", "Companion", "ComponentsData", "intellij.vuejs"})
public final class VueComponentsCalculation {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010$\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\u0018\u00002\u00020\u0001B9\u0012\u001e\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0003\u0012\u0012\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0002\u0010\tR\u001d\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR)\u0010\u0002\u001a\u001a\u0012\u0004\u0012\u00020\u0004\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000b\u00a8\u0006\r"}, d2={"Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$ComponentsData;", "", "map", "", "", "Lkotlin/Pair;", "Lcom/intellij/psi/PsiElement;", "", "libCompResolveMap", "(Ljava/util/Map;Ljava/util/Map;)V", "getLibCompResolveMap", "()Ljava/util/Map;", "getMap", "intellij.vuejs"})
    public static final class ComponentsData {
        @NotNull
        private final Map<String, Pair<PsiElement, Boolean>> map;
        @NotNull
        private final Map<String, String> libCompResolveMap;

        @NotNull
        public final Map<String, Pair<PsiElement, Boolean>> getMap() {
            return this.map;
        }

        @NotNull
        public final Map<String, String> getLibCompResolveMap() {
            return this.libCompResolveMap;
        }

        public ComponentsData(@NotNull Map<String, ? extends Pair<? extends PsiElement, Boolean>> map2, @NotNull Map<String, String> libCompResolveMap) {
            Intrinsics.checkNotNullParameter(map2, (String)"map");
            Intrinsics.checkNotNullParameter(libCompResolveMap, (String)"libCompResolveMap");
            this.map = map2;
            this.libCompResolveMap = libCompResolveMap;
        }
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000^\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001:\u0001\u001eB\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ\u001e\u0010\t\u001a\u0010\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\b\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\rH\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0010\u001a\u00020\u000bH\u0002JJ\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u000b2\u0012\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0\u00152$\u0010\u0016\u001a \u0012\u0004\u0012\u00020\u000f\u0012\u0016\u0012\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b0\n0\u00170\u0015H\u0002J\u001c\u0010\u0019\u001a\u0004\u0018\u00010\u001a2\u0006\u0010\f\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000bH\u0002J.\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b0\n2\u0018\u0010\u001c\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0018\u0012\u0004\u0012\u00020\b0\n0\u001dH\u0002\u00a8\u0006\u001f"}, d2={"Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$Companion;", "", "()V", "calculateScopeComponents", "Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$ComponentsData;", "scope", "Lcom/intellij/psi/search/GlobalSearchScope;", "globalize", "", "findObjectLiteralOfGlobalRegistration", "Lkotlin/Pair;", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "element", "Lcom/intellij/lang/javascript/psi/stubs/JSImplicitElement;", "getNameFromDescriptor", "", "descriptor", "processComponentGroupRegistration", "", "objLiteral", "libCompResolveMap", "", "componentData", "", "Lcom/intellij/psi/PsiElement;", "resolveGlobalComponentName", "Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$Companion$SingleGlobalRegistration;", "selectComponentDefinition", "list", "", "SingleGlobalRegistration", "intellij.vuejs"})
    public static final class Companion {
        @NotNull
        public final ComponentsData calculateScopeComponents(@NotNull GlobalSearchScope scope, boolean globalize) {
            Intrinsics.checkNotNullParameter((Object)scope, (String)"scope");
            Collection<JSImplicitElement> allValues = VueIndexKt.getForAllKeys(scope, VueComponentsIndex.Companion.getKEY());
            boolean bl = false;
            Map libCompResolveMap = new LinkedHashMap();
            boolean bl2 = false;
            Map componentData = new LinkedHashMap();
            for (JSImplicitElement value : allValues) {
                boolean isGlobal;
                VueIndexData indexData;
                if (VueIndexKt.getVueIndexData(value) == null) {
                    continue;
                }
                String name = indexData.getOriginalName();
                boolean bl3 = isGlobal = indexData.isGlobal() || globalize;
                if (isGlobal && StringsKt.endsWith$default((String)name, (String)"*", (boolean)false, (int)2, null)) {
                    Pair<JSObjectLiteralExpression, Boolean> pair;
                    Pair<JSObjectLiteralExpression, Boolean> pair2 = pair = this.findObjectLiteralOfGlobalRegistration(value);
                    if (pair2 != null) {
                        if (((Boolean)pair2.getSecond()).booleanValue()) {
                            this.processComponentGroupRegistration((JSObjectLiteralExpression)pair.getFirst(), libCompResolveMap, componentData);
                            continue;
                        }
                    }
                    Pair<JSObjectLiteralExpression, Boolean> pair3 = pair;
                    SingleGlobalRegistration singleGlobalRegistration = this.resolveGlobalComponentName(value, (JSObjectLiteralExpression)(pair3 != null ? (JSObjectLiteralExpression)pair3.getFirst() : null));
                    if (singleGlobalRegistration == null) continue;
                    CharSequence charSequence = singleGlobalRegistration.getRealName();
                    boolean bl4 = false;
                    if (!(!StringsKt.isBlank((CharSequence)charSequence))) continue;
                    String normalizedName = VueUtilKt.fromAsset(singleGlobalRegistration.getRealName());
                    String normalizedAlias = VueUtilKt.fromAsset(StringsKt.isBlank((CharSequence)singleGlobalRegistration.getAlias()) ? StringsKt.substringBefore$default((String)name, (String)"*", null, (int)2, null) : singleGlobalRegistration.getAlias());
                    libCompResolveMap.put(normalizedAlias, normalizedName);
                    UtilKt.putValue((Map)componentData, (Object)normalizedName, (Object)new Pair((Object)singleGlobalRegistration.getElement(), (Object)true));
                    continue;
                }
                UtilKt.putValue((Map)componentData, (Object)VueUtilKt.fromAsset(name), (Object)new Pair((Object)value, (Object)isGlobal));
            }
            boolean bl5 = false;
            Map componentsMap = new LinkedHashMap();
            Map map2 = componentData;
            boolean bl6 = false;
            for (Map.Entry entry : map2.entrySet()) {
                componentsMap.put(entry.getKey(), this.selectComponentDefinition((List)entry.getValue()));
            }
            return new ComponentsData(componentsMap, libCompResolveMap);
        }

        private final Pair<JSObjectLiteralExpression, Boolean> findObjectLiteralOfGlobalRegistration(JSImplicitElement element) {
            Pair pair;
            JSVariable it;
            boolean bl;
            boolean bl2;
            JSVariable jSVariable;
            JSVariable jSVariable2;
            boolean indexedAccessUsed;
            PsiElement resolved;
            block14: {
                block13: {
                    JSVariable $this$castSafelyTo$iv;
                    PsiElement psiElement = element.getContext();
                    if (!(psiElement instanceof JSCallExpression)) {
                        psiElement = null;
                    }
                    JSCallExpression jSCallExpression = (JSCallExpression)psiElement;
                    if (jSCallExpression == null) {
                        return null;
                    }
                    JSCallExpression context = jSCallExpression;
                    VueIndexData indexData = VueIndexKt.getVueIndexData(element);
                    Object object = indexData;
                    if (object == null || (object = ((VueIndexData)object).getDescriptorRef()) == null) {
                        return null;
                    }
                    Object reference = object;
                    PsiElement psiElement2 = JSStubBasedPsiTreeUtil.resolveLocally((String)reference, (PsiElement)((PsiElement)context));
                    if (psiElement2 == null) {
                        return null;
                    }
                    resolved = psiElement2;
                    indexedAccessUsed = indexData.getGroupRegistration();
                    PsiElement psiElement3 = resolved;
                    if (!(psiElement3 instanceof JSVariable)) {
                        psiElement3 = null;
                    }
                    if ((jSVariable2 = (JSVariable)psiElement3) == null || (jSVariable2 = jSVariable2.getJSType()) == null) break block13;
                    jSVariable = jSVariable2;
                    boolean $i$f$castSafelyTo = false;
                    JSVariable jSVariable3 = $this$castSafelyTo$iv;
                    if (!(jSVariable3 instanceof JSApplyIndexedAccessType)) {
                        jSVariable3 = null;
                    }
                    if ((jSVariable2 = (JSApplyIndexedAccessType)jSVariable3) == null || (jSVariable2 = jSVariable2.getQualifierType()) == null) break block13;
                    $this$castSafelyTo$iv = jSVariable2;
                    $i$f$castSafelyTo = false;
                    JSVariable jSVariable4 = $this$castSafelyTo$iv;
                    if (!(jSVariable4 instanceof JSReferenceType)) {
                        jSVariable4 = null;
                    }
                    if ((jSVariable2 = (JSReferenceType)jSVariable4) == null) break block13;
                    jSVariable = jSVariable2;
                    bl2 = false;
                    bl = false;
                    it = jSVariable;
                    boolean bl3 = false;
                    indexedAccessUsed = true;
                    String string = it.getReferenceName();
                    PsiElement psiElement4 = resolved;
                    Intrinsics.checkNotNull((Object)psiElement4);
                    PsiElement psiElement5 = JSStubBasedPsiTreeUtil.resolveLocally((String)string, (PsiElement)psiElement4);
                    if (psiElement5 == null) {
                        return null;
                    }
                    PsiElement psiElement6 = psiElement5;
                    jSVariable2 = psiElement6;
                    if (jSVariable2 != null) break block14;
                }
                jSVariable2 = resolved;
            }
            resolved = jSVariable2;
            JSObjectLiteralExpression jSObjectLiteralExpression = VueUtilKt.objectLiteralFor(resolved);
            if (jSObjectLiteralExpression != null) {
                jSVariable = jSObjectLiteralExpression;
                bl2 = false;
                bl = false;
                it = jSVariable;
                boolean bl4 = false;
                pair = new Pair((Object)it, (Object)indexedAccessUsed);
            } else {
                pair = null;
            }
            return pair;
        }

        /*
         * WARNING - void declaration
         */
        private final SingleGlobalRegistration resolveGlobalComponentName(JSImplicitElement element, JSObjectLiteralExpression descriptor) {
            SingleGlobalRegistration singleGlobalRegistration;
            Object object;
            void $this$castSafelyTo$iv;
            PsiElement psiElement = element.getContext();
            if (!(psiElement instanceof JSCallExpression)) {
                psiElement = null;
            }
            JSCallExpression jSCallExpression = (JSCallExpression)psiElement;
            if (jSCallExpression == null) {
                return null;
            }
            JSCallExpression context = jSCallExpression;
            VueIndexData indexData = VueIndexKt.getVueIndexData(element);
            Object object2 = indexData;
            if (object2 == null || (object2 = ((VueIndexData)object2).getNameRef()) == null) {
                return null;
            }
            Object reference = object2;
            List parts = StringsKt.split$default((CharSequence)((CharSequence)reference), (char[])new char[]{'.'}, (boolean)false, (int)0, (int)6, null);
            if (parts.size() > 2) {
                return null;
            }
            if (parts.size() == 2) {
                if (Intrinsics.areEqual((Object)((String)parts.get(0)), (Object)indexData.getDescriptorRef()) ^ true) {
                    return null;
                }
                if (descriptor == null) {
                    return new SingleGlobalRegistration((String)parts.get(0), (String)parts.get(0), (PsiElement)context);
                }
                if (!descriptor.isValid()) {
                    return null;
                }
                JSProperty property = descriptor.findProperty((String)parts.get(1));
                if (property != null) {
                    Object object3;
                    Object object4;
                    JSType $this$castSafelyTo$iv2 = property.getJSType();
                    boolean $i$f$castSafelyTo = false;
                    JSType jSType = $this$castSafelyTo$iv2;
                    if (!(jSType instanceof JSStringLiteralTypeImpl)) {
                        jSType = null;
                    }
                    if ((object4 = (JSStringLiteralTypeImpl)jSType) == null || (object4 = object4.getLiteral()) == null) {
                        object4 = "";
                    }
                    Intrinsics.checkNotNullExpressionValue((Object)object4, (String)"property.jsType.castSafe\u2026ypeImpl>()?.literal ?: \"\"");
                    Object alias = object4;
                    if (Intrinsics.areEqual((Object)"name", (Object)((String)parts.get(1)))) {
                        object3 = alias;
                    } else {
                        object3 = this.getNameFromDescriptor(descriptor);
                        if (object3 == null) {
                            object3 = alias;
                        }
                    }
                    Object realName = object3;
                    return new SingleGlobalRegistration((String)realName, (String)alias, (PsiElement)descriptor);
                }
                return null;
            }
            if (descriptor == null) {
                return null;
            }
            PsiElement psiElement2 = JSStubBasedPsiTreeUtil.resolveLocally((String)reference, (PsiElement)((PsiElement)context));
            if (!(psiElement2 instanceof JSVariable)) {
                psiElement2 = null;
            }
            JSVariable jSVariable = (JSVariable)psiElement2;
            JSType property = jSVariable != null ? jSVariable.getJSType() : null;
            boolean $i$f$castSafelyTo = false;
            Object v8 = $this$castSafelyTo$iv;
            if (!(v8 instanceof JSStringLiteralTypeImpl)) {
                v8 = null;
            }
            if ((object = (JSStringLiteralTypeImpl)v8) != null && (object = object.getLiteral()) != null) {
                Object object5 = object;
                boolean bl = false;
                boolean bl2 = false;
                Object it = object5;
                boolean bl3 = false;
                String string = Companion.getNameFromDescriptor(descriptor);
                if (string == null) {
                    string = "";
                }
                Object object6 = it;
                Intrinsics.checkNotNullExpressionValue((Object)object6, (String)"it");
                singleGlobalRegistration = new SingleGlobalRegistration(string, (String)object6, (PsiElement)descriptor);
            } else {
                singleGlobalRegistration = null;
            }
            return singleGlobalRegistration;
        }

        private final String getNameFromDescriptor(JSObjectLiteralExpression descriptor) {
            JSProperty jSProperty = descriptor.findProperty("name");
            Object object = jSProperty != null ? jSProperty.getJSType() : null;
            if (!(object instanceof JSStringLiteralTypeImpl)) {
                object = null;
            }
            JSStringLiteralTypeImpl jSStringLiteralTypeImpl = (JSStringLiteralTypeImpl)object;
            return jSStringLiteralTypeImpl != null ? jSStringLiteralTypeImpl.getLiteral() : null;
        }

        private final void processComponentGroupRegistration(JSObjectLiteralExpression objLiteral, Map<String, String> libCompResolveMap, Map<String, List<Pair<PsiElement, Boolean>>> componentData) {
            ArrayDeque queue = new ArrayDeque();
            Collection collection = queue;
            Object[] objectArray = objLiteral.getPropertiesIncludingSpreads();
            Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"objLiteral.propertiesIncludingSpreads");
            CollectionsKt.addAll((Collection)collection, (Object[])objectArray);
            boolean bl = false;
            Set visited = new LinkedHashSet();
            while (!queue.isEmpty()) {
                PsiElement element;
                PsiElement psiElement = element = (PsiElement)queue.removeFirst();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element");
                if (!visited.add(psiElement)) continue;
                PsiElement psiElement2 = element;
                if (psiElement2 instanceof JSSpreadExpression) {
                    if (VueUtilKt.objectLiteralFor((PsiElement)((JSSpreadExpression)element).getExpression()) != null) {
                        JSObjectLiteralExpression jSObjectLiteralExpression;
                        boolean bl2 = false;
                        boolean bl3 = false;
                        JSObjectLiteralExpression it = jSObjectLiteralExpression;
                        boolean bl4 = false;
                        Collection collection2 = queue;
                        Object[] objectArray2 = it.getPropertiesIncludingSpreads();
                        Intrinsics.checkNotNullExpressionValue((Object)objectArray2, (String)"it.propertiesIncludingSpreads");
                        CollectionsKt.addAll((Collection)collection2, (Object[])objectArray2);
                    }
                    continue;
                }
                if (!(psiElement2 instanceof JSProperty)) continue;
                String propName = ((JSProperty)element).getName();
                JSObjectLiteralExpression descriptor = VueUtilKt.objectLiteralFor(element);
                if (propName == null) continue;
                JSObjectLiteralExpression jSObjectLiteralExpression = descriptor;
                String string = VueUtilKt.getTextIfLiteral((PsiElement)(jSObjectLiteralExpression != null && (jSObjectLiteralExpression = jSObjectLiteralExpression.findProperty("name")) != null ? jSObjectLiteralExpression.getValue() : null));
                if (string == null) {
                    string = propName;
                }
                String nameFromDescriptor = string;
                String normalizedName = VueUtilKt.fromAsset(propName);
                String realName = VueUtilKt.fromAsset(nameFromDescriptor);
                libCompResolveMap.put(normalizedName, realName);
                JSObjectLiteralExpression jSObjectLiteralExpression2 = descriptor;
                UtilKt.putValue(componentData, (Object)realName, (Object)new Pair((Object)(jSObjectLiteralExpression2 != null ? (JSElement)jSObjectLiteralExpression2 : (JSElement)element), (Object)true));
            }
        }

        private final Pair<PsiElement, Boolean> selectComponentDefinition(List<? extends Pair<? extends PsiElement, Boolean>> list) {
            Pair<? extends PsiElement, Boolean> selected = null;
            for (Pair<? extends PsiElement, Boolean> pair : list) {
                PsiFile psiFile = ((PsiElement)pair.getFirst()).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"componentData.first.containingFile");
                boolean isVue = Intrinsics.areEqual((Object)((Object)VueFileType.INSTANCE), (Object)psiFile.getFileType());
                if (((Boolean)pair.getSecond()).booleanValue()) {
                    if (isVue) {
                        return pair;
                    }
                    selected = pair;
                    continue;
                }
                if (selected != null || !isVue) continue;
                selected = pair;
            }
            Pair<? extends PsiElement, Boolean> pair = selected;
            if (pair == null) {
                pair = list.get(0);
            }
            return pair;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0002\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\t\u00a8\u0006\r"}, d2={"Lorg/jetbrains/vuejs/model/source/VueComponentsCalculation$Companion$SingleGlobalRegistration;", "", "realName", "", "alias", "element", "Lcom/intellij/psi/PsiElement;", "(Ljava/lang/String;Ljava/lang/String;Lcom/intellij/psi/PsiElement;)V", "getAlias", "()Ljava/lang/String;", "getElement", "()Lcom/intellij/psi/PsiElement;", "getRealName", "intellij.vuejs"})
        private static final class SingleGlobalRegistration {
            @NotNull
            private final String realName;
            @NotNull
            private final String alias;
            @NotNull
            private final PsiElement element;

            @NotNull
            public final String getRealName() {
                return this.realName;
            }

            @NotNull
            public final String getAlias() {
                return this.alias;
            }

            @NotNull
            public final PsiElement getElement() {
                return this.element;
            }

            public SingleGlobalRegistration(@NotNull String realName, @NotNull String alias, @NotNull PsiElement element) {
                Intrinsics.checkNotNullParameter((Object)realName, (String)"realName");
                Intrinsics.checkNotNullParameter((Object)alias, (String)"alias");
                Intrinsics.checkNotNullParameter((Object)element, (String)"element");
                this.realName = realName;
                this.alias = alias;
                this.element = element;
            }
        }
    }
}

