/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.libraries.vuex.types;

import com.intellij.lang.javascript.psi.JSParameter;
import com.intellij.lang.javascript.psi.JSQualifiedName;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.JSTypeUtils;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptField;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptParameter;
import com.intellij.lang.javascript.psi.resolve.JSTypeEvaluator;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import kotlin.Metadata;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.FunctionReferenceImpl;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.libraries.vuex.VuexUtils;
import org.jetbrains.vuejs.libraries.vuex.model.store.VuexStaticNamespace;
import org.jetbrains.vuejs.libraries.vuex.model.store.VuexStoreNamespace;
import org.jetbrains.vuejs.libraries.vuex.model.store.VuexStoreNamespaceKt;
import org.jetbrains.vuejs.libraries.vuex.types.VuexActionContextType;
import org.jetbrains.vuejs.libraries.vuex.types.VuexContainerPropertyTypeBase;
import org.jetbrains.vuejs.libraries.vuex.types.VuexStoreTypeProvider;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ&\u0010\t\u001a\u0016\u0012\u0004\u0012\u00020\b\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f\u0018\u00010\n2\b\u0010\r\u001a\u0004\u0018\u00010\u000eH\u0002J\u0010\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0010H\u0002\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/vuejs/libraries/vuex/types/VuexStoreTypeProvider;", "", "()V", "addTypeFromResolveResult", "", "evaluator", "Lcom/intellij/lang/javascript/psi/resolve/JSTypeEvaluator;", "result", "Lcom/intellij/psi/PsiElement;", "getTypeConstructor", "Lkotlin/reflect/KFunction2;", "Lorg/jetbrains/vuejs/libraries/vuex/model/store/VuexStoreNamespace;", "Lorg/jetbrains/vuejs/libraries/vuex/types/VuexContainerPropertyTypeBase;", "name", "", "isStoreField", "Lcom/intellij/lang/javascript/psi/ecma6/TypeScriptField;", "intellij.vuejs"})
public final class VuexStoreTypeProvider {
    @NotNull
    public static final VuexStoreTypeProvider INSTANCE;

    public final boolean addTypeFromResolveResult(@NotNull JSTypeEvaluator evaluator, @NotNull PsiElement result) {
        Intrinsics.checkNotNullParameter((Object)evaluator, (String)"evaluator");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        if (result instanceof TypeScriptField) {
            KFunction<VuexContainerPropertyTypeBase> kFunction = this.getTypeConstructor(((TypeScriptField)result).getName());
            if (kFunction == null) {
                return false;
            }
            KFunction<VuexContainerPropertyTypeBase> typeConstructor = kFunction;
            if (!this.isStoreField((TypeScriptField)result) || !VueContextKt.isVueContext(result)) {
                return false;
            }
            evaluator.addType((JSType)((Function2)typeConstructor).invoke((Object)result, (Object)VuexStaticNamespace.Companion.getEMPTY()));
            return true;
        }
        if (result instanceof JSParameter) {
            if (result instanceof TypeScriptParameter) {
                JSType typeConstructor = ((TypeScriptParameter)result).getJSType();
                boolean bl = false;
                boolean bl2 = false;
                JSType it = typeConstructor;
                boolean bl3 = false;
                boolean bl4 = it != null && !JSTypeUtils.isAnyType((JSType)it);
                if (bl4) {
                    return false;
                }
            }
            if (VuexUtils.INSTANCE.isActionContextParameter(result)) {
                if (!VueContextKt.isVueContext(result)) {
                    return false;
                }
                evaluator.addType((JSType)new VuexActionContextType(result));
                return true;
            }
            String name = ((JSParameter)result).getName();
            KFunction<VuexContainerPropertyTypeBase> kFunction = this.getTypeConstructor(name);
            if (kFunction == null) {
                return false;
            }
            KFunction<VuexContainerPropertyTypeBase> typeConstructor = kFunction;
            JSParameter jSParameter = (JSParameter)result;
            String string = name;
            Intrinsics.checkNotNull((Object)string);
            VuexStoreNamespace vuexStoreNamespace = VuexStoreNamespaceKt.getNamespaceForGettersOrState(jSParameter, string);
            if (vuexStoreNamespace == null) {
                return false;
            }
            VuexStoreNamespace namespace = vuexStoreNamespace;
            if (!VueContextKt.isVueContext(result)) {
                return false;
            }
            evaluator.addType((JSType)((Function2)typeConstructor).invoke((Object)result, (Object)namespace));
            return true;
        }
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isStoreField(TypeScriptField result) {
        JSQualifiedName jSQualifiedName = result.getNamespace();
        if (!Intrinsics.areEqual((Object)(jSQualifiedName != null ? jSQualifiedName.getQualifiedName() : null), (Object)"Store")) return false;
        PsiFile psiFile = result.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"result.containingFile");
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (!Intrinsics.areEqual(virtualFile != null && (virtualFile = virtualFile.getParent()) != null && (virtualFile = virtualFile.getParent()) != null ? virtualFile.getName() : null, (Object)"vuex")) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final KFunction<VuexContainerPropertyTypeBase> getTypeConstructor(String name) {
        String string = name;
        if (string == null) return null;
        switch (string) {
            case "rootState": 
            case "state": {
                FunctionReferenceImpl functionReferenceImpl = getTypeConstructor.1.INSTANCE;
                return functionReferenceImpl;
            }
            case "rootGetters": 
            case "getters": {
                FunctionReferenceImpl functionReferenceImpl = getTypeConstructor.2.INSTANCE;
                return functionReferenceImpl;
            }
            default: {
                return null;
            }
        }
    }

    private VuexStoreTypeProvider() {
    }

    static {
        VuexStoreTypeProvider vuexStoreTypeProvider;
        INSTANCE = vuexStoreTypeProvider = new VuexStoreTypeProvider();
    }
}

