/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.libraries.nuxt.actions;

import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreter;
import com.intellij.javascript.nodejs.interpreter.NodeJsInterpreterManager;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.lang.javascript.modules.InstallNodeModuleQuickFix;
import com.intellij.lang.javascript.modules.PackageInstaller;
import com.intellij.notification.Notification;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.text.SemVer;
import com.intellij.webcore.packaging.PackageManagementService;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.libraries.nuxt.NuxtUtilsKt;
import org.jetbrains.vuejs.libraries.nuxt.actions.InstallNuxtTypesAction;
import org.jetbrains.vuejs.libraries.nuxt.model.NuxtApplication;
import org.jetbrains.vuejs.libraries.nuxt.model.NuxtModelManager;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u0017"}, d2={"Lorg/jetbrains/vuejs/libraries/nuxt/actions/InstallNuxtTypesAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "project", "Lcom/intellij/openapi/project/Project;", "packageJson", "Lcom/intellij/openapi/vfs/VirtualFile;", "notification", "Lcom/intellij/notification/Notification;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vfs/VirtualFile;Lcom/intellij/notification/Notification;)V", "getNotification", "()Lcom/intellij/notification/Notification;", "getPackageJson", "()Lcom/intellij/openapi/vfs/VirtualFile;", "getProject", "()Lcom/intellij/openapi/project/Project;", "actionPerformed", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "getMatchingTypesVersion", "", "nuxtVersion", "Lcom/intellij/util/text/SemVer;", "intellij.vuejs"})
public final class InstallNuxtTypesAction
extends DumbAwareAction {
    @NotNull
    private final Project project;
    @NotNull
    private final VirtualFile packageJson;
    @NotNull
    private final Notification notification;

    public void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        NodeJsInterpreterManager nodeJsInterpreterManager = NodeJsInterpreterManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreterManager, (String)"NodeJsInterpreterManager.getInstance(project)");
        NodeJsInterpreter nodeJsInterpreter = nodeJsInterpreterManager.getInterpreter();
        if (nodeJsInterpreter == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)nodeJsInterpreter, (String)"NodeJsInterpreterManager\u2026ct).interpreter ?: return");
        NodeJsInterpreter interpreter = nodeJsInterpreter;
        VirtualFile parent2 = this.packageJson.getParent();
        this.notification.hideBalloon();
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this, interpreter, parent2, this.project, JavaScriptBundle.message((String)"node.js.quickfix.install.node.module.with.dev.dependencies.text", (Object[])new Object[]{"@nuxt/types"}), true){
            final /* synthetic */ InstallNuxtTypesAction this$0;
            final /* synthetic */ NodeJsInterpreter $interpreter;
            final /* synthetic */ VirtualFile $parent;

            public void run(@NotNull ProgressIndicator indicator) {
                Intrinsics.checkNotNullParameter((Object)indicator, (String)"indicator");
                String expectedVersion2 = (String)ReadAction.compute((ThrowableComputable)((ThrowableComputable)new ThrowableComputable<String, Throwable>(this){
                    final /* synthetic */ actionPerformed.1 this$0;

                    public final String compute() {
                        String string;
                        Project project = this.this$0.getProject();
                        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
                        NuxtApplication nuxtApplication = NuxtModelManager.INSTANCE.getApplication(project, this.this$0.this$0.getPackageJson());
                        if (nuxtApplication != null && (nuxtApplication = nuxtApplication.getNuxtVersion()) != null) {
                            NuxtApplication nuxtApplication2 = nuxtApplication;
                            boolean bl = false;
                            boolean bl2 = false;
                            NuxtApplication it = nuxtApplication2;
                            boolean bl3 = false;
                            string = InstallNuxtTypesAction.access$getMatchingTypesVersion(this.this$0.this$0, (SemVer)it);
                        } else {
                            string = null;
                        }
                        return string;
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
                String extraOptions = InstallNodeModuleQuickFix.buildExtraOptions((Project)this.getProject(), (boolean)true);
                PackageManagementService.Listener listener = InstallNodeModuleQuickFix.createListener((Project)this.getProject(), (VirtualFile)this.this$0.getPackageJson(), (String)"@nuxt/types");
                Intrinsics.checkNotNullExpressionValue((Object)listener, (String)"InstallNodeModuleQuickFi\u2026kageJson, NUXT_TYPES_PKG)");
                PackageManagementService.Listener listener2 = listener;
                Project project = this.getProject();
                VirtualFile virtualFile = this.$parent;
                Intrinsics.checkNotNullExpressionValue((Object)virtualFile, (String)"parent");
                new PackageInstaller(project, this.$interpreter, "@nuxt/types", expectedVersion2, new File(virtualFile.getPath()), listener2, extraOptions).run(indicator);
                VfsUtil.markDirtyAndRefresh((boolean)true, (boolean)false, (boolean)false, (VirtualFile[])new VirtualFile[]{this.this$0.getPackageJson()});
            }
            {
                this.this$0 = this$0;
                this.$interpreter = $captured_local_variable$1;
                this.$parent = $captured_local_variable$2;
                super($super_call_param$3, $super_call_param$4, $super_call_param$5);
            }
        });
    }

    private final String getMatchingTypesVersion(SemVer nuxtVersion2) {
        String string;
        StringBuilder stringBuilder = new StringBuilder().append("~");
        if (nuxtVersion2.isGreaterOrEqualThan(NuxtUtilsKt.getNUXT_2_13_0())) {
            string = "" + nuxtVersion2.getMajor() + '.' + nuxtVersion2.getMinor();
        } else {
            switch (nuxtVersion2.getMinor()) {
                case 9: {
                    string = "0.2";
                    break;
                }
                case 10: {
                    string = "0.5";
                    break;
                }
                case 11: {
                    string = "0.6";
                    break;
                }
                case 12: {
                    string = "0.7";
                    break;
                }
                default: {
                    return null;
                }
            }
        }
        return stringBuilder.append(string).append(".0").toString();
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    @NotNull
    public final VirtualFile getPackageJson() {
        return this.packageJson;
    }

    @NotNull
    public final Notification getNotification() {
        return this.notification;
    }

    public InstallNuxtTypesAction(@NotNull Project project, @NotNull VirtualFile packageJson, @NotNull Notification notification) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)packageJson, (String)"packageJson");
        Intrinsics.checkNotNullParameter((Object)notification, (String)"notification");
        super(JavaScriptBundle.message((String)"node.js.quickfix.install.node.module.with.dev.dependencies.text", (Object[])new Object[]{"@nuxt/types"}));
        this.project = project;
        this.packageJson = packageJson;
        this.notification = notification;
    }

    public static final /* synthetic */ String access$getMatchingTypesVersion(InstallNuxtTypesAction $this, SemVer nuxtVersion2) {
        return $this.getMatchingTypesVersion(nuxtVersion2);
    }
}

