/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript.service;

import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.typescript.compiler.languageService.protocol.TypeScriptLanguageServiceCache;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.index.VueFrameworkHandlerKt;
import org.jetbrains.vuejs.lang.html.VueFileType;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0010#\n\u0000\n\u0002\u0010\u000b\n\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J,\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\f\u0010\t\u001a\b\u0012\u0004\u0012\u00020\b0\n2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fH\u0014J\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0007\u001a\u00020\bH\u0002\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/service/VueTypeScriptServiceCache;", "Lcom/intellij/lang/typescript/compiler/languageService/protocol/TypeScriptLanguageServiceCache;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "addFileIfInvalid", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "filesToClose", "", "toCloseByChangedType", "", "isInvalidVueTypeScriptFile", "", "intellij.vuejs"})
public final class VueTypeScriptServiceCache
extends TypeScriptLanguageServiceCache {
    protected void addFileIfInvalid(@NotNull VirtualFile file, @NotNull Set<? extends VirtualFile> filesToClose, @NotNull Set<VirtualFile> toCloseByChangedType) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter(filesToClose, (String)"filesToClose");
        Intrinsics.checkNotNullParameter(toCloseByChangedType, (String)"toCloseByChangedType");
        if (this.isInvalidVueTypeScriptFile(file) && !filesToClose.contains(file)) {
            toCloseByChangedType.add(file);
        }
    }

    private final boolean isInvalidVueTypeScriptFile(VirtualFile file) {
        if (file.isValid()) {
            FileType fileType = file.getFileType();
            Intrinsics.checkNotNullExpressionValue((Object)fileType, (String)"file.fileType");
            FileType fileType2 = fileType;
            if (Intrinsics.areEqual((Object)fileType2, (Object)((Object)VueFileType.INSTANCE))) {
                PsiFile findFile = PsiManager.getInstance((Project)this.myProject).findFile(file);
                if (findFile == null) {
                    return false;
                }
                JSEmbeddedContent module = VueFrameworkHandlerKt.findModule((PsiElement)findFile);
                return module == null || !DialectDetector.isTypeScript((PsiElement)((PsiElement)module));
            }
        }
        return false;
    }

    public VueTypeScriptServiceCache(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        super(project);
    }
}

