/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.typescript;

import com.intellij.javascript.nodejs.NodeModuleDirectorySearchProcessor;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.typescript.modules.TypeScriptNodeReference;
import com.intellij.lang.typescript.tsconfig.TypeScriptCompositeImportsResolverImpl;
import com.intellij.lang.typescript.tsconfig.TypeScriptConfig;
import com.intellij.lang.typescript.tsconfig.TypeScriptFileImportsResolver;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportResolveContext;
import com.intellij.lang.typescript.tsconfig.TypeScriptImportsResolverProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.index.VueFrameworkHandlerKt;
import org.jetbrains.vuejs.lang.html.VueFileType;
import org.jetbrains.vuejs.lang.typescript.VueFileImportsResolver;
import org.jetbrains.vuejs.lang.typescript.VueTypeScriptImportsResolverProviderKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\"\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\fH\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0013\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016\u00a2\u0006\u0002\u0010\u0015J\u0018\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0018\u001a\u00020\fH\u0016J\u0010\u0010\u0019\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0014H\u0016\u00a8\u0006\u001b"}, d2={"Lorg/jetbrains/vuejs/lang/typescript/VueTypeScriptImportsResolverProvider;", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportsResolverProvider;", "()V", "createResolver", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptFileImportsResolver;", "project", "Lcom/intellij/openapi/project/Project;", "config", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptConfig;", "context", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptImportResolveContext;", "contextFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "flattenAndAppendResolver", "Lcom/intellij/lang/typescript/tsconfig/TypeScriptCompositeImportsResolverImpl;", "defaultProvider", "vueResolver", "Lorg/jetbrains/vuejs/lang/typescript/VueFileImportsResolver;", "getExtensions", "", "", "()[Ljava/lang/String;", "isDynamicFile", "", "file", "useExplicitExtension", "extensionWithDot", "intellij.vuejs"})
public final class VueTypeScriptImportsResolverProvider
implements TypeScriptImportsResolverProvider {
    public boolean isDynamicFile(@NotNull Project project, @NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (Intrinsics.areEqual((Object)file.getFileType(), (Object)((Object)VueFileType.INSTANCE)) ^ true) {
            return false;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)project).findFile(file);
        if (psiFile == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"PsiManager.getInstance(p\u2026ile(file) ?: return false");
        PsiFile psiFile2 = psiFile;
        JSEmbeddedContent module = VueFrameworkHandlerKt.findModule((PsiElement)psiFile2);
        return module != null && DialectDetector.isTypeScript((PsiElement)((PsiElement)module));
    }

    public boolean useExplicitExtension(@NotNull String extensionWithDot) {
        Intrinsics.checkNotNullParameter((Object)extensionWithDot, (String)"extensionWithDot");
        return Intrinsics.areEqual((Object)extensionWithDot, (Object)".vue");
    }

    @NotNull
    public String[] getExtensions() {
        return VueTypeScriptImportsResolverProviderKt.getDefaultExtensionsWithDot();
    }

    @Nullable
    public TypeScriptFileImportsResolver createResolver(@NotNull Project project, @NotNull TypeScriptImportResolveContext context, @NotNull VirtualFile contextFile) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)contextFile, (String)"contextFile");
        if (!VueContextKt.isVueContext(contextFile, project)) {
            return null;
        }
        TypeScriptFileImportsResolver typeScriptFileImportsResolver = TypeScriptImportsResolverProvider.getDefaultProvider((Project)project, (TypeScriptImportResolveContext)context, (VirtualFile)contextFile);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptFileImportsResolver, (String)"TypeScriptImportsResolve\u2026ct, context, contextFile)");
        TypeScriptFileImportsResolver defaultProvider = typeScriptFileImportsResolver;
        TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor typeScriptNodeModuleDirectorySearchProcessor = TypeScriptNodeReference.TS_PROCESSOR;
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptNodeModuleDirectorySearchProcessor, (String)"TypeScriptNodeReference.TS_PROCESSOR");
        VueFileImportsResolver vueResolver = new VueFileImportsResolver(project, context, (NodeModuleDirectorySearchProcessor)typeScriptNodeModuleDirectorySearchProcessor);
        return (TypeScriptFileImportsResolver)this.flattenAndAppendResolver(defaultProvider, vueResolver);
    }

    @Nullable
    public TypeScriptFileImportsResolver createResolver(@NotNull Project project, @NotNull TypeScriptConfig config2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)config2, (String)"config");
        TypeScriptFileImportsResolver typeScriptFileImportsResolver = TypeScriptImportsResolverProvider.getDefaultProvider((Project)project, (TypeScriptConfig)config2);
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptFileImportsResolver, (String)"TypeScriptImportsResolve\u2026Provider(project, config)");
        TypeScriptFileImportsResolver defaultProvider = typeScriptFileImportsResolver;
        TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor nodeProcessor = TypeScriptNodeReference.TS_PROCESSOR;
        TypeScriptImportResolveContext typeScriptImportResolveContext = config2.getResolveContext();
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptImportResolveContext, (String)"config.resolveContext");
        TypeScriptNodeReference.TypeScriptNodeModuleDirectorySearchProcessor typeScriptNodeModuleDirectorySearchProcessor = nodeProcessor;
        Intrinsics.checkNotNullExpressionValue((Object)typeScriptNodeModuleDirectorySearchProcessor, (String)"nodeProcessor");
        VueFileImportsResolver vueResolver = new VueFileImportsResolver(project, typeScriptImportResolveContext, (NodeModuleDirectorySearchProcessor)typeScriptNodeModuleDirectorySearchProcessor);
        return (TypeScriptFileImportsResolver)this.flattenAndAppendResolver(defaultProvider, vueResolver);
    }

    private final TypeScriptCompositeImportsResolverImpl flattenAndAppendResolver(TypeScriptFileImportsResolver defaultProvider, VueFileImportsResolver vueResolver) {
        boolean bl = false;
        List result = new ArrayList();
        if (defaultProvider instanceof TypeScriptCompositeImportsResolverImpl) {
            List list = ((TypeScriptCompositeImportsResolverImpl)defaultProvider).getResolvers();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"defaultProvider.resolvers");
            result.addAll(list);
        } else {
            result.add(defaultProvider);
        }
        result.add(vueResolver);
        return new TypeScriptCompositeImportsResolverImpl(result);
    }
}

