/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.lang.html.psi.formatter;

import com.intellij.formatting.Block;
import com.intellij.formatting.BlockEx;
import com.intellij.formatting.Indent;
import com.intellij.formatting.Spacing;
import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.codeStyle.CustomCodeStyleSettings;
import com.intellij.psi.formatter.xml.AnotherLanguageBlockWrapper;
import com.intellij.psi.formatter.xml.SyntheticBlock;
import com.intellij.psi.formatter.xml.XmlFormattingPolicy;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.lang.expr.VueJSLanguage;
import org.jetbrains.vuejs.lang.html.lexer.VueTokenTypes;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueBlock;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueCodeStyleSettings;
import org.jetbrains.vuejs.lang.html.psi.formatter.VueHtmlBlock;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 \u001b2\u00020\u00012\u00020\u0002:\u0001\u001bBA\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\b\u0012\b\u0010\f\u001a\u0004\u0018\u00010\r\u00a2\u0006\u0002\u0010\u000eJ\b\u0010\u000f\u001a\u00020\u0010H\u0016J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\n\u0010\u0015\u001a\u0004\u0018\u00010\rH\u0016J\u001c\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\u0010\u0018\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0016J\b\u0010\u001a\u001a\u00020\u0010H\u0016R\u0010\u0010\f\u001a\u0004\u0018\u00010\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001c"}, d2={"Lorg/jetbrains/vuejs/lang/html/psi/formatter/VueSyntheticBlock;", "Lcom/intellij/psi/formatter/xml/SyntheticBlock;", "Lcom/intellij/formatting/BlockEx;", "subBlocks", "", "Lcom/intellij/formatting/Block;", "parent", "indent", "Lcom/intellij/formatting/Indent;", "policy", "Lcom/intellij/psi/formatter/xml/XmlFormattingPolicy;", "childIndent", "myLanguage", "Lcom/intellij/lang/Language;", "(Ljava/util/List;Lcom/intellij/formatting/Block;Lcom/intellij/formatting/Indent;Lcom/intellij/psi/formatter/xml/XmlFormattingPolicy;Lcom/intellij/formatting/Indent;Lcom/intellij/lang/Language;)V", "endsWithText", "", "findSibling", "block", "relativeIndex", "", "getLanguage", "getSpacing", "Lcom/intellij/formatting/Spacing;", "child1", "child2", "startsWithText", "Companion", "intellij.vuejs"})
public final class VueSyntheticBlock
extends SyntheticBlock
implements BlockEx {
    private final Language myLanguage;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @Nullable
    public Language getLanguage() {
        return this.myLanguage;
    }

    @Nullable
    public Spacing getSpacing(@Nullable Block child1, @NotNull Block child2) {
        Spacing spacing;
        Intrinsics.checkNotNullParameter((Object)child2, (String)"child2");
        if (Companion.isVueInterpolationBorder(child1, child2) || Companion.isVueInterpolationBorder(child2, child1)) {
            int spaces;
            AnotherLanguageBlockWrapper anotherLanguageBlockWrapper;
            Block block = child1;
            if (!(block instanceof AnotherLanguageBlockWrapper)) {
                block = null;
            }
            if ((anotherLanguageBlockWrapper = (AnotherLanguageBlockWrapper)block) == null) {
                anotherLanguageBlockWrapper = (AnotherLanguageBlockWrapper)child2;
            }
            AnotherLanguageBlockWrapper injectedWrapper = anotherLanguageBlockWrapper;
            boolean spacesWithinInterpolation = false;
            boolean insertNewLine = false;
            XmlFormattingPolicy xmlFormattingPolicy = this.myXmlFormattingPolicy;
            Intrinsics.checkNotNullExpressionValue((Object)xmlFormattingPolicy, (String)"myXmlFormattingPolicy");
            CustomCodeStyleSettings customCodeStyleSettings = xmlFormattingPolicy.getSettings().getCustomSettings(VueCodeStyleSettings.class);
            boolean bl = false;
            boolean bl2 = false;
            VueCodeStyleSettings it = (VueCodeStyleSettings)customCodeStyleSettings;
            boolean bl3 = false;
            spacesWithinInterpolation = it.SPACES_WITHIN_INTERPOLATION_EXPRESSIONS;
            insertNewLine = !(child1 instanceof AnotherLanguageBlockWrapper) ? it.INTERPOLATION_NEW_LINE_AFTER_START_DELIMITER : it.INTERPOLATION_NEW_LINE_BEFORE_END_DELIMITER;
            int n = spaces = spacesWithinInterpolation ? 1 : 0;
            if (insertNewLine) {
                Block prevBlock = this.findSibling((Block)injectedWrapper, -1);
                Block nextBlock = this.findSibling((Block)injectedWrapper, 1);
                if (prevBlock != null && nextBlock != null) {
                    TextRange textRange = prevBlock.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"prevBlock.textRange");
                    int n2 = textRange.getStartOffset();
                    TextRange textRange2 = nextBlock.getTextRange();
                    Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"nextBlock.textRange");
                    TextRange textRange3 = new TextRange(n2, textRange2.getEndOffset());
                    XmlFormattingPolicy xmlFormattingPolicy2 = this.myXmlFormattingPolicy;
                    Intrinsics.checkNotNullExpressionValue((Object)xmlFormattingPolicy2, (String)"myXmlFormattingPolicy");
                    spacing = Spacing.createDependentLFSpacing((int)spaces, (int)spaces, (TextRange)textRange3, (boolean)true, (int)xmlFormattingPolicy2.getKeepBlankLines());
                } else {
                    XmlFormattingPolicy xmlFormattingPolicy3 = this.myXmlFormattingPolicy;
                    Intrinsics.checkNotNullExpressionValue((Object)xmlFormattingPolicy3, (String)"myXmlFormattingPolicy");
                    spacing = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)true, (int)xmlFormattingPolicy3.getKeepBlankLines());
                }
            } else {
                XmlFormattingPolicy xmlFormattingPolicy4 = this.myXmlFormattingPolicy;
                Intrinsics.checkNotNullExpressionValue((Object)xmlFormattingPolicy4, (String)"myXmlFormattingPolicy");
                spacing = Spacing.createSpacing((int)spaces, (int)spaces, (int)0, (boolean)true, (int)xmlFormattingPolicy4.getKeepBlankLines());
            }
        } else {
            spacing = super.getSpacing(child1, child2);
        }
        return spacing;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean startsWithText() {
        if (super.startsWithText()) return true;
        ASTNode aSTNode = this.myStartTreeNode;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"myStartTreeNode");
        if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)VueTokenTypes.INTERPOLATION_START))) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean endsWithText() {
        if (super.endsWithText()) return true;
        ASTNode aSTNode = this.myEndTreeNode;
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"myEndTreeNode");
        if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)((Object)VueTokenTypes.INTERPOLATION_END))) return false;
        return true;
    }

    private final Block findSibling(Block block, int relativeIndex) {
        List list = this.getSubBlocks();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"subBlocks");
        List subBlocks = list;
        int ind = subBlocks.indexOf(block);
        if (ind >= 0 && ind + relativeIndex >= 0 && ind + relativeIndex < subBlocks.size()) {
            return (Block)subBlocks.get(ind + relativeIndex);
        }
        return null;
    }

    public VueSyntheticBlock(@NotNull List<? extends Block> subBlocks, @NotNull Block parent2, @Nullable Indent indent, @NotNull XmlFormattingPolicy policy, @Nullable Indent childIndent, @Nullable Language myLanguage) {
        Intrinsics.checkNotNullParameter(subBlocks, (String)"subBlocks");
        Intrinsics.checkNotNullParameter((Object)parent2, (String)"parent");
        Intrinsics.checkNotNullParameter((Object)policy, (String)"policy");
        super(subBlocks, parent2, indent, policy, childIndent);
        this.myLanguage = myLanguage;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\b"}, d2={"Lorg/jetbrains/vuejs/lang/html/psi/formatter/VueSyntheticBlock$Companion;", "", "()V", "isVueInterpolationBorder", "", "child1", "Lcom/intellij/formatting/Block;", "child2", "intellij.vuejs"})
    public static final class Companion {
        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public final boolean isVueInterpolationBorder(@Nullable Block child1, @Nullable Block child2) {
            AnotherLanguageBlockWrapper anotherLanguageBlockWrapper;
            Block block;
            if (!(child1 instanceof VueHtmlBlock)) {
                if (!(child1 instanceof VueBlock)) return false;
            }
            if (!((block = child2) instanceof AnotherLanguageBlockWrapper)) {
                block = null;
            }
            if (!Intrinsics.areEqual((anotherLanguageBlockWrapper = (AnotherLanguageBlockWrapper)block) != null && (anotherLanguageBlockWrapper = anotherLanguageBlockWrapper.getNode()) != null && (anotherLanguageBlockWrapper = anotherLanguageBlockWrapper.getPsi()) != null ? anotherLanguageBlockWrapper.getLanguage() : null, (Object)((Object)VueJSLanguage.Companion.getINSTANCE()))) return false;
            return true;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

