/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions.extractComponent;

import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.util.PathUtilRt;
import com.intellij.util.ThrowableRunnable;
import com.intellij.xml.DefaultXmlExtension;
import com.intellij.xml.XmlExtension;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.codeInsight.tags.VueTagProvider;
import org.jetbrains.vuejs.intentions.extractComponent.VueComponentInplaceIntroducer;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentDataBuilder;
import org.jetbrains.vuejs.intentions.extractComponent.VueExtractComponentRefactoring;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001:\u0001\u000fB#\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\n\u001a\u00020\u000bH\u0002J\u0012\u0010\f\u001a\u00020\r2\n\b\u0002\u0010\u000e\u001a\u0004\u0018\u00010\u000bR\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentRefactoring;", "", "project", "Lcom/intellij/openapi/project/Project;", "list", "", "Lcom/intellij/psi/xml/XmlTag;", "editor", "Lcom/intellij/openapi/editor/Editor;", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;Lcom/intellij/openapi/editor/Editor;)V", "getSelectedText", "", "perform", "", "defaultName", "TagNameValidator", "intellij.vuejs"})
public final class VueExtractComponentRefactoring {
    private final Project project;
    private final List<XmlTag> list;
    private final Editor editor;

    public final void perform(@Nullable String defaultName) {
        block3: {
            block2: {
                if (this.list.isEmpty() || this.list.get(0).getContainingFile() == null) break block2;
                PsiFile psiFile = this.list.get(0).getContainingFile();
                Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"list[0].containingFile");
                if (psiFile.getParent() != null && CommonRefactoringUtil.checkReadOnlyStatus((Project)this.project, (PsiElement)((PsiElement)this.list.get(0).getContainingFile()))) break block3;
            }
            return;
        }
        String oldText = this.getSelectedText();
        VueExtractComponentDataBuilder data = new VueExtractComponentDataBuilder(this.list);
        String refactoringName = VueBundle.message("vue.template.intention.extract.component", new Object[0]);
        CommandProcessor commandProcessor = CommandProcessor.getInstance();
        commandProcessor.executeCommand(this.project, new Runnable(this, refactoringName, data, defaultName, oldText){
            final /* synthetic */ VueExtractComponentRefactoring this$0;
            final /* synthetic */ String $refactoringName;
            final /* synthetic */ VueExtractComponentDataBuilder $data;
            final /* synthetic */ String $defaultName;
            final /* synthetic */ String $oldText;

            /*
             * WARNING - void declaration
             */
            public final void run() {
                void newlyAdded;
                void startMarkAction;
                Ref.ObjectRef objectRef = new Ref.ObjectRef();
                objectRef.element = null;
                TagNameValidator validator = new TagNameValidator((XmlTag)VueExtractComponentRefactoring.access$getList$p(this.this$0).get(0));
                Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
                objectRef2.element = null;
                WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(this, (Ref.ObjectRef)startMarkAction, (Ref.ObjectRef)newlyAdded){
                    final /* synthetic */ perform.1 this$0;
                    final /* synthetic */ Ref.ObjectRef $startMarkAction;
                    final /* synthetic */ Ref.ObjectRef $newlyAdded;

                    public final void run() {
                        PsiElement psiElement;
                        this.$startMarkAction.element = StartMarkAction.start((Editor)VueExtractComponentRefactoring.access$getEditor$p(this.this$0.this$0), (Project)VueExtractComponentRefactoring.access$getProject$p(this.this$0.this$0), (String)this.this$0.$refactoringName);
                        StartMarkAction startMarkAction = (StartMarkAction)this.$startMarkAction.element;
                        Intrinsics.checkNotNull((Object)startMarkAction);
                        startMarkAction.setGlobal(true);
                        VueExtractComponentDataBuilder vueExtractComponentDataBuilder = this.this$0.$data;
                        String string = this.this$0.$defaultName;
                        if (string == null) {
                            string = "NewComponent";
                        }
                        if (!((psiElement = vueExtractComponentDataBuilder.replaceWithNewTag(string)) instanceof XmlTag)) {
                            psiElement = null;
                        }
                        this.$newlyAdded.element = (XmlTag)psiElement;
                    }
                    {
                        this.this$0 = var1_1;
                        this.$startMarkAction = objectRef;
                        this.$newlyAdded = objectRef2;
                    }
                }));
                XmlTag xmlTag = (XmlTag)newlyAdded.element;
                Intrinsics.checkNotNull((Object)xmlTag);
                Editor editor = VueExtractComponentRefactoring.access$getEditor$p(this.this$0);
                Function1 function1 = (Function1)new Function1<String, String>(validator){

                    @Nullable
                    public final String invoke(@NotNull String p1) {
                        Intrinsics.checkNotNullParameter((Object)p1, (String)"p1");
                        return ((TagNameValidator)this.receiver).validate(p1);
                    }
                };
                StartMarkAction startMarkAction2 = (StartMarkAction)startMarkAction.element;
                Intrinsics.checkNotNull((Object)startMarkAction2);
                boolean bl = false;
                new VueComponentInplaceIntroducer(xmlTag, editor, this.$data, this.$oldText, (Function1<? super String, String>)function1, startMarkAction2).performInplaceRefactoring(new LinkedHashSet<String>());
            }
            {
                this.this$0 = vueExtractComponentRefactoring;
                this.$refactoringName = string;
                this.$data = vueExtractComponentDataBuilder;
                this.$defaultName = string2;
                this.$oldText = string3;
            }
        }, refactoringName, (Object)"VueExtractComponent");
    }

    public static /* synthetic */ void perform$default(VueExtractComponentRefactoring vueExtractComponentRefactoring, String string, int n, Object object) {
        if ((n & 1) != 0) {
            string = null;
        }
        vueExtractComponentRefactoring.perform(string);
    }

    private final String getSelectedText() {
        Document document = this.editor.getDocument();
        TextRange textRange = this.list.get(0).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange, (String)"list[0].textRange");
        int n = textRange.getStartOffset();
        TextRange textRange2 = this.list.get(this.list.size() - 1).getTextRange();
        Intrinsics.checkNotNullExpressionValue((Object)textRange2, (String)"list[list.size - 1].textRange");
        String string = document.getText(new TextRange(n, textRange2.getEndOffset()));
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"editor.document.getText(\u2026 1].textRange.endOffset))");
        return string;
    }

    public VueExtractComponentRefactoring(@NotNull Project project, @NotNull List<? extends XmlTag> list, @NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter(list, (String)"list");
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        this.project = project;
        this.list = list;
        this.editor = editor;
    }

    public static final /* synthetic */ List access$getList$p(VueExtractComponentRefactoring $this) {
        return $this.list;
    }

    public static final /* synthetic */ Editor access$getEditor$p(VueExtractComponentRefactoring $this) {
        return $this.editor;
    }

    public static final /* synthetic */ Project access$getProject$p(VueExtractComponentRefactoring $this) {
        return $this.project;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u000b\u001a\u0004\u0018\u00010\u00072\u0006\u0010\f\u001a\u00020\u0007H\u0007R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lorg/jetbrains/vuejs/intentions/extractComponent/VueExtractComponentRefactoring$TagNameValidator;", "", "context", "Lcom/intellij/psi/xml/XmlTag;", "(Lcom/intellij/psi/xml/XmlTag;)V", "alreadyExisting", "", "", "folder", "Lcom/intellij/psi/PsiDirectory;", "forbidden", "validate", "text", "intellij.vuejs"})
    private static final class TagNameValidator {
        private final PsiDirectory folder;
        private final Set<String> forbidden;
        private final Set<String> alreadyExisting;

        @Nls
        @Nullable
        public final String validate(@NotNull String text) {
            boolean bl;
            CharSequence charSequence;
            boolean bl2;
            Locale locale;
            String fileName;
            CharSequence charSequence2;
            String normalized;
            block8: {
                block7: {
                    Intrinsics.checkNotNullParameter((Object)text, (String)"text");
                    String string = text;
                    boolean bl3 = false;
                    normalized = VueUtilKt.fromAsset(((Object)StringsKt.trim((CharSequence)string)).toString());
                    charSequence2 = text;
                    boolean bl4 = false;
                    fileName = StringsKt.capitalize((String)VueUtilKt.toAsset(((Object)StringsKt.trim((CharSequence)charSequence2)).toString())) + ".vue";
                    charSequence2 = normalized;
                    bl4 = false;
                    if (charSequence2.length() == 0 || !PathUtilRt.isValidFileName((String)fileName, (boolean)false) || StringsKt.contains$default((CharSequence)normalized, (char)' ', (boolean)false, (int)2, null)) break block7;
                    charSequence2 = normalized;
                    Locale locale2 = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale2, (String)"Locale.US");
                    locale = locale2;
                    bl2 = false;
                    charSequence = charSequence2;
                    bl = false;
                    CharSequence charSequence3 = charSequence;
                    if (charSequence3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string2 = ((String)charSequence3).toLowerCase(locale);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"(this as java.lang.String).toLowerCase(locale)");
                    if (!this.forbidden.contains(string2)) break block8;
                }
                return VueBundle.message("vue.template.intention.extract.component.error.component.name", normalized);
            }
            charSequence2 = normalized;
            Locale locale3 = Locale.US;
            Intrinsics.checkNotNullExpressionValue((Object)locale3, (String)"Locale.US");
            locale = locale3;
            bl2 = false;
            charSequence = charSequence2;
            bl = false;
            CharSequence charSequence4 = charSequence;
            if (charSequence4 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string = ((String)charSequence4).toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"(this as java.lang.String).toLowerCase(locale)");
            if (this.alreadyExisting.contains(string)) {
                return VueBundle.message("vue.template.intention.extract.component.error.component.exists", normalized);
            }
            if (this.folder.findFile(fileName) != null) {
                return VueBundle.message("vue.template.intention.extract.component.error.file.exists", fileName);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        public TagNameValidator(@NotNull XmlTag context) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            String string;
            Collection<String> collection;
            void $this$mapTo$iv$iv2;
            void $this$map$iv2;
            Intrinsics.checkNotNullParameter((Object)context, (String)"context");
            PsiFile psiFile = context.getContainingFile();
            Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"context.containingFile");
            PsiDirectory psiDirectory = psiFile.getParent();
            Intrinsics.checkNotNull((Object)psiDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)psiDirectory, (String)"context.containingFile.parent!!");
            this.folder = psiDirectory;
            boolean bl = false;
            this.forbidden = new LinkedHashSet();
            bl = false;
            this.alreadyExisting = new LinkedHashSet();
            PsiFile psiFile2 = context.getContainingFile();
            if (psiFile2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.xml.XmlFile");
            }
            List list = DefaultXmlExtension.DEFAULT_EXTENSION.getAvailableTagNames((XmlFile)psiFile2, context);
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"DefaultXmlExtension.DEFA\u2026File as XmlFile, context)");
            Iterable iterable = list;
            Set<String> set = this.forbidden;
            boolean $i$f$map22 = false;
            void var4_7 = $this$map$iv2;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv2, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv2) {
                void it;
                XmlExtension.TagInfo tagInfo = (XmlExtension.TagInfo)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl2 = false;
                string = it.name;
                collection.add(string);
            }
            collection = (List)destination$iv$iv;
            set.addAll(collection);
            $i$f$map22 = false;
            List elements = new ArrayList();
            new VueTagProvider().addTagNameVariants(elements, context, null);
            Iterable $i$f$map22 = elements;
            set = this.alreadyExisting;
            boolean $i$f$map = false;
            destination$iv$iv = $this$map$iv;
            Collection destination$iv$iv2 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo2 = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                LookupElement bl2 = (LookupElement)item$iv$iv;
                collection = destination$iv$iv2;
                boolean bl3 = false;
                String string2 = it.getLookupString();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"it.lookupString");
                string = StringsKt.capitalize((String)VueUtilKt.toAsset(string2));
                collection.add(string);
            }
            collection = (List)destination$iv$iv2;
            set.addAll(collection);
        }
    }
}

