/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.intentions.expandVModel;

import com.intellij.lang.ASTNode;
import com.intellij.lang.javascript.intentions.JavaScriptIntention;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlElementType;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ThrowableRunnable;
import com.intellij.xml.XmlElementDescriptor;
import java.util.Collection;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser;
import org.jetbrains.vuejs.codeInsight.tags.VueElementDescriptor;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.intentions.expandVModel.VueExpandVModelIntention;
import org.jetbrains.vuejs.model.VueModelDirectiveProperties;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0005H\u0016J\b\u0010\u0007\u001a\u00020\u0005H\u0016J#\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0096\u0002J\"\u0010\u0010\u001a\u00020\u00112\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0012\u001a\u00020\u000fH\u0016J\u0010\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lorg/jetbrains/vuejs/intentions/expandVModel/VueExpandVModelIntention;", "Lcom/intellij/lang/javascript/intentions/JavaScriptIntention;", "()V", "validModifiers", "", "", "getFamilyName", "getText", "invoke", "", "project", "Lcom/intellij/openapi/project/Project;", "editor", "Lcom/intellij/openapi/editor/Editor;", "psiElement", "Lcom/intellij/psi/PsiElement;", "isAvailable", "", "element", "isValidVModel", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "intellij.vuejs"})
public final class VueExpandVModelIntention
extends JavaScriptIntention {
    private final Set<String> validModifiers = SetsKt.setOf((Object[])new String[]{"lazy", "number", "trim"});

    @NotNull
    public String getFamilyName() {
        return VueBundle.message("vue.template.intention.v-model.expand.family.name", new Object[0]);
    }

    @NotNull
    public String getText() {
        return this.getFamilyName();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvailable(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement element) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        ASTNode aSTNode = element.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"element.node");
        if (!Intrinsics.areEqual((Object)aSTNode.getElementType(), (Object)XmlElementType.XML_NAME)) return false;
        PsiElement psiElement = element.getParent();
        if (!Intrinsics.areEqual((Object)(psiElement != null && (psiElement = psiElement.getNode()) != null ? psiElement.getElementType() : null), (Object)XmlElementType.XML_ATTRIBUTE)) return false;
        PsiElement psiElement2 = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
        if (!psiElement2.isValid()) return false;
        PsiElement psiElement3 = element.getParent();
        if (psiElement3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.xml.XmlAttribute");
        }
        XmlTag xmlTag = ((XmlAttribute)psiElement3).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"(element.parent as XmlAttribute).parent");
        if (!(xmlTag.getDescriptor() instanceof VueElementDescriptor)) return false;
        PsiElement psiElement4 = element.getParent();
        if (psiElement4 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.xml.XmlAttribute");
        }
        if (!this.isValidVModel((XmlAttribute)psiElement4)) return false;
        if (!VueContextKt.isVueContext(element)) return false;
        return true;
    }

    private final boolean isValidVModel(XmlAttribute attribute) {
        String string = attribute.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"attribute.name");
        CharSequence charSequence = string;
        XmlTag xmlTag = attribute.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"attribute.parent");
        VueAttributeNameParser.VueAttributeInfo info2 = VueAttributeNameParser.Companion.parse(charSequence, xmlTag);
        VueAttributeNameParser.VueAttributeInfo vueAttributeInfo = info2;
        if (!(vueAttributeInfo instanceof VueAttributeNameParser.VueDirectiveInfo)) {
            vueAttributeInfo = null;
        }
        VueAttributeNameParser.VueDirectiveInfo vueDirectiveInfo = (VueAttributeNameParser.VueDirectiveInfo)vueAttributeInfo;
        return (vueDirectiveInfo != null ? vueDirectiveInfo.getDirectiveKind() : null) == VueAttributeNameParser.VueDirectiveKind.MODEL && this.validModifiers.containsAll((Collection)info2.getModifiers());
    }

    /*
     * WARNING - void declaration
     */
    public void invoke(@NotNull Project project, @Nullable Editor editor, @NotNull PsiElement psiElement) {
        void event;
        void eventValue;
        XmlTag componentTag;
        PsiElement parent2;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)psiElement, (String)"psiElement");
        if (editor == null) {
            return;
        }
        PsiElement psiElement2 = psiElement.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"psiElement.parent");
        PsiElement psiElement3 = parent2 = psiElement2;
        if (psiElement3 == null) {
            throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.xml.XmlAttribute");
        }
        XmlAttribute modelAttribute = (XmlAttribute)psiElement3;
        XmlTag xmlTag = componentTag = modelAttribute.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"componentTag");
        XmlElementDescriptor xmlElementDescriptor = xmlTag.getDescriptor();
        if (!(xmlElementDescriptor instanceof VueElementDescriptor)) {
            xmlElementDescriptor = null;
        }
        VueElementDescriptor vueElementDescriptor = (VueElementDescriptor)xmlElementDescriptor;
        if (vueElementDescriptor == null) {
            return;
        }
        VueElementDescriptor componentDescriptor = vueElementDescriptor;
        VueModelDirectiveProperties model = componentDescriptor.getModel();
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = model.getEvent();
        String prop = model.getProp();
        String string = ((XmlAttribute)parent2).getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"parent.name");
        CharSequence charSequence = string;
        XmlTag xmlTag2 = ((XmlAttribute)parent2).getParent();
        Intrinsics.checkNotNullExpressionValue((Object)xmlTag2, (String)"parent.parent");
        VueAttributeNameParser.VueAttributeInfo info2 = VueAttributeNameParser.Companion.parse(charSequence, xmlTag2);
        Set<String> modifiers2 = info2.getModifiers();
        Ref.ObjectRef objectRef2 = new Ref.ObjectRef();
        objectRef2.element = "$event";
        if (modifiers2.contains("trim")) {
            eventValue.element = "typeof " + (String)eventValue.element + " === 'string' ? " + (String)eventValue.element + ".trim() : " + (String)eventValue.element;
        }
        if (modifiers2.contains("number")) {
            eventValue.element = "isNaN(parseFloat(" + (String)eventValue.element + ")) ? " + (String)eventValue.element + " : parseFloat(" + (String)eventValue.element + ')';
        }
        if (modifiers2.contains("lazy")) {
            event.element = "change";
        }
        CommandProcessor.getInstance().executeCommand(project, new Runnable(modelAttribute, prop, componentTag, (Ref.ObjectRef)event, (Ref.ObjectRef)eventValue){
            final /* synthetic */ XmlAttribute $modelAttribute;
            final /* synthetic */ String $prop;
            final /* synthetic */ XmlTag $componentTag;
            final /* synthetic */ Ref.ObjectRef $event;
            final /* synthetic */ Ref.ObjectRef $eventValue;

            public final void run() {
                WriteAction.run((ThrowableRunnable)((ThrowableRunnable)new ThrowableRunnable<RuntimeException>(this){
                    final /* synthetic */ invoke.1 this$0;

                    public final void run() {
                        this.this$0.$modelAttribute.setName(':' + this.this$0.$prop);
                        this.this$0.$componentTag.setAttribute('@' + (String)this.this$0.$event.element, this.this$0.$modelAttribute.getValue() + " = " + (String)this.this$0.$eventValue.element);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }));
            }
            {
                this.$modelAttribute = xmlAttribute;
                this.$prop = string;
                this.$componentTag = xmlTag;
                this.$event = objectRef;
                this.$eventValue = objectRef2;
            }
        }, VueBundle.message("vue.template.intention.v-model.expand.command.name", new Object[0]), (Object)"VueExpandVModel");
    }
}

