/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.inspections;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.lang.javascript.JSAnalysisHandlersFactory;
import com.intellij.lang.javascript.highlighting.JSFixFactory;
import com.intellij.lang.javascript.psi.JSArgumentList;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSFunction;
import com.intellij.lang.javascript.psi.JSFunctionItem;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.validation.JSFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.JSProblemReporter;
import com.intellij.lang.javascript.validation.JSReferenceChecker;
import com.intellij.lang.javascript.validation.JSTypeChecker;
import com.intellij.lang.javascript.validation.JavaScriptFunctionSignatureChecker;
import com.intellij.lang.javascript.validation.ValidateTypesUtil;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.ResolveResult;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.VueBundle;
import org.jetbrains.vuejs.lang.expr.psi.VueJSFilterExpression;
import org.jetbrains.vuejs.lang.expr.psi.VueJSFilterReferenceExpression;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0016J\u0014\u0010\u0007\u001a\u00020\b2\n\u0010\t\u001a\u0006\u0012\u0002\b\u00030\nH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/vuejs/inspections/VueAnalysisHandlersFactory;", "Lcom/intellij/lang/javascript/JSAnalysisHandlersFactory;", "()V", "getFunctionSignatureChecker", "Lcom/intellij/lang/javascript/validation/JSFunctionSignatureChecker;", "holder", "Lcom/intellij/codeInspection/ProblemsHolder;", "getReferenceChecker", "Lcom/intellij/lang/javascript/validation/JSReferenceChecker;", "reporter", "Lcom/intellij/lang/javascript/validation/JSProblemReporter;", "intellij.vuejs"})
public final class VueAnalysisHandlersFactory
extends JSAnalysisHandlersFactory {
    @NotNull
    public JSFunctionSignatureChecker getFunctionSignatureChecker(@NotNull ProblemsHolder holder) {
        Intrinsics.checkNotNullParameter((Object)holder, (String)"holder");
        JSTypeChecker jSTypeChecker = this.getTypeChecker(holder);
        Intrinsics.checkNotNullExpressionValue((Object)jSTypeChecker, (String)"getTypeChecker(holder)");
        JSTypeChecker typeChecker = jSTypeChecker;
        return (JSFunctionSignatureChecker)new JavaScriptFunctionSignatureChecker(holder, typeChecker, typeChecker){
            final /* synthetic */ ProblemsHolder $holder;
            final /* synthetic */ JSTypeChecker $typeChecker;

            protected boolean checkParameterLength(@NotNull JSCallExpression node, @Nullable JSFunctionItem function, @NotNull JSExpression[] expressions, @NotNull List<LocalQuickFix> fixes, @NotNull Trinity<Integer, Integer, Boolean> minMaxParameters, int actualParameterLength) {
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)expressions, (String)"expressions");
                Intrinsics.checkNotNullParameter(fixes, (String)"fixes");
                Intrinsics.checkNotNullParameter(minMaxParameters, (String)"minMaxParameters");
                if (node instanceof VueJSFilterExpression) {
                    Integer min = (Integer)minMaxParameters.first;
                    Integer max = (Integer)minMaxParameters.second;
                    JSArgumentList argumentList = ((VueJSFilterExpression)node).getArgumentList();
                    Integer n = max;
                    Intrinsics.checkNotNullExpressionValue((Object)n, (String)"max");
                    int n2 = expressions.length;
                    if (min <= n2 && n >= n2) {
                        return true;
                    }
                    if (function instanceof JSFunction) {
                        LocalQuickFix localQuickFix = JSFixFactory.getInstance().changeSignatureFix((JSFunction)function, argumentList);
                        Intrinsics.checkNotNullExpressionValue((Object)localQuickFix, (String)"JSFixFactory.getInstance\u2026SFunction?, argumentList)");
                        fixes.add(localQuickFix);
                    }
                    if (argumentList != null && argumentList.hasSpreadElement()) {
                        int n3 = expressions.length;
                        Integer n4 = min;
                        Intrinsics.checkNotNullExpressionValue((Object)n4, (String)"min");
                        if (n3 < n4) {
                            return false;
                        }
                    }
                    Integer n5 = min;
                    if (n5 != null && n5 == 0 && max == 0) {
                        Collection $this$toTypedArray$iv = fixes;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                        if (localQuickFixArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        this.registerProblem(node, VueBundle.message("vue.inspection.message.filter.function.with.no.args", new Object[0]), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                    } else {
                        Integer n6 = min;
                        StringBuilder stringBuilder = new StringBuilder().append(n6 != null && n6 == 0 ? 0 : min - 1);
                        Object object = minMaxParameters.third;
                        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"minMaxParameters.third");
                        String s = stringBuilder.append((Boolean)object != false ? " or more" : (Intrinsics.areEqual((Object)min, (Object)max) ^ true ? ".." + (max - 1) : "")).toString();
                        Collection $this$toTypedArray$iv = fixes;
                        boolean $i$f$toTypedArray = false;
                        Collection thisCollection$iv = $this$toTypedArray$iv;
                        LocalQuickFix[] localQuickFixArray = thisCollection$iv.toArray(new LocalQuickFix[0]);
                        if (localQuickFixArray == null) {
                            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
                        }
                        this.registerProblem(node, VueBundle.message("vue.inspection.message.filter.invalid.number.of.arguments", s), Arrays.copyOf(localQuickFixArray, localQuickFixArray.length));
                    }
                    return false;
                }
                return super.checkParameterLength(node, function, expressions, fixes, minMaxParameters, actualParameterLength);
            }

            protected void registerProblem(@NotNull JSCallExpression callExpression, @NotNull String message, LocalQuickFix ... fixes) {
                Object object;
                Intrinsics.checkNotNullParameter((Object)callExpression, (String)"callExpression");
                Intrinsics.checkNotNullParameter((Object)message, (String)"message");
                Intrinsics.checkNotNullParameter((Object)fixes, (String)"fixes");
                JSCallExpression jSCallExpression = callExpression;
                if (!(jSCallExpression instanceof VueJSFilterExpression)) {
                    jSCallExpression = null;
                }
                PsiElement psiElement = (object = (VueJSFilterExpression)jSCallExpression) != null && (object = object.getFilterArgumentsList()) != null ? (PsiElement)object : ValidateTypesUtil.getPlaceForSignatureProblem((JSCallExpression)callExpression, null);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"(callExpression as? VueJ\u2026lem(callExpression, null)");
                PsiElement place = psiElement;
                this.$holder.registerProblem(place, message, Arrays.copyOf(fixes, fixes.length));
            }
            {
                this.$holder = $captured_local_variable$0;
                this.$typeChecker = $captured_local_variable$1;
                super($super_call_param$2);
            }
        };
    }

    @NotNull
    public JSReferenceChecker getReferenceChecker(@NotNull JSProblemReporter<?> reporter) {
        Intrinsics.checkNotNullParameter(reporter, (String)"reporter");
        return new JSReferenceChecker(reporter, reporter){
            final /* synthetic */ JSProblemReporter $reporter;

            protected boolean addCreateFromUsageFixes(@Nullable JSReferenceExpression node, @Nullable ResolveResult[] resolveResults, @Nullable List<LocalQuickFix> fixes, boolean inTypeContext, boolean ecma) {
                return inTypeContext;
            }

            protected void addCreateFromUsageFixesForCall(@NotNull JSReferenceExpression referenceExpression, boolean isNewExpression, @NotNull ResolveResult[] resolveResults, @NotNull List<LocalQuickFix> quickFixes) {
                Intrinsics.checkNotNullParameter((Object)referenceExpression, (String)"referenceExpression");
                Intrinsics.checkNotNullParameter((Object)resolveResults, (String)"resolveResults");
                Intrinsics.checkNotNullParameter(quickFixes, (String)"quickFixes");
                if (referenceExpression instanceof VueJSFilterReferenceExpression) {
                    return;
                }
                LocalQuickFix localQuickFix = JSFixFactory.getInstance().renameReferenceFix();
                Intrinsics.checkNotNullExpressionValue((Object)localQuickFix, (String)"JSFixFactory.getInstance().renameReferenceFix()");
                quickFixes.add(localQuickFix);
            }

            @NotNull
            protected String createUnresolvedCallReferenceMessage(@NotNull JSReferenceExpression methodExpression, boolean isNewExpression) {
                String string;
                Intrinsics.checkNotNullParameter((Object)methodExpression, (String)"methodExpression");
                if (methodExpression instanceof VueJSFilterReferenceExpression) {
                    Object[] objectArray = new Object[1];
                    String string2 = ((VueJSFilterReferenceExpression)methodExpression).getReferenceName();
                    Intrinsics.checkNotNull((Object)string2);
                    Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"methodExpression.referenceName!!");
                    objectArray[0] = string2;
                    string = VueBundle.message("vue.inspection.message.unresolved.filter", objectArray);
                } else {
                    String string3 = super.createUnresolvedCallReferenceMessage(methodExpression, isNewExpression);
                    string = string3;
                    Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"super.createUnresolvedCa\u2026ression, isNewExpression)");
                }
                return string;
            }
            {
                this.$reporter = $captured_local_variable$0;
                super($super_call_param$1);
            }
        };
    }
}

