/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.editor;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.LanguageUtil;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.lang.javascript.JSInjectionBracesUtil;
import com.intellij.lang.javascript.index.JavaScriptIndex;
import com.intellij.lang.javascript.injections.JSFormattableInjectionUtil;
import com.intellij.lang.javascript.injections.JSInjectionUtil;
import com.intellij.lang.javascript.psi.JSDefinitionExpression;
import com.intellij.lang.javascript.psi.JSEmbeddedContent;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSObjectLiteralExpression;
import com.intellij.lang.javascript.psi.JSProperty;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.impl.JSLiteralExpressionImpl;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.navigation.NavigationItem;
import com.intellij.openapi.project.Project;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.impl.source.html.HtmlDocumentImpl;
import com.intellij.psi.impl.source.xml.XmlAttributeValueImpl;
import com.intellij.psi.impl.source.xml.XmlTextImpl;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.NullableFunction;
import com.intellij.util.PairFunction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.codeInsight.VueUtilKt;
import org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser;
import org.jetbrains.vuejs.codeInsight.tags.VueTagProviderKt;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.editor.VueInjector;
import org.jetbrains.vuejs.index.VueFrameworkHandler;
import org.jetbrains.vuejs.index.VueIndexKt;
import org.jetbrains.vuejs.index.VueOptionsIndex;
import org.jetbrains.vuejs.lang.expr.VueJSLanguage;
import org.jetbrains.vuejs.lang.html.VueLanguage;
import org.jetbrains.vuejs.model.VueComponent;
import org.jetbrains.vuejs.model.VueModelManager;
import org.jetbrains.vuejs.model.VueRegularComponent;
import org.jetbrains.vuejs.model.source.VueComponents;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00060\u00050\u0004H\u0016J\u0018\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0006H\u0016J \u0010\f\u001a\u00020\b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\u00a8\u0006\u0018"}, d2={"Lorg/jetbrains/vuejs/editor/VueInjector;", "Lcom/intellij/lang/injection/MultiHostInjector;", "()V", "elementsToInjectIn", "", "Ljava/lang/Class;", "Lcom/intellij/psi/PsiElement;", "getLanguagesToInject", "", "registrar", "Lcom/intellij/lang/injection/MultiHostRegistrar;", "context", "injectInElement", "host", "Lcom/intellij/psi/PsiLanguageInjectionHost;", "attributeName", "", "shouldInjectVueTemplate", "", "template", "Lcom/intellij/lang/javascript/psi/impl/JSLiteralExpressionImpl;", "initializer", "Lcom/intellij/lang/javascript/psi/JSObjectLiteralExpression;", "Companion", "intellij.vuejs"})
public final class VueInjector
implements MultiHostInjector {
    private static final Set<String> delimitersOptionHolders;
    @NotNull
    private static final NullableFunction<PsiElement, com.intellij.openapi.util.Pair<String, String>> BRACES_FACTORY;
    @NotNull
    public static final Companion Companion;

    public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
        com.intellij.openapi.util.Pair braces;
        boolean bl;
        Object object;
        PsiElement psiElement;
        XmlTextImpl embedded;
        boolean bl2;
        Intrinsics.checkNotNullParameter((Object)registrar, (String)"registrar");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        PsiElement parent2 = context.getParent();
        if (parent2 == null || !VueContextKt.isVueContext(context)) {
            return;
        }
        if (context instanceof XmlAttributeValueImpl) {
            String string = ((XmlAttributeValueImpl)context).getValue();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"context.value");
            CharSequence charSequence = string;
            bl2 = false;
            if (!StringsKt.isBlank((CharSequence)charSequence) && parent2 instanceof XmlAttribute && ((XmlAttribute)parent2).getParent() != null) {
                String string2 = ((XmlAttribute)parent2).getName();
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"parent.name");
                CharSequence charSequence2 = string2;
                XmlTag xmlTag = ((XmlAttribute)parent2).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)xmlTag, (String)"parent.parent");
                if (VueAttributeNameParser.Companion.parse(charSequence2, xmlTag).getInjectJS()) {
                    if (((XmlAttribute)parent2).getLanguage() != VueLanguage.Companion.getINSTANCE()) {
                        embedded = (JSEmbeddedContent)PsiTreeUtil.getChildOfType((PsiElement)context, JSEmbeddedContent.class);
                        if (embedded != null) {
                            JSLiteralExpressionImpl literal = (JSLiteralExpressionImpl)PsiTreeUtil.getChildOfType((PsiElement)((PsiElement)embedded), JSLiteralExpressionImpl.class);
                            if (literal != null && literal.isValidHost()) {
                                PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)literal;
                                String string3 = ((XmlAttribute)parent2).getName();
                                Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"parent.name");
                                this.injectInElement(psiLanguageInjectionHost, registrar, string3);
                            }
                        } else {
                            PsiLanguageInjectionHost psiLanguageInjectionHost = (PsiLanguageInjectionHost)context;
                            String string4 = ((XmlAttribute)parent2).getName();
                            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"parent.name");
                            this.injectInElement(psiLanguageInjectionHost, registrar, string4);
                        }
                    }
                    return;
                }
            }
        }
        if (!((psiElement = context) instanceof XmlTextImpl)) {
            psiElement = null;
        }
        if ((object = (XmlTextImpl)psiElement) != null && (object = object.getParent()) != null) {
            XmlTextImpl $this$castSafelyTo$iv;
            embedded = object;
            boolean $i$f$castSafelyTo = false;
            XmlTextImpl xmlTextImpl = $this$castSafelyTo$iv;
            if (!(xmlTextImpl instanceof XmlTag)) {
                xmlTextImpl = null;
            }
            if ((object = (XmlTag)xmlTextImpl) != null) {
                $this$castSafelyTo$iv = object;
                bl2 = false;
                bl = false;
                XmlTextImpl it = $this$castSafelyTo$iv;
                boolean bl3 = false;
                object = it.getContext() instanceof HtmlDocumentImpl ? $this$castSafelyTo$iv : null;
                if (object != null) {
                    $this$castSafelyTo$iv = object;
                    bl2 = false;
                    bl = false;
                    it = $this$castSafelyTo$iv;
                    boolean bl4 = false;
                    Map<String, Function2<XmlTag, XmlTextImpl, Language>> map2 = VueTagProviderKt.getCUSTOM_TOP_LEVEL_TAGS();
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"it.name");
                    String string5 = string;
                    Locale locale = Locale.US;
                    Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.US");
                    Locale locale2 = locale;
                    boolean bl5 = false;
                    String string6 = string5;
                    boolean bl6 = false;
                    String string7 = string6;
                    if (string7 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string8 = string7.toLowerCase(locale2);
                    Intrinsics.checkNotNullExpressionValue((Object)string8, (String)"(this as java.lang.String).toLowerCase(locale)");
                    Function2<XmlTag, XmlTextImpl, Language> function2 = map2.get(string8);
                    object = function2 != null ? (Language)function2.invoke((Object)it, (Object)context) : null;
                    if (object != null) {
                        $this$castSafelyTo$iv = object;
                        bl2 = false;
                        bl = false;
                        it = $this$castSafelyTo$iv;
                        boolean bl7 = false;
                        object = LanguageUtil.isInjectableLanguage((Language)it) ? $this$castSafelyTo$iv : null;
                        if (object != null) {
                            $this$castSafelyTo$iv = object;
                            bl2 = false;
                            bl = false;
                            it = $this$castSafelyTo$iv;
                            boolean bl8 = false;
                            registrar.startInjecting((Language)it).addPlace(null, null, (PsiLanguageInjectionHost)context, ElementManipulators.getValueTextRange((PsiElement)context)).doneInjecting();
                            return;
                        }
                    }
                }
            }
        }
        if (context instanceof XmlTextImpl || context instanceof XmlAttributeValueImpl) {
            com.intellij.openapi.util.Pair pair = (com.intellij.openapi.util.Pair)BRACES_FACTORY.fun((Object)context);
            if (pair == null) {
                return;
            }
            Intrinsics.checkNotNullExpressionValue((Object)pair, (String)"BRACES_FACTORY.`fun`(context) ?: return");
            braces = pair;
            JSInjectionBracesUtil.injectInXmlTextByDelimiters((MultiHostRegistrar)registrar, (PsiElement)context, (Language)((Language)VueJSLanguage.Companion.getINSTANCE()), (String)((String)braces.getFirst()), (String)((String)braces.getSecond()), (String)"int");
        } else if (context instanceof JSLiteralExpressionImpl && ((JSLiteralExpressionImpl)context).isQuotedLiteral() && ((JSLiteralExpressionImpl)context).isValidHost() && parent2 instanceof JSProperty && Intrinsics.areEqual((Object)((JSProperty)parent2).getName(), (Object)"template") && ((JSProperty)parent2).getParent() instanceof JSObjectLiteralExpression) {
            PsiElement psiElement2 = ((JSProperty)parent2).getParent();
            if (psiElement2 == null) {
                throw new NullPointerException("null cannot be cast to non-null type com.intellij.lang.javascript.psi.JSObjectLiteralExpression");
            }
            if (this.shouldInjectVueTemplate((JSLiteralExpressionImpl)context, (JSObjectLiteralExpression)psiElement2)) {
                com.intellij.openapi.util.Pair pair;
                com.intellij.openapi.util.Pair pair2;
                Pair<String, String> pair3;
                PsiElement psiElement3 = ((JSProperty)parent2).getParent();
                Intrinsics.checkNotNullExpressionValue((Object)psiElement3, (String)"parent.parent");
                VueComponent vueComponent = VueModelManager.Companion.getComponent(psiElement3);
                if (!(vueComponent instanceof VueRegularComponent)) {
                    vueComponent = null;
                }
                if ((pair3 = (Pair<String, String>)vueComponent) != null && (pair3 = pair3.getDelimiters()) != null) {
                    Pair<String, String> pair4 = pair3;
                    bl = false;
                    boolean bl9 = false;
                    Pair<String, String> it = pair4;
                    boolean bl10 = false;
                    pair2 = new com.intellij.openapi.util.Pair(it.getFirst(), it.getSecond());
                } else {
                    pair2 = pair = (com.intellij.openapi.util.Pair)BRACES_FACTORY.fun((Object)context);
                }
                if (pair2 == null) {
                    pair = new com.intellij.openapi.util.Pair((Object)"{{", (Object)"}}");
                }
                braces = pair;
                JSInjectionUtil.injectInQuotedLiteral((MultiHostRegistrar)registrar, (Language)((Language)VueLanguage.Companion.getINSTANCE()), (String)((String)braces.first + '.' + (String)braces.second + ".#@injected@#.html"), (JSLiteralExpression)((JSLiteralExpression)context), null, null);
                JSFormattableInjectionUtil.setReformattableInjection((PsiElement)context, (Language)((Language)VueLanguage.Companion.getINSTANCE()));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean shouldInjectVueTemplate(JSLiteralExpressionImpl template2, JSObjectLiteralExpression initializer2) {
        ASTNode aSTNode = template2.getNode();
        Intrinsics.checkNotNullExpressionValue((Object)aSTNode, (String)"template.node");
        CharSequence charSequence = aSTNode.getChars();
        Intrinsics.checkNotNullExpressionValue((Object)charSequence, (String)"template.node.chars");
        CharSequence chars = charSequence;
        if (chars.length() > 2 && chars.charAt(1) == '#') {
            return false;
        }
        if (VueFrameworkHandler.Companion.hasComponentIndicatorProperties(initializer2, "template")) return true;
        ES6Decorator eS6Decorator = (ES6Decorator)PsiTreeUtil.getContextOfType((PsiElement)((PsiElement)initializer2), (Class[])new Class[]{ES6Decorator.class});
        if (eS6Decorator == null) return false;
        ES6Decorator eS6Decorator2 = eS6Decorator;
        boolean bl = false;
        boolean bl2 = false;
        ES6Decorator it = eS6Decorator2;
        boolean bl3 = false;
        ES6Decorator eS6Decorator3 = it;
        Intrinsics.checkNotNullExpressionValue((Object)eS6Decorator3, (String)"it");
        if (!VueComponents.Companion.isComponentDecorator(eS6Decorator3)) return false;
        return true;
    }

    private final void injectInElement(PsiLanguageInjectionHost host, MultiHostRegistrar registrar, String attributeName) {
        registrar.startInjecting((Language)VueJSLanguage.Companion.getINSTANCE(), StringsKt.replace$default((String)attributeName, (char)'.', (char)' ', (boolean)false, (int)4, null) + ".expr").addPlace(null, null, host, ElementManipulators.getValueTextRange((PsiElement)((PsiElement)host))).doneInjecting();
    }

    @NotNull
    public List<Class<? extends PsiElement>> elementsToInjectIn() {
        return CollectionsKt.listOf((Object[])new Class[]{XmlTextImpl.class, XmlAttributeValueImpl.class, JSLiteralExpressionImpl.class});
    }

    static {
        Companion = new Companion(null);
        delimitersOptionHolders = SetsKt.setOf((Object[])new String[]{"Vue.config.delimiters", "Vue.options.delimiters"});
        NullableFunction nullableFunction = JSInjectionBracesUtil.delimitersFactory((String)VueJSLanguage.Companion.getINSTANCE().getDisplayName(), (NullableFunction)Companion.BRACES_FACTORY.1.INSTANCE, (PairFunction)Companion.BRACES_FACTORY.2.INSTANCE);
        Intrinsics.checkNotNullExpressionValue((Object)nullableFunction, (String)"JSInjectionBracesUtil.de\u2026nt(project, key)\n      })");
        BRACES_FACTORY = nullableFunction;
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\f\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J&\u0010\u0010\u001a\u0010\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00062\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0002J\u001a\u0010\u0011\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0007H\u0002R)\u0010\u0003\u001a\u001a\u0012\u0004\u0012\u00020\u0005\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u00060\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00070\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lorg/jetbrains/vuejs/editor/VueInjector$Companion;", "", "()V", "BRACES_FACTORY", "Lcom/intellij/util/NullableFunction;", "Lcom/intellij/psi/PsiElement;", "Lcom/intellij/openapi/util/Pair;", "", "getBRACES_FACTORY", "()Lcom/intellij/util/NullableFunction;", "delimitersOptionHolders", "", "calculateDelimitersFromAssignment", "project", "Lcom/intellij/openapi/project/Project;", "key", "calculateDelimitersFromIndex", "getDelimiterValue", "holder", "intellij.vuejs"})
    public static final class Companion {
        @NotNull
        public final NullableFunction<PsiElement, com.intellij.openapi.util.Pair<String, String>> getBRACES_FACTORY() {
            return BRACES_FACTORY;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final com.intellij.openapi.util.Pair<String, PsiElement> calculateDelimitersFromIndex(Project project, String key2) {
            JSObjectLiteralExpression jSObjectLiteralExpression;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.projectScope((Project)project);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.projectScope(project)");
            Collection<JSImplicitElement> collection = VueIndexKt.resolve("", globalSearchScope, VueOptionsIndex.Companion.getKEY());
            if (collection == null) return null;
            Collection<JSImplicitElement> elements = collection;
            JSImplicitElement jSImplicitElement = (JSImplicitElement)CollectionsKt.firstOrNull(VueComponents.Companion.onlyLocal(elements));
            if (jSImplicitElement == null) return null;
            JSImplicitElement element = jSImplicitElement;
            JSImplicitElement jSImplicitElement2 = element;
            if (!(jSImplicitElement2 instanceof JSObjectLiteralExpression)) {
                jSImplicitElement2 = null;
            }
            if ((jSObjectLiteralExpression = (JSObjectLiteralExpression)jSImplicitElement2) == null) {
                jSObjectLiteralExpression = (JSObjectLiteralExpression)PsiTreeUtil.getParentOfType((PsiElement)((PsiElement)element), JSObjectLiteralExpression.class);
            }
            if (jSObjectLiteralExpression == null) return null;
            JSObjectLiteralExpression obj = jSObjectLiteralExpression;
            JSProperty jSProperty = obj.findProperty("delimiters");
            Object object = jSProperty;
            if (jSProperty == null) return null;
            JSProperty jSProperty2 = object;
            boolean bl = false;
            boolean bl2 = false;
            JSProperty it = jSProperty2;
            boolean bl3 = false;
            JSProperty jSProperty3 = it;
            Intrinsics.checkNotNullExpressionValue((Object)jSProperty3, (String)"it");
            String string = Companion.getDelimiterValue((PsiElement)jSProperty3, key2);
            object = string;
            if (string == null) return null;
            jSProperty2 = object;
            bl = false;
            bl2 = false;
            it = jSProperty2;
            boolean bl4 = false;
            com.intellij.openapi.util.Pair pair = com.intellij.openapi.util.Pair.create((Object)it, (Object)element);
            return pair;
        }

        /*
         * WARNING - void declaration
         */
        private final com.intellij.openapi.util.Pair<String, PsiElement> calculateDelimitersFromAssignment(Project project, String key2) {
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            void $this$filterTo$iv$iv;
            NavigationItem[] delimitersDefinitions = JavaScriptIndex.getInstance((Project)project).getSymbolsByName("delimiters", false);
            Intrinsics.checkNotNullExpressionValue((Object)delimitersDefinitions, (String)"delimitersDefinitions");
            Object $this$filter$iv = delimitersDefinitions;
            boolean $i$f$filter = false;
            NavigationItem[] navigationItemArray = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            Iterator iterator = $this$filterTo$iv$iv;
            int n = ((void)iterator).length;
            for (int j = 0; j < n; ++j) {
                void element$iv$iv;
                void it = element$iv$iv = iterator[j];
                boolean bl = false;
                if (!(it instanceof JSDefinitionExpression && ((PsiElement)it).getContext() != null && CollectionsKt.contains((Iterable)delimitersOptionHolders, (Object)((JSDefinitionExpression)it).getQualifiedName()))) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            $this$filter$iv = (List)destination$iv$iv;
            boolean $i$f$map = false;
            $this$filterTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            iterator = $this$mapTo$iv$iv.iterator();
            if (iterator.hasNext()) {
                void it;
                Object item$iv$iv = iterator.next();
                NavigationItem navigationItem = (NavigationItem)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                void v0 = it;
                if (v0 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type com.intellij.psi.PsiElement");
                }
                PsiElement psiElement = ((PsiElement)v0).getContext();
                Intrinsics.checkNotNull((Object)psiElement);
                Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"(it as PsiElement).context!!");
                String delimiter = Companion.getDelimiterValue(psiElement, key2);
                if (delimiter != null) {
                    return com.intellij.openapi.util.Pair.create((Object)delimiter, (Object)it);
                }
                return null;
            }
            return (com.intellij.openapi.util.Pair)CollectionsKt.firstOrNull((List)((List)destination$iv$iv));
        }

        private final String getDelimiterValue(PsiElement holder, String key2) {
            List<JSLiteralExpression> list = VueUtilKt.getStringLiteralsFromInitializerArray(holder);
            if (list.size() != 2) {
                return null;
            }
            JSLiteralExpression jSLiteralExpression = list.get(Intrinsics.areEqual((Object)"startSymbol", (Object)key2) ? 0 : 1);
            if (!(jSLiteralExpression instanceof JSLiteralExpression)) {
                jSLiteralExpression = null;
            }
            if (jSLiteralExpression == null) {
                return null;
            }
            JSLiteralExpression literal = jSLiteralExpression;
            String string = literal.getSignificantValue();
            Intrinsics.checkNotNull((Object)string);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"literal.significantValue!!");
            return VueUtilKt.es6Unquote(string);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }

        public static final /* synthetic */ com.intellij.openapi.util.Pair access$calculateDelimitersFromIndex(Companion $this, Project project, String key2) {
            return $this.calculateDelimitersFromIndex(project, key2);
        }

        public static final /* synthetic */ com.intellij.openapi.util.Pair access$calculateDelimitersFromAssignment(Companion $this, Project project, String key2) {
            return $this.calculateDelimitersFromAssignment(project, key2);
        }
    }
}

