/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.template;

import com.intellij.codeInsight.completion.CompletionUtil;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.ResolveResult;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.function.Function;
import java.util.function.Predicate;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.codeInsight.template.VueTemplateScope;
import org.jetbrains.vuejs.codeInsight.template.VueTemplateScopesProvider;
import org.jetbrains.vuejs.lang.expr.VueJSLanguage;
import org.jetbrains.vuejs.lang.html.VueLanguage;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u001e\u0010\u0007\u001a\u00020\b2\u0006\u0010\u0005\u001a\u00020\u00062\u000e\u0010\t\u001a\n\u0012\u0006\b\u0000\u0012\u00020\u000b0\n\u00a8\u0006\f"}, d2={"Lorg/jetbrains/vuejs/codeInsight/template/VueTemplateScopesResolver;", "", "()V", "checkLanguage", "", "element", "Lcom/intellij/psi/PsiElement;", "resolve", "", "processor", "Lcom/intellij/util/Processor;", "Lcom/intellij/psi/ResolveResult;", "intellij.vuejs"})
public final class VueTemplateScopesResolver {
    @NotNull
    public static final VueTemplateScopesResolver INSTANCE;

    public final void resolve(@NotNull PsiElement element, @NotNull Processor<? super ResolveResult> processor) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter(processor, (String)"processor");
        PsiElement psiElement = CompletionUtil.getOriginalOrSelf((PsiElement)element);
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"CompletionUtil.getOriginalOrSelf(element)");
        PsiElement original = psiElement;
        if (!this.checkLanguage(original)) {
            return;
        }
        PsiFile psiFile = original.getContainingFile();
        Intrinsics.checkNotNullExpressionValue((Object)psiFile, (String)"original.containingFile");
        boolean expressionIsInjected = psiFile.getLanguage().is((Language)VueJSLanguage.Companion.getINSTANCE());
        PsiElement hostElement = null;
        if (expressionIsInjected) {
            hostElement = (PsiElement)InjectedLanguageManager.getInstance((Project)element.getProject()).getInjectionHost(element);
            if (hostElement == null) {
                return;
            }
        } else {
            hostElement = null;
        }
        StreamEx.of((Collection)VueTemplateScopesProvider.Companion.getEP_NAME$intellij_vuejs().getExtensionList()).flatCollection((Function)new Function<VueTemplateScopesProvider, Collection<? extends VueTemplateScope>>(element, hostElement){
            final /* synthetic */ PsiElement $element;
            final /* synthetic */ PsiElement $hostElement;

            public final Collection<? extends VueTemplateScope> apply(VueTemplateScopesProvider provider) {
                return provider.getScopes(this.$element, this.$hostElement);
            }
            {
                this.$element = psiElement;
                this.$hostElement = psiElement2;
            }
        }).findFirst((Predicate)new Predicate<VueTemplateScope>(processor){
            final /* synthetic */ Processor $processor;

            public final boolean test(VueTemplateScope s) {
                return !s.processAllScopesInHierarchy((Processor<? super ResolveResult>)this.$processor);
            }
            {
                this.$processor = processor;
            }
        });
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean checkLanguage(PsiElement element) {
        if (element.getLanguage().is((Language)VueJSLanguage.Companion.getINSTANCE())) return true;
        if (element.getLanguage().is((Language)VueLanguage.Companion.getINSTANCE())) return true;
        if (element.getParent() == null) return false;
        PsiElement psiElement = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement, (String)"element.parent");
        if (psiElement.getLanguage().is((Language)VueJSLanguage.Companion.getINSTANCE())) return true;
        PsiElement psiElement2 = element.getParent();
        Intrinsics.checkNotNullExpressionValue((Object)psiElement2, (String)"element.parent");
        if (!psiElement2.getLanguage().is((Language)VueLanguage.Companion.getINSTANCE())) return false;
        return true;
    }

    private VueTemplateScopesResolver() {
    }

    static {
        VueTemplateScopesResolver vueTemplateScopesResolver;
        INSTANCE = vueTemplateScopesResolver = new VueTemplateScopesResolver();
    }
}

