/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight.attributes;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.lookup.LookupElementBuilder;
import com.intellij.lang.Language;
import com.intellij.lang.css.CSSLanguage;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ProcessingContext;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser;
import org.jetbrains.vuejs.codeInsight.attributes.VueAttributeValueCompletionProvider$WhenMappings;
import org.jetbrains.vuejs.model.VueSlot;
import org.jetbrains.vuejs.model.VueSlotUtilsKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00022\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0014J\u001e\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00060\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0002J\u000e\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00060\tH\u0002R:\u0010\u0004\u001a.\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\t\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00060\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R:\u0010\u000b\u001a.\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u0006 \u0007*\u0015\u0012\f\u0012\n \u0007*\u0004\u0018\u00010\u00060\u00060\t\u00a2\u0006\u0002\b\b0\u0005\u00a2\u0006\u0002\b\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/vuejs/codeInsight/attributes/VueAttributeValueCompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionProvider;", "Lcom/intellij/codeInsight/completion/CompletionParameters;", "()V", "VUE_SCRIPT_LANGUAGE", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "VUE_STYLE_LANGUAGE", "VUE_TEMPLATE_LANGUAGE", "addCompletions", "", "parameters", "context", "Lcom/intellij/util/ProcessingContext;", "result", "Lcom/intellij/codeInsight/completion/CompletionResultSet;", "listOfCompletions", "xmlTag", "Lcom/intellij/psi/xml/XmlTag;", "xmlAttribute", "Lcom/intellij/psi/xml/XmlAttribute;", "vueStyleLanguages", "intellij.vuejs"})
public final class VueAttributeValueCompletionProvider
extends CompletionProvider<CompletionParameters> {
    private final Set<String> VUE_SCRIPT_LANGUAGE;
    private final Set<String> VUE_STYLE_LANGUAGE;
    private final Set<String> VUE_TEMPLATE_LANGUAGE;

    protected void addCompletions(@NotNull CompletionParameters parameters, @NotNull ProcessingContext context, @NotNull CompletionResultSet result) {
        Intrinsics.checkNotNullParameter((Object)parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)result, (String)"result");
        XmlTag xmlTag = (XmlTag)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlTag.class, (boolean)false);
        XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)parameters.getPosition(), XmlAttribute.class, (boolean)false);
        if (xmlTag == null || xmlAttribute == null) {
            return;
        }
        for (String completion : this.listOfCompletions(xmlTag, xmlAttribute)) {
            result.addElement((LookupElement)LookupElementBuilder.create((String)completion));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> listOfCompletions(XmlTag xmlTag, XmlAttribute xmlAttribute) {
        Set set;
        String string = xmlAttribute.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"xmlAttribute.name");
        switch (VueAttributeValueCompletionProvider$WhenMappings.$EnumSwitchMapping$0[VueAttributeNameParser.Companion.parse((CharSequence)string, xmlTag).getKind().ordinal()]) {
            case 1: {
                set = this.VUE_SCRIPT_LANGUAGE;
                break;
            }
            case 2: {
                set = this.VUE_STYLE_LANGUAGE;
                break;
            }
            case 3: {
                set = this.VUE_TEMPLATE_LANGUAGE;
                break;
            }
            case 4: {
                void $this$mapTo$iv$iv;
                Iterable $this$map$iv = VueSlotUtilsKt.getAvailableSlots(xmlAttribute, false);
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    VueSlot vueSlot = (VueSlot)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl = false;
                    String string2 = it.getName();
                    collection.add(string2);
                }
                set = CollectionsKt.toSet((Iterable)((List)destination$iv$iv));
                break;
            }
            default: {
                set = SetsKt.emptySet();
            }
        }
        return set;
    }

    private final Set<String> vueStyleLanguages() {
        boolean bl = false;
        List result = new ArrayList();
        result.add("css");
        CSSLanguage cSSLanguage = CSSLanguage.INSTANCE;
        Intrinsics.checkNotNullExpressionValue((Object)cSSLanguage, (String)"CSSLanguage.INSTANCE");
        List list = cSSLanguage.getDialects();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"CSSLanguage.INSTANCE.dialects");
        Iterable $this$forEach$iv = list;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Locale locale;
            String string;
            Language it = (Language)element$iv;
            boolean bl2 = false;
            Language language2 = it;
            Intrinsics.checkNotNullExpressionValue((Object)language2, (String)"it");
            if (!(Intrinsics.areEqual((Object)language2.getDisplayName(), (Object)"JQuery-CSS") ^ true)) continue;
            Intrinsics.checkNotNullExpressionValue((Object)it.getDisplayName(), (String)"it.displayName");
            Intrinsics.checkNotNullExpressionValue((Object)Locale.US, (String)"Locale.US");
            boolean bl3 = false;
            String string2 = string;
            boolean bl4 = false;
            String string3 = string2;
            if (string3 == null) {
                throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
            }
            String string4 = string3.toLowerCase(locale);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.String).toLowerCase(locale)");
            result.add(string4);
        }
        return CollectionsKt.toSet((Iterable)result);
    }

    public VueAttributeValueCompletionProvider() {
        Set set = ContainerUtil.immutableSet((Object[])new String[]{"js", "ts"});
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"ContainerUtil.immutableSet(\"js\", \"ts\")");
        this.VUE_SCRIPT_LANGUAGE = set;
        this.VUE_STYLE_LANGUAGE = this.vueStyleLanguages();
        Set set2 = ContainerUtil.immutableSet((Object[])new String[]{"html", "pug"});
        Intrinsics.checkNotNullExpressionValue((Object)set2, (String)"ContainerUtil.immutableSet(\"html\", \"pug\")");
        this.VUE_TEMPLATE_LANGUAGE = set2;
    }
}

