/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.ui.explorer;

import com.intellij.DynamicBundle;
import com.intellij.ide.macro.MacrosDialog;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.ui.ComponentWithBrowseButton;
import com.intellij.openapi.ui.FixedSizeButton;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.table.TableView;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.IconUtil;
import com.intellij.util.ui.AbstractTableCellEditor;
import com.intellij.util.ui.CellEditorComponentWithBrowseButton;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ListTableModel;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileProperty;
import com.jetbrains.php.phing.PhingBundle;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableCellEditor;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NonNls;

public class PhingPropertiesTab {
    private static final Logger LOG = Logger.getInstance(PhingPropertiesTab.class);
    @NonNls
    private static final String REMOVE_KEY = "REMOVE_SELECTED_KEY";
    private TableView<PhingBuildFileProperty> myPropertiesTable;
    private JButton myAddButton;
    private JButton myRemoveButton;
    private JPanel myMainPanel;
    private final ListTableModel<PhingBuildFileProperty> myPropertiesModel;
    private static final ColumnInfo<PhingBuildFileProperty, String> NAME_COLUMN_INFO = new ColumnInfo<PhingBuildFileProperty, String>(PhingBundle.message("property.column.name", new Object[0])){

        public String valueOf(PhingBuildFileProperty phingBuildFileProperty) {
            return phingBuildFileProperty.getName();
        }

        public boolean isCellEditable(PhingBuildFileProperty phingBuildFileProperty) {
            return true;
        }

        public void setValue(PhingBuildFileProperty phingBuildFileProperty, String value) {
            phingBuildFileProperty.setName(value);
        }
    };
    private static final ColumnInfo<PhingBuildFileProperty, String> VALUE_COLUMN_INFO = new ColumnInfo<PhingBuildFileProperty, String>(PhingBundle.message("value.column.name", new Object[0])){

        public String valueOf(PhingBuildFileProperty phingBuildFileProperty) {
            return phingBuildFileProperty.getValue();
        }

        public boolean isCellEditable(PhingBuildFileProperty phingBuildFileProperty) {
            return true;
        }

        public void setValue(PhingBuildFileProperty phingBuildFileProperty, String value) {
            phingBuildFileProperty.setValue(value);
        }

        public TableCellEditor getEditor(PhingBuildFileProperty o) {
            return new PropertyValueCellEditor();
        }
    };

    public PhingPropertiesTab() {
        ColumnInfo[] columnInfoArray = new ColumnInfo[]{NAME_COLUMN_INFO, VALUE_COLUMN_INFO};
        this.$$$setupUI$$$();
        this.myPropertiesModel = new ListTableModel(columnInfoArray);
        this.myPropertiesTable.setModelAndUpdateColumns(this.myPropertiesModel);
        this.myPropertiesTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent e) {
                PhingPropertiesTab.this.updateButtons();
            }
        });
        this.myPropertiesTable.getInputMap(0).put(KeyStroke.getKeyStroke(127, 0), REMOVE_KEY);
        this.myPropertiesTable.getActionMap().put(REMOVE_KEY, new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhingPropertiesTab.this.removeSelected();
            }
        });
        this.myAddButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhingPropertiesTab.this.myPropertiesModel.addRow((Object)new PhingBuildFileProperty());
            }
        });
        this.myRemoveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                PhingPropertiesTab.this.removeSelected();
            }
        });
        this.updateButtons();
    }

    public JPanel getComponent() {
        return this.myMainPanel;
    }

    private void removeSelected() {
        this.myPropertiesModel.removeRow(this.myPropertiesTable.getSelectedRow());
    }

    public void initializeWithBuildFile(PhingBuildFile buildFile) {
        this.myPropertiesModel.addRows(buildFile.getCommandLineProperties());
    }

    private void updateButtons() {
        this.myRemoveButton.setEnabled(this.myPropertiesTable.getSelectedRow() != -1);
    }

    public void writeToBuildFile(PhingBuildFile buildFile) {
        for (int i = 0; i < this.myPropertiesModel.getRowCount(); ++i) {
            PhingBuildFileProperty property = (PhingBuildFileProperty)this.myPropertiesModel.getItem(i);
            if (!StringUtil.isEmptyOrSpaces((String)property.getName()) || !StringUtil.isEmptyOrSpaces((String)property.getValue())) continue;
            this.myPropertiesModel.removeRow(i);
            --i;
        }
        buildFile.setCommandLineProperties(this.myPropertiesModel.getItems());
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JButton jButton;
        JButton jButton2;
        TableView tableView;
        JPanel jPanel;
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(2, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JBScrollPane jBScrollPane = new JBScrollPane();
        jPanel.add((Component)jBScrollPane, new GridConstraints(0, 0, 1, 3, 0, 3, 3, 3, null, null, null));
        this.myPropertiesTable = tableView = new TableView();
        jBScrollPane.setViewportView((Component)tableView);
        this.myAddButton = jButton2 = new JButton();
        this.$$$loadButtonText$$$(jButton2, DynamicBundle.getBundle((String)"messages/PhingBundle", PhingPropertiesTab.class).getString("add.property.button.text"));
        jPanel.add((Component)jButton2, new GridConstraints(1, 0, 1, 1, 0, 1, 3, 0, null, null, null));
        this.myRemoveButton = jButton = new JButton();
        this.$$$loadButtonText$$$(jButton, DynamicBundle.getBundle((String)"messages/PhingBundle", PhingPropertiesTab.class).getString("remove.property.button.text"));
        jPanel.add((Component)jButton, new GridConstraints(1, 1, 1, 1, 0, 1, 3, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(1, 2, 1, 1, 0, 1, 6, 1, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private /* synthetic */ void $$$loadButtonText$$$(AbstractButton abstractButton, String string) {
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        char c = '\u0000';
        int n = -1;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == '&') {
                if (++i == string.length()) break;
                if (!bl && string.charAt(i) != '&') {
                    bl = true;
                    c = string.charAt(i);
                    n = stringBuffer.length();
                }
            }
            stringBuffer.append(string.charAt(i));
        }
        abstractButton.setText(stringBuffer.toString());
        if (bl) {
            abstractButton.setMnemonic(c);
            abstractButton.setDisplayedMnemonicIndex(n);
        }
    }

    private static final class PropertyValueCellEditor
    extends AbstractTableCellEditor {
        private static final Icon PLUS_ICON = IconUtil.getAddIcon();
        private final CellEditorComponentWithBrowseButton<JTextField> myComponent = new CellEditorComponentWithBrowseButton((ComponentWithBrowseButton)new TextFieldWithBrowseButton(), (TableCellEditor)((Object)this));

        private PropertyValueCellEditor() {
            this.getChildComponent().setBorder(BorderFactory.createLineBorder((Color)JBColor.black));
            FixedSizeButton button = this.myComponent.getComponentWithButton().getButton();
            button.setIcon(PLUS_ICON);
            button.setToolTipText(PhingBundle.message("insert.macro.tool.tip", new Object[0]));
            button.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    MacrosDialog.show((JTextComponent)this.getChildComponent());
                }
            });
        }

        public Object getCellEditorValue() {
            return PropertyValueCellEditor.getText(this.getChildComponent());
        }

        @NlsSafe
        private static String getText(JTextField component) {
            return component.getText();
        }

        @NlsSafe
        private JTextField getChildComponent() {
            return (JTextField)this.myComponent.getChildComponent();
        }

        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            this.getChildComponent().setText((String)value);
            return this.myComponent;
        }
    }
}

