/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.phpDependent;

import com.intellij.codeInspection.util.InspectionMessage;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DummyEvaluatedXmlName;
import com.intellij.util.xml.EvaluatedXmlName;
import com.intellij.util.xml.XmlName;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.jetbrains.php.phing.dom.PhingDomRecursiveVisitor;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedAdhocTaskdefTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedAdhocTypedefTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedCustomElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedCustomUnknownElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTagDefiningNamedElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTaskdefTask;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTypedefTask;
import com.jetbrains.php.phing.phpDependent.PhingPhpDependentCustomElementsRegistry;
import com.jetbrains.php.phing.phpDependent.PhingPhpFileDescriptionProvider;
import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingCustomElementsRegistry {
    private static final Key<PhingCustomElementsRegistry> REGISTRY_KEY = Key.create((String)"PhingCustomElementsRegistry");
    private static final PhingPhpFileDescriptionProvider PROVIDER;
    @NonNls
    protected static final String CLASSNAME = "classname";
    private final Set<String> myDefinedTasks = new HashSet<String>();
    private final Set<String> myDefinedTypes = new HashSet<String>();
    private final Map<XmlName, PhingPredefinedTagDefiningNamedElement> myDeclarations = new HashMap<XmlName, PhingPredefinedTagDefiningNamedElement>();

    protected PhingCustomElementsRegistry() {
    }

    private PhingCustomElementsRegistry(PhingPredefinedProject phingProject) {
        phingProject.accept(new CustomTagDefinitionFinder());
    }

    public Map<XmlName, PhingPredefinedTagDefiningNamedElement> getDeclarations() {
        return this.myDeclarations;
    }

    public static PhingCustomElementsRegistry getInstance(PhingPredefinedProject phingDomProject) {
        Project project;
        boolean isDumb;
        PhingCustomElementsRegistry registry = (PhingCustomElementsRegistry)phingDomProject.getUserData(REGISTRY_KEY);
        if (registry == null) {
            Project project2 = phingDomProject.getXmlTag().getContainingFile().getProject();
            boolean isDumb2 = DumbService.getInstance((Project)project2).isDumb();
            registry = PROVIDER != null && !isDumb2 ? PROVIDER.createRegistry(phingDomProject) : new PhingCustomElementsRegistry(phingDomProject);
            phingDomProject.putUserData(REGISTRY_KEY, registry);
        } else if (PROVIDER != null && !PROVIDER.isMine(registry) && !(isDumb = DumbService.getInstance((Project)(project = phingDomProject.getXmlTag().getContainingFile().getProject())).isDumb())) {
            registry = PROVIDER.createRegistry(phingDomProject);
            phingDomProject.putUserData(REGISTRY_KEY, registry);
        }
        return registry;
    }

    public static void registerTypeOrTaskDefiningElement(PhingPredefinedElement element, DomExtensionsRegistrar registrar) {
        if (PROVIDER != null) {
            PROVIDER.registerTypeOrTaskDefiningElement(element, registrar);
            return;
        }
        if (element instanceof PhingPredefinedTaskdefTask || element instanceof PhingPredefinedTypedefTask) {
            DomExtension extension = registrar.registerGenericAttributeValueChildExtension(new XmlName(CLASSNAME, element.getXmlElementNamespace()), String.class);
            if (element instanceof PhingPredefinedTypedefTask) {
                extension.addCustomAnnotation((Annotation)((Object)new PhingPhpDependentCustomElementsRegistry.MyRequired()));
            }
        }
    }

    public static Class getUnknownTagClass() {
        if (PROVIDER != null) {
            return PROVIDER.getUnknownTagClass();
        }
        return PhingPredefinedCustomUnknownElement.class;
    }

    public static String findPhpCommand(Project project) {
        if (PROVIDER != null) {
            return PROVIDER.getPhpCommand(project);
        }
        return SystemInfo.isWindows ? "php.exe" : "php";
    }

    @Nullable
    @InspectionMessage
    public String lookupTypeDefError(PhingPredefinedTagDefiningNamedElement definition) {
        return null;
    }

    public void registerCustomElements(PhingPredefinedElement element, DomExtensionsRegistrar registrar) {
    }

    public Set<EvaluatedXmlName> getCompletionVariantsForCustomTag(@NotNull DomElement parent, boolean addTypes, boolean addTasks) {
        if (parent == null) {
            PhingCustomElementsRegistry.$$$reportNull$$$0(0);
        }
        HashSet<EvaluatedXmlName> result = new HashSet<EvaluatedXmlName>();
        if (addTasks) {
            for (String definedTask : this.myDefinedTasks) {
                result.add((EvaluatedXmlName)new DummyEvaluatedXmlName(definedTask, parent.getXmlElementNamespace()));
            }
        }
        if (addTypes) {
            for (String definedType : this.myDefinedTypes) {
                result.add((EvaluatedXmlName)new DummyEvaluatedXmlName(definedType, parent.getXmlElementNamespace()));
            }
        }
        return result;
    }

    static {
        PhingPhpFileDescriptionProvider[] providers = (PhingPhpFileDescriptionProvider[])PhingPhpFileDescriptionProvider.EP.getExtensions();
        if (providers.length > 0) {
            PROVIDER = providers[0];
            assert (providers.length == 1);
        } else {
            PROVIDER = null;
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "parent", "com/jetbrains/php/phing/phpDependent/PhingCustomElementsRegistry", "getCompletionVariantsForCustomTag"));
    }

    private class CustomTagDefinitionFinder
    extends PhingDomRecursiveVisitor {
        private final Set<PhingPredefinedElement> myElementsOnThePath = new HashSet<PhingPredefinedElement>();

        private CustomTagDefinitionFinder() {
        }

        @Override
        public void visitPhingDomElement(PhingPredefinedElement element) {
            if (element instanceof PhingPredefinedCustomElement || this.myElementsOnThePath.contains(element)) {
                return;
            }
            this.myElementsOnThePath.add(element);
            try {
                super.visitPhingDomElement(element);
            }
            finally {
                this.myElementsOnThePath.remove(element);
            }
        }

        @Override
        public void visitAdHocTaskDef(PhingPredefinedAdhocTaskdefTask taskDefTask) {
            this.visitDefiningElement(taskDefTask);
        }

        @Override
        public void visitAdHocTypeDef(PhingPredefinedAdhocTypedefTask typeDefTask) {
            this.visitDefiningElement(typeDefTask);
        }

        @Override
        public void visitTaskDef(PhingPredefinedTaskdefTask typeDef) {
            this.visitDefiningElement(typeDef);
        }

        @Override
        public void visitTypeDef(PhingPredefinedTypedefTask typeDef) {
            this.visitDefiningElement(typeDef);
        }

        private void visitDefiningElement(PhingPredefinedTagDefiningNamedElement element) {
            String name = (String)element.findName().getValue();
            if (!StringUtil.isEmptyOrSpaces((String)name)) {
                if (element.isTaskDefining()) {
                    PhingCustomElementsRegistry.this.myDefinedTasks.add(name);
                } else {
                    PhingCustomElementsRegistry.this.myDefinedTypes.add(name);
                }
                assert (name != null);
                XmlName xmlName = new XmlName(name, element.getXmlTag().getNamespace());
                PhingCustomElementsRegistry.this.myDeclarations.put(xmlName, element);
            }
        }
    }
}

