/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom.schema;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.JDOMUtil;
import com.jetbrains.php.phing.dom.schema.PhingSchema;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import org.jdom.JDOMException;
import org.jetbrains.annotations.NotNull;

public final class PhingSchemaService {
    private static final Logger LOG = Logger.getInstance(PhingSchemaService.class);
    private PhingSchema mySchema;

    public static PhingSchemaService getInstance(Project project) {
        return (PhingSchemaService)ServiceManager.getService((Project)project, PhingSchemaService.class);
    }

    @NotNull
    public PhingSchema getSchema() {
        if (this.mySchema == null) {
            try {
                this.mySchema = PhingSchemaService.loadSchema();
            }
            catch (IOException e) {
                LOG.error("Failed to load schema for Phing", (Throwable)e);
            }
            catch (JDOMException e) {
                LOG.error("Failed to load schema for Phing", (Throwable)e);
            }
        }
        PhingSchema phingSchema = this.mySchema;
        if (phingSchema == null) {
            PhingSchemaService.$$$reportNull$$$0(0);
        }
        return phingSchema;
    }

    @NotNull
    private static PhingSchema loadSchema() throws IOException, JDOMException {
        InputStream stream = PhingSchemaService.class.getClassLoader().getResourceAsStream("schemas/schema_test.xml");
        if (stream == null) {
            LOG.error("Schema is lost.");
        }
        PhingSchema phingSchema = PhingSchema.read(JDOMUtil.load((InputStream)Objects.requireNonNull(stream)));
        if (phingSchema == null) {
            PhingSchemaService.$$$reportNull$$$0(1);
        }
        return phingSchema;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "com/jetbrains/php/phing/dom/schema/PhingSchemaService";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getSchema";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "loadSchema";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

