/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom.schema;

import com.intellij.openapi.util.Key;
import com.intellij.util.xml.NameValue;
import com.intellij.util.xml.Required;
import com.intellij.util.xml.reflect.DomAttributeChildDescription;
import com.intellij.util.xml.reflect.DomExtension;
import com.intellij.util.xml.reflect.DomExtensionsRegistrar;
import com.jetbrains.php.phing.dom.schema.PhingAttributeConverter;
import com.jetbrains.php.phing.dom.schema.PhingAttributeType;
import java.lang.annotation.Annotation;
import java.util.Comparator;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingAttributeInfo {
    private static final Key<Boolean> NAME_VALUE_KEY = Key.create((String)"phing_name_value_attr");
    public static final Comparator<PhingAttributeInfo> NAME_COMPARATOR = Comparator.comparing(PhingAttributeInfo::getName);
    private final boolean isRequired;
    private final boolean isProperty;
    private final boolean isNameValue;
    private final PhingAttributeConverter myConverter;
    private final String myName;
    private final PhingAttributeType myType;

    public PhingAttributeInfo(@NotNull String name, boolean isRequired, boolean isProperty, boolean isNameValue, @Nullable PhingAttributeConverter converter, @NotNull PhingAttributeType type) {
        if (name == null) {
            PhingAttributeInfo.$$$reportNull$$$0(0);
        }
        if (type == null) {
            PhingAttributeInfo.$$$reportNull$$$0(1);
        }
        this.isRequired = isRequired;
        this.isProperty = isProperty;
        this.isNameValue = isNameValue;
        this.myName = name;
        this.myConverter = converter;
        this.myType = type;
    }

    public boolean isProperty() {
        return this.isProperty;
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            PhingAttributeInfo.$$$reportNull$$$0(2);
        }
        return string;
    }

    public void registerAsChildOf(DomExtensionsRegistrar registrar) {
        DomExtension extension = this.myType.registerXmlName(this.myName, registrar);
        if (this.isRequired) {
            extension.addCustomAnnotation((Annotation)((Object)new MyRequired()));
        }
        if (this.myConverter != null) {
            extension.setConverter(this.myConverter.getInstance());
        }
        if (this.isNameValue) {
            extension.addCustomAnnotation((Annotation)((Object)new MyNameValue()));
            extension.putUserData(NAME_VALUE_KEY, (Object)Boolean.TRUE);
        }
    }

    public static boolean isNameValue(DomAttributeChildDescription description) {
        return Boolean.TRUE.equals(description.getUserData(NAME_VALUE_KEY));
    }

    public Element writeTo() {
        Element result = new Element(this.myName);
        if (this.isRequired) {
            result.setAttribute("required", "true");
        }
        if (this.isProperty) {
            result.setAttribute("property", "true");
        }
        if (this.isNameValue) {
            result.setAttribute("nameValue", "true");
        }
        if (this.myConverter != null) {
            this.myConverter.writeTo(result);
        }
        this.myType.writeTo(result);
        return result;
    }

    public static PhingAttributeInfo readFrom(Element element) {
        String name = element.getName();
        String requiredValue = element.getAttributeValue("required");
        String propertyValue = element.getAttributeValue("property");
        String nameValueValue = element.getAttributeValue("nameValue");
        PhingAttributeConverter converter = PhingAttributeConverter.readFrom(element);
        PhingAttributeType type = PhingAttributeType.readFrom(element);
        return new PhingAttributeInfo(name, "true".equals(requiredValue), "true".equals(propertyValue), "true".equals(nameValueValue), converter, type);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "type";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/schema/PhingAttributeInfo";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/schema/PhingAttributeInfo";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private static class MyNameValue
    implements NameValue {
        private MyNameValue() {
        }

        public boolean unique() {
            return true;
        }

        public boolean referencable() {
            return true;
        }

        public Class<? extends Annotation> annotationType() {
            return NameValue.class;
        }
    }

    public static class MyRequired
    implements Required {
        public boolean value() {
            return true;
        }

        public boolean nonEmpty() {
            return true;
        }

        public boolean identifier() {
            return false;
        }

        public Class<? extends Annotation> annotationType() {
            return Required.class;
        }
    }
}

