/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.xml.DomElement;
import com.jetbrains.php.phing.dom.PhingPropertyProviderFinder;
import com.jetbrains.php.phing.dom.PropertiesProvider;
import com.jetbrains.php.phing.dom.PropertyExpander;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedCustomElement;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public final class PhingStringResolver
extends PhingPropertyProviderFinder {
    private final PropertyExpander myExpander;
    private final boolean mySkipCustomTags;
    private static final Key<Map<String, String>> RESOLVED_STRINGS_MAP_KEY = new Key("_phing_resolved_strings_cache_");

    private PhingStringResolver(DomElement contextElement, PropertyExpander expander, boolean skipCustomTags) {
        super(contextElement);
        this.myExpander = expander;
        this.mySkipCustomTags = skipCustomTags;
    }

    @Override
    public void visitPhingDomCustomElement(PhingPredefinedCustomElement custom) {
        if (!this.mySkipCustomTags) {
            super.visitPhingDomCustomElement(custom);
        }
    }

    @NotNull
    public static String computeString(@NotNull DomElement context, @NotNull String valueString) {
        PropertyExpander expander;
        if (context == null) {
            PhingStringResolver.$$$reportNull$$$0(0);
        }
        if (valueString == null) {
            PhingStringResolver.$$$reportNull$$$0(1);
        }
        if (!(expander = new PropertyExpander(valueString)).hasPropertiesToExpand()) {
            String string = valueString;
            if (string == null) {
                PhingStringResolver.$$$reportNull$$$0(2);
            }
            return string;
        }
        PhingPredefinedProject project = (PhingPredefinedProject)context.getParentOfType(PhingPredefinedProject.class, false);
        if (project == null) {
            String string = valueString;
            if (string == null) {
                PhingStringResolver.$$$reportNull$$$0(3);
            }
            return string;
        }
        Map<String, String> cached = (Map<String, String>)context.getUserData(RESOLVED_STRINGS_MAP_KEY);
        if (cached != null) {
            String resolvedFromCache = (String)cached.get(valueString);
            if (resolvedFromCache != null) {
                String string = resolvedFromCache;
                if (string == null) {
                    PhingStringResolver.$$$reportNull$$$0(4);
                }
                return string;
            }
        } else {
            cached = Collections.synchronizedMap(new HashMap());
            context.putUserData(RESOLVED_STRINGS_MAP_KEY, cached);
        }
        String result = (String)RecursionManager.doPreventingRecursion((Object)Pair.create((Object)context, (Object)valueString), (boolean)false, () -> {
            new PhingStringResolver(context, expander, true).execute(project, project.findDefaultTarget().getRawText());
            return expander.getResult();
        });
        result = StringUtil.notNullize((String)result, (String)valueString);
        cached.put(valueString, result);
        String string = result;
        if (string == null) {
            PhingStringResolver.$$$reportNull$$$0(5);
        }
        return string;
    }

    @Override
    protected void propertyProviderFound(PropertiesProvider propertiesProvider) {
        propertiesProvider = this.checkPropertyProvider(propertiesProvider);
        this.myExpander.acceptProvider(propertiesProvider);
        if (!this.myExpander.hasPropertiesToExpand()) {
            this.stop();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/PhingStringResolver";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/PhingStringResolver";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "computeString";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "computeString";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

