/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.jetbrains.php.config.library.PhpIncludePathManager;
import com.jetbrains.php.lang.psi.PhpFile;
import com.jetbrains.php.phing.dom.PhingPhpFileReferenceSet;
import java.io.File;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingPhpClassConverter
extends Converter<PsiFileSystemItem>
implements CustomReferenceConverter<PsiFileSystemItem> {
    public PsiFileSystemItem fromString(@Nullable @NonNls String s, ConvertContext context) {
        GenericAttributeValue attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false);
        if (attribValue == null) {
            return null;
        }
        String path = attribValue.getStringValue();
        if (path == null) {
            return null;
        }
        path = path.replaceAll("\\.", Matcher.quoteReplacement(File.separator));
        return PhingPhpClassConverter.findPhpClass(path, context.getProject(), context.getPsiManager(), (PsiFile)context.getFile());
    }

    @Nullable
    public static PsiFileSystemItem findPhpClass(String path, Project project, PsiManager psiManager, PsiFile contextFile) {
        PsiFileSystemItem file;
        PsiDirectory parentDirectory = contextFile.getOriginalFile().getParent();
        if (parentDirectory != null && (file = PhingPhpClassConverter.findFileWithGivenRoot(parentDirectory.getVirtualFile(), path, psiManager)) != null) {
            return file;
        }
        List otherRoots = PhpIncludePathManager.getInstance((Project)project).getRoots();
        for (VirtualFile root : otherRoots) {
            PsiFileSystemItem file2 = PhingPhpClassConverter.findFileWithGivenRoot(root, path, psiManager);
            if (file2 == null) continue;
            return file2;
        }
        return null;
    }

    @Nullable
    private static PsiFileSystemItem findFileWithGivenRoot(VirtualFile root, String relativePath, PsiManager psiManager) {
        if (root == null) {
            return null;
        }
        VirtualFile file = root.findFileByRelativePath(relativePath + ".php");
        if (file == null || file.isDirectory()) {
            return null;
        }
        PsiFile psiFile = psiManager.findFile(file);
        if (!(psiFile instanceof PhpFile)) {
            return null;
        }
        return psiFile;
    }

    public String toString(@Nullable PsiFileSystemItem file, ConvertContext context) {
        GenericAttributeValue attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false);
        if (attribValue == null) {
            return null;
        }
        return attribValue.getRawText();
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<PsiFileSystemItem> genericDomValue, PsiElement element, ConvertContext context) {
        GenericAttributeValue attrib;
        if (genericDomValue instanceof GenericAttributeValue && (attrib = (GenericAttributeValue)genericDomValue).getRawText() != null) {
            PhingPhpFileReferenceSet refSet = new PhingPhpFileReferenceSet(attrib);
            FileReference[] fileReferenceArray = refSet.getAllReferences();
            if (fileReferenceArray == null) {
                PhingPhpClassConverter.$$$reportNull$$$0(0);
            }
            return fileReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            PhingPhpClassConverter.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/PhingPhpClassConverter", "createReferences"));
    }
}

