/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReference;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.jetbrains.php.phing.dom.PhingDomFileReferenceSet;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import java.io.File;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingPathConverter
extends Converter<PsiFileSystemItem>
implements CustomReferenceConverter<PsiFileSystemItem> {
    public PsiFileSystemItem fromString(@Nullable @NonNls String s, ConvertContext context) {
        VirtualFile vFile;
        GenericAttributeValue attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false);
        if (attribValue == null) {
            return null;
        }
        String path = attribValue.getStringValue();
        if (path == null) {
            return null;
        }
        File file = new File(path);
        if (!file.isAbsolute()) {
            PhingPredefinedProject bfProject = PhingPathConverter.getEffectiveBFProject(attribValue);
            if (bfProject == null) {
                return null;
            }
            file = new File(PhingPathConverter.getPathResolveRoot(bfProject), path);
        }
        if ((vFile = LocalFileSystem.getInstance().findFileByPath(FileUtil.toSystemIndependentName((String)file.getAbsolutePath()))) == null) {
            return null;
        }
        PsiManager psiManager = context.getPsiManager();
        return vFile.isDirectory() ? psiManager.findDirectory(vFile) : psiManager.findFile(vFile);
    }

    @Nullable
    private static PhingPredefinedProject getEffectiveBFProject(GenericAttributeValue attribValue) {
        return (PhingPredefinedProject)attribValue.getParentOfType(PhingPredefinedProject.class, false);
    }

    @Nullable
    private static String getPathResolveRoot(PhingPredefinedProject PhingDomProject) {
        return PhingDomProject.getProjectBasedirPath();
    }

    public String toString(@Nullable PsiFileSystemItem file, ConvertContext context) {
        GenericAttributeValue attribValue = (GenericAttributeValue)context.getInvocationElement().getParentOfType(GenericAttributeValue.class, false);
        if (attribValue == null) {
            return null;
        }
        return attribValue.getRawText();
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<PsiFileSystemItem> genericDomValue, PsiElement element, ConvertContext context) {
        GenericAttributeValue attrib;
        if (genericDomValue instanceof GenericAttributeValue && (attrib = (GenericAttributeValue)genericDomValue).getRawText() != null) {
            PhingDomFileReferenceSet refSet = new PhingDomFileReferenceSet(attrib);
            ArrayList<FileReference> result = new ArrayList<FileReference>();
            for (FileReference reference : refSet.getAllReferences()) {
                if (reference.resolve() == null) break;
                result.add(reference);
            }
            PsiReference[] psiReferenceArray = result.toArray(PsiReference.EMPTY_ARRAY);
            if (psiReferenceArray == null) {
                PhingPathConverter.$$$reportNull$$$0(0);
            }
            return psiReferenceArray;
        }
        if (PsiReference.EMPTY_ARRAY == null) {
            PhingPathConverter.$$$reportNull$$$0(1);
        }
        return PsiReference.EMPTY_ARRAY;
    }

    public String getErrorMessage(@Nullable String s, ConvertContext context) {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/PhingPathConverter", "createReferences"));
    }
}

