/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.openapi.util.TextRange;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlElement;
import com.intellij.util.text.StringTokenizer;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.Converter;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.GenericDomValue;
import com.jetbrains.php.phing.dom.PhingDomTargetReference;
import com.jetbrains.php.phing.dom.TargetResolver;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedProject;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedTarget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingDomTargetDependsListConverter
extends Converter<TargetResolver.Result>
implements CustomReferenceConverter<TargetResolver.Result> {
    public TargetResolver.Result fromString(@Nullable @NonNls String s, ConvertContext context) {
        List<String> refs;
        PhingPredefinedProject project = (PhingPredefinedProject)context.getInvocationElement().getParentOfType(PhingPredefinedProject.class, false);
        if (project == null) {
            return null;
        }
        PhingPredefinedTarget contextTarget = (PhingPredefinedTarget)context.getInvocationElement().getParentOfType(PhingPredefinedTarget.class, false);
        if (contextTarget == null) {
            return null;
        }
        if (s == null) {
            refs = Collections.emptyList();
        } else {
            refs = new ArrayList();
            StringTokenizer tokenizer = new StringTokenizer(s, ",", false);
            while (tokenizer.hasMoreTokens()) {
                String ref = tokenizer.nextToken();
                refs.add(ref.trim());
            }
        }
        TargetResolver.Result result = TargetResolver.resolve(project, contextTarget, refs);
        result.setRefsString(s);
        return result;
    }

    @Nullable
    public String toString(@Nullable TargetResolver.Result result, ConvertContext context) {
        return result != null ? result.getRefsString() : null;
    }

    public PsiReference @NotNull [] createReferences(GenericDomValue<TargetResolver.Result> value, PsiElement element, ConvertContext context) {
        XmlElement xmlElement = value.getXmlElement();
        if (!(xmlElement instanceof XmlAttribute)) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PhingDomTargetDependsListConverter.$$$reportNull$$$0(0);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        XmlAttributeValue valueElement = ((XmlAttribute)xmlElement).getValueElement();
        if (valueElement == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PhingDomTargetDependsListConverter.$$$reportNull$$$0(1);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        String refsString = value.getStringValue();
        if (refsString == null) {
            if (PsiReference.EMPTY_ARRAY == null) {
                PhingDomTargetDependsListConverter.$$$reportNull$$$0(2);
            }
            return PsiReference.EMPTY_ARRAY;
        }
        ArrayList<PhingDomTargetReference> refs = new ArrayList<PhingDomTargetReference>();
        PhingDomTargetReference.ReferenceGroup group = new PhingDomTargetReference.ReferenceGroup();
        TextRange wholeStringRange = ElementManipulators.getValueTextRange((PsiElement)valueElement);
        StringTokenizer tokenizer = new StringTokenizer(refsString, ",", false);
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            int tokenStartOffset = tokenizer.getCurrentPosition() - token.length();
            String ref = token.trim();
            if (ref.length() != token.length()) {
                for (int idx = 0; idx < token.length() && Character.isWhitespace(token.charAt(idx)); ++idx) {
                    ++tokenStartOffset;
                }
            }
            refs.add(new PhingDomTargetReference(element, TextRange.from((int)(wholeStringRange.getStartOffset() + tokenStartOffset), (int)ref.length()), group));
        }
        PsiReference[] psiReferenceArray = refs.toArray(PsiReference.EMPTY_ARRAY);
        if (psiReferenceArray == null) {
            PhingDomTargetDependsListConverter.$$$reportNull$$$0(3);
        }
        return psiReferenceArray;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/jetbrains/php/phing/dom/PhingDomTargetDependsListConverter", "createReferences"));
    }
}

