/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing.dom;

import com.intellij.codeInsight.template.Template;
import com.intellij.codeInsight.template.TemplateManager;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.xml.XmlTag;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.dom.PhingCreateTargetQuickFix;
import com.jetbrains.php.phing.dom.predefined.PhingPredefinedElement;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class PhingCreatePropertyQuickFix
implements LocalQuickFix {
    @NonNls
    private static final String PROPERTY_TAG_NAME = "property";
    @NonNls
    private static final String NAME_ATTRIBUTE_NAME = "name";
    @NonNls
    private static final String VALUE_ATTRIBUTE_NAME = "value";
    private final PhingPredefinedElement myElement;
    private final String myPropertyName;

    public PhingCreatePropertyQuickFix(PhingPredefinedElement element, String propertyName) {
        this.myElement = element;
        this.myPropertyName = propertyName;
    }

    @NotNull
    public String getName() {
        String string = PhingBundle.message("create.property.quickfix.name", this.myPropertyName);
        if (string == null) {
            PhingCreatePropertyQuickFix.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = PhingBundle.message("phing.inspection.group.name", new Object[0]);
        if (string == null) {
            PhingCreatePropertyQuickFix.$$$reportNull$$$0(1);
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            PhingCreatePropertyQuickFix.$$$reportNull$$$0(2);
        }
        if (descriptor == null) {
            PhingCreatePropertyQuickFix.$$$reportNull$$$0(3);
        }
        Template template = TemplateManager.getInstance((Project)project).createTemplate("", "");
        template.addTextSegment("<property name=\"" + this.myPropertyName + "\" value=\"");
        template.addEndVariable();
        template.addTextSegment("\"/>\n");
        int offset = PhingCreatePropertyQuickFix.getPropertyTemplateOffset(this.myElement.getXmlTag());
        PhingCreateTargetQuickFix.insertTemplate(project, template, offset, this.myElement);
    }

    private static int getPropertyTemplateOffset(XmlTag tag) {
        return tag.getTextOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/dom/PhingCreatePropertyQuickFix";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFamilyName";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/dom/PhingCreatePropertyQuickFix";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "applyFix";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

