/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlFile;
import com.intellij.util.EventDispatcher;
import com.intellij.util.xmlb.annotations.AbstractCollection;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import com.jetbrains.php.phing.InvalidPhingFileException;
import com.jetbrains.php.phing.PhingActionIdUtils;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileParsedData;
import com.jetbrains.php.phing.PhingBuildFileProperty;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.dom.PhingDomFileDescription;
import com.jetbrains.php.phing.dom.PhingUtils;
import com.jetbrains.php.phing.ui.PhingConfigurable;
import com.jetbrains.php.phing.ui.explorer.PhingStateListener;
import com.jetbrains.php.phing.ui.explorer.PhingToolWindowFactory;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="PhingConfiguration", storages={@Storage(value="phing.xml")})
public final class PhingStateService
implements PersistentStateComponent<PhingState>,
Disposable {
    private final Project myProject;
    private final List<PhingBuildFile> myBuildFiles;
    private final EventDispatcher<PhingStateListener> myEventDispatcher = EventDispatcher.create(PhingStateListener.class);
    private final Map<PhingBuildFile, PhingBuildFileParsedData> myFileToDataMap;
    private String myPhingPath;
    private final PsiManager myPsiManager;
    private boolean myHideTargets = true;

    public PhingStateService(Project project) {
        this.myProject = project;
        VirtualFileListener listener = new VirtualFileListener(){

            public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
                PhingBuildFile buildFile;
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                if ("name".equals(event.getPropertyName()) && (buildFile = PhingStateService.this.getBuildFile(event.getFile())) != null) {
                    PhingStateService.this.firePhingFileChanged(event.getFile());
                }
            }

            public void fileDeleted(@NotNull VirtualFileEvent event) {
                PhingBuildFile buildFile;
                if (event == null) {
                    1.$$$reportNull$$$0(1);
                }
                if ((buildFile = PhingStateService.this.getBuildFile(event.getFile())) != null) {
                    PhingStateService.this.removeBuildFile(buildFile);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2 = new Object[3];
                objectArray2[0] = "event";
                objectArray2[1] = "com/jetbrains/php/phing/PhingStateService$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "propertyChanged";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "fileDeleted";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        VirtualFileManager.getInstance().addVirtualFileListener(listener, (Disposable)this);
        this.myPsiManager = PsiManager.getInstance((Project)this.myProject);
        this.myBuildFiles = new ArrayList<PhingBuildFile>();
        this.myFileToDataMap = new HashMap<PhingBuildFile, PhingBuildFileParsedData>();
        new PhingToolWindowFactory().initToolWindowListener(this);
    }

    public void dispose() {
    }

    public static boolean isPhingPathInvalid(String path) {
        if (path == null) {
            return true;
        }
        File file = new File(path);
        if (!file.exists()) {
            return true;
        }
        @NonNls String name = file.getName();
        if (PhingConfigurable.PHING_EXECUTABLE.equals(name)) {
            return false;
        }
        return !name.contains("phing") || !name.contains(".phar");
    }

    @Nullable
    public static String findValidPath(@NonNls String text) {
        if (StringUtil.isEmpty((String)text)) {
            return "";
        }
        File providedFile = new File(text);
        if (providedFile.exists()) {
            if (providedFile.getName().equals(PhingConfigurable.PHING_EXECUTABLE)) {
                return FileUtil.toSystemDependentName((String)providedFile.getPath());
            }
            if (text.contains(".phar") && !providedFile.isDirectory() && providedFile.getName().contains("phing") && providedFile.getName().contains("phar")) {
                return FileUtil.toSystemDependentName((String)providedFile.getPath());
            }
        }
        return null;
    }

    public static boolean isPhingPathExecutable(String phingPath) {
        return phingPath != null && phingPath.endsWith(PhingConfigurable.PHING_EXECUTABLE);
    }

    public boolean isHideTargets() {
        return this.myHideTargets;
    }

    public void setHideTargets(boolean hideTargets) {
        this.myHideTargets = hideTargets;
    }

    public static PhingStateService getInstance(Project project) {
        return (PhingStateService)project.getService(PhingStateService.class);
    }

    @Nullable
    public PhingBuildFileParsedData getParsedData(PhingBuildFile buildFile) {
        return this.myFileToDataMap.get(buildFile);
    }

    @Nullable
    public PhingBuildFile getBuildFile(@NotNull VirtualFile file) {
        if (file == null) {
            PhingStateService.$$$reportNull$$$0(0);
        }
        for (PhingBuildFile buildFile : this.myBuildFiles) {
            if (!buildFile.getFile().equals(file)) continue;
            return buildFile;
        }
        return null;
    }

    @NotNull
    public List<PhingBuildFile> getBuildFiles() {
        List<PhingBuildFile> list = Collections.unmodifiableList(this.myBuildFiles);
        if (list == null) {
            PhingStateService.$$$reportNull$$$0(1);
        }
        return list;
    }

    public PhingBuildFile addBuildFile(@NotNull VirtualFile file) throws InvalidPhingFileException {
        if (file == null) {
            PhingStateService.$$$reportNull$$$0(2);
        }
        PhingBuildFile result = this.doAddBuildFile(file);
        PhingActionIdUtils.updateRegisteredActions(this.myProject, this);
        return result;
    }

    private PhingBuildFile doAddBuildFile(VirtualFile file) throws InvalidPhingFileException {
        PsiFile xmlFile = this.myPsiManager.findFile(file);
        if (!(xmlFile instanceof XmlFile)) {
            throw new InvalidPhingFileException(PhingBundle.message("phing.the.file.is.not.an.xml.file", new Object[0]), file);
        }
        if (PhingUtils.belongsToOtherFramework(file)) {
            throw new InvalidPhingFileException(PhingBundle.message("file.marked.as.belonging.to.other.framework", new Object[0]), file);
        }
        PhingUtils.markFileAsPhingFile(file, xmlFile.getProject(), true);
        if (!PhingDomFileDescription.isPhingFile((XmlFile)xmlFile)) {
            throw new InvalidPhingFileException(PhingBundle.message("phing.the.file.is.not.recognized.as.a.phing.file", new Object[0]), file);
        }
        PhingBuildFile buildFile = this.getBuildFile(file);
        if (buildFile == null) {
            buildFile = new PhingBuildFile(file, this.myProject);
            this.myBuildFiles.add(buildFile);
            this.firePhingFileAdded(buildFile);
            this.myFileToDataMap.put(buildFile, new PhingBuildFileParsedData(buildFile, this.myProject));
        }
        return buildFile;
    }

    public void removeBuildFile(PhingBuildFile buildFile) {
        this.doRemoveBuildFile(buildFile);
        PhingActionIdUtils.updateRegisteredActions(this.myProject, this);
    }

    private void doRemoveBuildFile(PhingBuildFile buildFile) {
        if (this.myBuildFiles.remove(buildFile)) {
            this.firePhingFileRemoved(buildFile);
            PhingUtils.markFileAsPhingFile(buildFile.getFile(), buildFile.getProject(), false);
        }
    }

    public void addPhingStateListener(PhingStateListener listener) {
        this.myEventDispatcher.addListener((EventListener)listener);
    }

    public void removePhingStateListener(PhingStateListener listener) {
        this.myEventDispatcher.removeListener((EventListener)listener);
    }

    private void firePhingFileChanged(VirtualFile file) {
        PhingBuildFile buildFile = this.getBuildFile(file);
        if (buildFile != null) {
            ((PhingStateListener)this.myEventDispatcher.getMulticaster()).buildFileChanged(buildFile);
        }
    }

    private void firePhingFileAdded(PhingBuildFile phingBuildFile) {
        ((PhingStateListener)this.myEventDispatcher.getMulticaster()).buildFileAdded(phingBuildFile);
    }

    private void firePhingFileRemoved(PhingBuildFile phingBuildFile) {
        ((PhingStateListener)this.myEventDispatcher.getMulticaster()).buildFileRemoved(phingBuildFile);
    }

    @NlsSafe
    public String getPhingPath() {
        return this.myPhingPath;
    }

    public void setPhingPath(String phingPath) {
        this.myPhingPath = phingPath;
    }

    public PhingState getState() {
        ArrayList<PhingFileSetting> files = new ArrayList<PhingFileSetting>();
        for (PhingBuildFile buildFile : this.myBuildFiles) {
            files.add(new PhingFileSetting(buildFile.getFile().getUrl(), buildFile.getCommandLineOptions(), buildFile.getCommandLineProperties(), buildFile.getTargetsToHide()));
        }
        return new PhingState(files, this.myPhingPath, this.myHideTargets);
    }

    public void loadState(final @NotNull PhingState state) {
        if (state == null) {
            PhingStateService.$$$reportNull$$$0(3);
        }
        this.myPhingPath = state.getPhingPath();
        Task.Backgroundable task = new Task.Backgroundable(this.myProject, PhingBundle.message("loading.phing.configuration", new Object[0]), false, PerformInBackgroundOption.ALWAYS_BACKGROUND){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (this.getProject().isDisposed()) {
                    return;
                }
                indicator.pushState();
                try {
                    indicator.setText(PhingBundle.message("loading.phing.configuration", new Object[0]));
                    ApplicationManager.getApplication().invokeAndWait(() -> PhingStateService.this.doLoadBuildFiles(state));
                }
                finally {
                    indicator.popState();
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/phing/PhingStateService$2", "run"));
            }
        };
        Application app = ApplicationManager.getApplication();
        if (app.isDispatchThread()) {
            task.queue();
        } else {
            app.invokeLater(() -> task.queue(), this.myProject.getDisposed());
        }
    }

    private void doLoadBuildFiles(PhingState state) {
        for (PhingBuildFile buildFile : this.myBuildFiles.toArray(new PhingBuildFile[0])) {
            this.doRemoveBuildFile(buildFile);
        }
        VirtualFileManager vfManager = VirtualFileManager.getInstance();
        for (PhingFileSetting fileSetting : state.getFileSettings()) {
            VirtualFile file = vfManager.findFileByUrl(fileSetting.getPath());
            if (file == null) continue;
            try {
                PhingBuildFile buildFile = this.doAddBuildFile(file);
                buildFile.setCommandLineOptions(fileSetting.getCommandlineOptions());
                buildFile.setCommandLineProperties(fileSetting.getProperties());
                buildFile.setTargetsToHide(fileSetting.getTargetsToHide());
            }
            catch (InvalidPhingFileException invalidPhingFileException) {}
        }
        PhingActionIdUtils.updateRegisteredActions(this.myProject, this);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/PhingStateService";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/PhingStateService";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getBuildFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getBuildFile";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "addBuildFile";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    @Tag(value="buildFile")
    public static class PhingFileSetting {
        private String path;
        private String commandlineOptions;
        private List<PhingBuildFileProperty> properties;
        private List<String> myTargetsToHide;

        public PhingFileSetting(@Nullable String url, @Nullable String commandLineOptions, @NotNull List<PhingBuildFileProperty> fileProperties, @NotNull List<String> targetsToHide) {
            if (fileProperties == null) {
                PhingFileSetting.$$$reportNull$$$0(0);
            }
            if (targetsToHide == null) {
                PhingFileSetting.$$$reportNull$$$0(1);
            }
            this.path = url;
            this.commandlineOptions = commandLineOptions;
            this.properties = fileProperties;
            this.myTargetsToHide = targetsToHide;
        }

        public PhingFileSetting() {
            this(null, null, new LinkedList<PhingBuildFileProperty>(), new LinkedList<String>());
        }

        @Attribute(value="path")
        public String getPath() {
            return this.path == null ? "" : this.path;
        }

        public void setPath(String path) {
            this.path = path;
        }

        @Attribute(value="options")
        @Nullable
        public String getCommandlineOptions() {
            return this.commandlineOptions;
        }

        public void setCommandlineOptions(String commandlineOptions) {
            this.commandlineOptions = commandlineOptions;
        }

        @AbstractCollection(elementTag="props")
        @NotNull
        public List<PhingBuildFileProperty> getProperties() {
            List<PhingBuildFileProperty> list = this.properties;
            if (list == null) {
                PhingFileSetting.$$$reportNull$$$0(2);
            }
            return list;
        }

        public void setProperties(@NotNull List<PhingBuildFileProperty> variables) {
            if (variables == null) {
                PhingFileSetting.$$$reportNull$$$0(3);
            }
            this.properties = variables;
        }

        @XCollection(propertyElementName="targetsToHide", elementName="target")
        public List<String> getTargetsToHide() {
            return this.myTargetsToHide;
        }

        public void setTargetsToHide(List<String> targetsToHide) {
            this.myTargetsToHide = targetsToHide;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            RuntimeException runtimeException;
            Object[] objectArray;
            Object[] objectArray2;
            int n2;
            String string;
            switch (n) {
                default: {
                    string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                    break;
                }
                case 2: {
                    string = "@NotNull method %s.%s must not return null";
                    break;
                }
            }
            switch (n) {
                default: {
                    n2 = 3;
                    break;
                }
                case 2: {
                    n2 = 2;
                    break;
                }
            }
            Object[] objectArray3 = new Object[n2];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "fileProperties";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "targetsToHide";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/jetbrains/php/phing/PhingStateService$PhingFileSetting";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "variables";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/jetbrains/php/phing/PhingStateService$PhingFileSetting";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getProperties";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: {
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setProperties";
                    break;
                }
            }
            String string2 = String.format(string, objectArray);
            switch (n) {
                default: {
                    runtimeException = new IllegalArgumentException(string2);
                    break;
                }
                case 2: {
                    runtimeException = new IllegalStateException(string2);
                    break;
                }
            }
            throw runtimeException;
        }
    }

    public static class PhingState {
        private List<PhingFileSetting> myFileSettings;
        private String myPhingPath;
        private boolean myHideTargets;

        public PhingState() {
            this(new LinkedList<PhingFileSetting>(), null, true);
        }

        private PhingState(List<PhingFileSetting> fileSettings, @Nullable String phingPath, boolean hideTargets) {
            this.myFileSettings = fileSettings;
            this.myPhingPath = phingPath == null ? phingPath : FileUtil.toSystemIndependentName((String)phingPath);
            this.myHideTargets = hideTargets;
        }

        @XCollection(propertyElementName="buildFilePaths", elementName="buildFile")
        public List<PhingFileSetting> getFileSettings() {
            return this.myFileSettings;
        }

        public void setFileSettings(List<PhingFileSetting> paths) {
            this.myFileSettings = paths;
        }

        @Tag(value="phingPath")
        @Nullable
        public String getPhingPath() {
            return this.myPhingPath;
        }

        public void setPhingPath(String phingPath) {
            this.myPhingPath = phingPath;
        }

        @Attribute(value="hideTargets")
        public boolean isHideTargets() {
            return this.myHideTargets;
        }

        public void setHideTargets(boolean hideTargets) {
            this.myHideTargets = hideTargets;
        }
    }
}

