/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.jetbrains.php.phing.PhingActionIdUtils;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingStateService;
import icons.PhingIcons;
import java.util.HashMap;
import java.util.List;

final class PhingKeymapExtension
implements KeymapExtension {
    private static final Logger LOG = Logger.getInstance(PhingKeymapExtension.class);

    PhingKeymapExtension() {
    }

    public KeymapGroup createGroup(Condition<? super AnAction> filtered, Project project) {
        if (project != null) {
            PhingActionIdUtils.updateRegisteredActions(project, PhingStateService.getInstance(project));
        }
        HashMap buildFileToGroup = new HashMap();
        KeymapGroup result = KeymapGroupFactory.getInstance().createGroup(PhingBundle.message("phing.targets", new Object[0]), PhingIcons.ClosedPhingKeymap);
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        List ids = actionManager.getActionIdList(PhingActionIdUtils.getActionIdPrefix(project));
        ids.sort(null);
        if (project != null) {
            ApplicationManager.getApplication().runReadAction(() -> {
                for (String id : ids) {
                    if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub(id))) continue;
                    PhingBuildFile buildFile = PhingActionIdUtils.findBuildFileByActionId(id, project);
                    if (buildFile != null) {
                        KeymapGroup subGroup = (KeymapGroup)buildFileToGroup.get(buildFile);
                        if (subGroup == null) {
                            subGroup = KeymapGroupFactory.getInstance().createGroup(buildFile.getPresentableName());
                            buildFileToGroup.put(buildFile, subGroup);
                            result.addGroup(subGroup);
                        }
                        subGroup.addActionId(id);
                        continue;
                    }
                    LOG.info("No buildfile found for actionId=" + id);
                }
            });
        }
        return result;
    }
}

