/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.RunCanceledByUserException;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.process.ScriptRunnerUtil;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.history.LocalHistory;
import com.intellij.ide.macro.Macro;
import com.intellij.ide.macro.MacroManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.newvfs.RefreshQueue;
import com.intellij.openapi.wm.StatusBar;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.util.ArrayUtilRt;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileProperty;
import com.jetbrains.php.phing.PhingBuildListener;
import com.jetbrains.php.phing.PhingBundle;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.phpDependent.PhingCustomElementsRegistry;
import com.jetbrains.php.phing.ui.output.PhingBuildMessageView;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhingExecutionHandler {
    private static final Logger LOG = Logger.getInstance(PhingExecutionHandler.class);
    @NonNls
    private static final String BUILD_FAILED_MESSAGE = "BUILD FAILED";
    @NonNls
    private static final String BUILD_FINISHED_MESSAGE = "BUILD FINISHED";

    private PhingExecutionHandler() {
    }

    public static void runBuild(final PhingBuildFile buildFile, @Nullable String target, @Nullable PhingBuildMessageView buildMessageViewToReuse, final @NotNull PhingBuildListener phingBuildListener, @NotNull DataContext context) {
        PhingBuildMessageView messageView;
        if (phingBuildListener == null) {
            PhingExecutionHandler.$$$reportNull$$$0(0);
        }
        if (context == null) {
            PhingExecutionHandler.$$$reportNull$$$0(1);
        }
        FileDocumentManager.getInstance().saveAllDocuments();
        try {
            messageView = PhingExecutionHandler.prepareMessageView(buildMessageViewToReuse, buildFile, target);
        }
        catch (RunCanceledByUserException e) {
            return;
        }
        final @NonNls ArrayList<Object> commands = new ArrayList<Object>();
        String phingPath = PhingStateService.getInstance(buildFile.getProject()).getPhingPath();
        LOG.assertTrue(!PhingStateService.isPhingPathInvalid(phingPath));
        if (!PhingStateService.isPhingPathExecutable(phingPath)) {
            commands.add(PhingCustomElementsRegistry.findPhpCommand(buildFile.getProject()));
        }
        commands.add(phingPath);
        commands.add("-f");
        commands.add(buildFile.getFile().getPath());
        int optionsFirstIndex = commands.size();
        String commandLineOptions = buildFile.getCommandLineOptions();
        PhingExecutionHandler.splitParameters(commands, commandLineOptions);
        for (int i = optionsFirstIndex; i < commands.size(); ++i) {
            commands.set(i, PhingExecutionHandler.resolveMacros((String)commands.get(i), false, context));
        }
        for (PhingBuildFileProperty property : buildFile.getCommandLineProperties()) {
            commands.add("-D" + property.getName() + "=" + PhingExecutionHandler.resolveMacros(property.getValue(), false, context));
        }
        for (int i = optionsFirstIndex; i < commands.size(); ++i) {
            commands.set(i, PhingExecutionHandler.resolveMacros((String)commands.get(i), true, context));
        }
        if (target != null) {
            commands.add(target);
        }
        new Task.Backgroundable(buildFile.getProject(), PhingBundle.message("phing.build.progress.dialog.title", new Object[0]), true){

            public boolean shouldStartInBackground() {
                return true;
            }

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                try {
                    PhingExecutionHandler.runBuild(indicator, messageView, buildFile, phingBuildListener, commands);
                }
                catch (Throwable e) {
                    LOG.error(e);
                    phingBuildListener.buildFinished(2);
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/jetbrains/php/phing/PhingExecutionHandler$1", "run"));
            }
        }.queue();
    }

    @Nullable
    private static String resolveMacros(String commandWithMacros, boolean firstQueueExpand, DataContext dataContext) {
        try {
            return MacroManager.getInstance().expandMacrosInString(commandWithMacros, firstQueueExpand, dataContext);
        }
        catch (Macro.ExecutionCancelledException e) {
            return commandWithMacros;
        }
    }

    public static void splitParameters(List<? super String> commands, String commandLineOptions) {
        if (!StringUtil.isEmptyOrSpaces((String)commandLineOptions)) {
            List options = StringUtil.splitHonorQuotes((String)commandLineOptions, (char)' ');
            for (String option : options) {
                option = option.replaceAll("\"", "").replaceAll("'", "");
                commands.add(option);
            }
        }
    }

    private static void runBuild(ProgressIndicator progress, @NotNull PhingBuildMessageView errorView, @NotNull PhingBuildFile buildFile, @NotNull PhingBuildListener phingBuildListener, List<String> commands) {
        OSProcessHandler handler;
        if (errorView == null) {
            PhingExecutionHandler.$$$reportNull$$$0(2);
        }
        if (buildFile == null) {
            PhingExecutionHandler.$$$reportNull$$$0(3);
        }
        if (phingBuildListener == null) {
            PhingExecutionHandler.$$$reportNull$$$0(4);
        }
        Project project = buildFile.getProject();
        long startTime = new Date().getTime();
        LocalHistory.getInstance().putSystemLabel(buildFile.getProject(), PhingBundle.message("phing.build.local.history.label", buildFile.getName()));
        try {
            String exePath = commands.remove(0);
            handler = ScriptRunnerUtil.execute((String)exePath, (String)buildFile.getFile().getParent().getPath(), null, (String[])ArrayUtilRt.toStringArray(commands));
        }
        catch (ExecutionException e) {
            ApplicationManager.getApplication().invokeLater(() -> ExecutionErrorDialog.show((ExecutionException)e, (String)PhingBundle.message("could.not.start.process.error.dialog.title", new Object[0]), (Project)project));
            phingBuildListener.buildFinished(2);
            return;
        }
        PhingExecutionHandler.processRunningPhing(progress, handler, errorView, buildFile, startTime, phingBuildListener);
        handler.startNotify();
        handler.waitFor();
    }

    private static void processRunningPhing(final ProgressIndicator progress, OSProcessHandler handler, final PhingBuildMessageView errorView, final PhingBuildFile buildFile, final long startTime, final PhingBuildListener phingBuildListener) {
        Project project = buildFile.getProject();
        StatusBar statusBar = WindowManager.getInstance().getStatusBar(project);
        if (statusBar != null) {
            statusBar.setInfo(PhingBundle.message("phing.build.started.status.message", new Object[0]));
        }
        final CheckCancelTask checkCancelTask = new CheckCancelTask(progress, handler);
        checkCancelTask.start(0L);
        errorView.setProcessHandler(handler);
        final Ref successfulBuild = new Ref();
        handler.addProcessListener((ProcessListener)new ProcessAdapter(){

            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(1);
                }
                if (ProcessOutputTypes.STDERR == outputType && event.getText().contains(PhingExecutionHandler.BUILD_FAILED_MESSAGE)) {
                    successfulBuild.set((Object)Boolean.FALSE);
                } else if (event.getText().contains(PhingExecutionHandler.BUILD_FINISHED_MESSAGE)) {
                    successfulBuild.set((Object)Boolean.TRUE);
                }
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                checkCancelTask.cancel();
                long buildTime = new Date().getTime() - startTime;
                errorView.buildFinished(progress != null && progress.isCanceled(), buildTime, event.getExitCode());
                if (successfulBuild.get() == Boolean.TRUE) {
                    phingBuildListener.buildFinished(0);
                } else if (successfulBuild.get() == Boolean.FALSE) {
                    phingBuildListener.buildFinished(2);
                } else if (successfulBuild.get() == null) {
                    phingBuildListener.buildFinished(1);
                }
                RefreshQueue.getInstance().refresh(true, true, null, ProjectRootManager.getInstance((Project)buildFile.getProject()).getContentRoots());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/jetbrains/php/phing/PhingExecutionHandler$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        });
    }

    private static PhingBuildMessageView prepareMessageView(PhingBuildMessageView buildMessageViewToReuse, PhingBuildFile buildFile, @Nullable String target) throws RunCanceledByUserException {
        PhingBuildMessageView messageView;
        if (buildMessageViewToReuse != null) {
            messageView = buildMessageViewToReuse;
            messageView.emptyAll();
        } else {
            messageView = PhingBuildMessageView.openBuildMessageView(buildFile.getProject(), buildFile, target);
            if (messageView == null) {
                throw new RunCanceledByUserException();
            }
        }
        return messageView;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "phingBuildListener";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "context";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "errorView";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "buildFile";
                break;
            }
        }
        objectArray[1] = "com/jetbrains/php/phing/PhingExecutionHandler";
        objectArray[2] = "runBuild";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    static final class CheckCancelTask
    implements Runnable {
        private final ProgressIndicator myProgressIndicator;
        private final OSProcessHandler myProcessHandler;
        private volatile boolean myCanceled;

        CheckCancelTask(ProgressIndicator progressIndicator, OSProcessHandler process) {
            this.myProgressIndicator = progressIndicator;
            this.myProcessHandler = process;
        }

        public void cancel() {
            this.myCanceled = true;
        }

        @Override
        public void run() {
            if (!this.myCanceled) {
                try {
                    this.myProgressIndicator.checkCanceled();
                    this.start(50L);
                }
                catch (ProcessCanceledException e) {
                    OSProcessUtil.killProcessTree((Process)this.myProcessHandler.getProcess());
                }
            }
        }

        public void start(long delay) {
            AppExecutorUtil.getAppScheduledExecutorService().schedule(this, delay, TimeUnit.MILLISECONDS);
        }
    }
}

