/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.phing.PhingBuildFileProperty;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PhingBuildFile {
    private final Project myProject;
    private final VirtualFile myFile;
    private String myCommandLineOptions;
    private List<PhingBuildFileProperty> myCommandLineProperties;
    private List<String> myTargetsToHide;

    public PhingBuildFile(VirtualFile file, Project project) {
        this.myFile = file;
        this.myProject = project;
        this.myCommandLineProperties = new ArrayList<PhingBuildFileProperty>();
        this.myTargetsToHide = new ArrayList<String>();
    }

    public VirtualFile getFile() {
        return this.myFile;
    }

    public Project getProject() {
        return this.myProject;
    }

    @NlsSafe
    public String getPresentableName() {
        return this.myFile.getPresentableName();
    }

    @NlsSafe
    public String getPresentableUrl() {
        return this.myFile.getPresentableUrl();
    }

    public boolean exists() {
        return this.myFile.exists();
    }

    @NlsSafe
    public String getName() {
        return this.myFile.getName();
    }

    @Nullable
    @NlsSafe
    public String getCommandLineOptions() {
        return this.myCommandLineOptions;
    }

    public void setCommandLineOptions(@Nullable String commandLineOptions) {
        this.myCommandLineOptions = commandLineOptions;
    }

    @NotNull
    public List<PhingBuildFileProperty> getCommandLineProperties() {
        List<PhingBuildFileProperty> list = Collections.unmodifiableList(this.myCommandLineProperties);
        if (list == null) {
            PhingBuildFile.$$$reportNull$$$0(0);
        }
        return list;
    }

    public void setCommandLineProperties(@NotNull List<PhingBuildFileProperty> commandLineProperties) {
        if (commandLineProperties == null) {
            PhingBuildFile.$$$reportNull$$$0(1);
        }
        this.myCommandLineProperties = commandLineProperties;
    }

    @NotNull
    public List<String> getTargetsToHide() {
        List<String> list = this.myTargetsToHide;
        if (list == null) {
            PhingBuildFile.$$$reportNull$$$0(2);
        }
        return list;
    }

    public void setTargetsToHide(@NotNull List<String> targetsToHide) {
        if (targetsToHide == null) {
            PhingBuildFile.$$$reportNull$$$0(3);
        }
        this.myTargetsToHide = targetsToHide;
    }

    public void addTargetToHide(String name) {
        this.myTargetsToHide.add(name);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 1: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 1: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/PhingBuildFile";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commandLineProperties";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "targetsToHide";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCommandLineProperties";
                break;
            }
            case 1: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/PhingBuildFile";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTargetsToHide";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "setCommandLineProperties";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "setTargetsToHide";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 1: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

