/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.php.phing;

import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.jetbrains.php.phing.PhingBuildFile;
import com.jetbrains.php.phing.PhingBuildFileParsedData;
import com.jetbrains.php.phing.PhingBuildTarget;
import com.jetbrains.php.phing.PhingStateService;
import com.jetbrains.php.phing.actions.PhingRunTargetAction;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class PhingActionIdUtils {
    @NonNls
    private static final String ACTION_ID_PREFIX = "Phing_";
    private static final Object LOCK = new Object();

    private PhingActionIdUtils() {
    }

    @NotNull
    public static String getActionIdPrefix(@Nullable Project project) {
        Object object = project == null ? ACTION_ID_PREFIX : ACTION_ID_PREFIX + project.getLocationHash();
        if (object == null) {
            PhingActionIdUtils.$$$reportNull$$$0(0);
        }
        return object;
    }

    @Nullable
    public static PhingBuildFile findBuildFileByActionId(String id, Project project) {
        PhingStateService service = PhingStateService.getInstance(project);
        for (PhingBuildFile buildFile : service.getBuildFiles()) {
            if (id.equals(PhingActionIdUtils.getDefaultTargetActionId(buildFile))) {
                return buildFile;
            }
            PhingBuildFileParsedData parsedData = service.getParsedData(buildFile);
            if (parsedData == null) continue;
            for (PhingBuildTarget target : parsedData.getTargets()) {
                if (!id.equals(PhingActionIdUtils.getActionId(target))) continue;
                return buildFile;
            }
        }
        return null;
    }

    @Nullable
    public static String getDefaultTargetActionId(PhingBuildFile buildFile) {
        VirtualFile baseDir = buildFile.getProject().getBaseDir();
        if (baseDir == null) {
            return null;
        }
        PhingStateService service = PhingStateService.getInstance(buildFile.getProject());
        PhingBuildFileParsedData data = service.getParsedData(buildFile);
        if (data == null) {
            return null;
        }
        boolean foundDefault = false;
        for (PhingBuildTarget target : data.getTargets()) {
            if (!target.isDefault()) continue;
            foundDefault = true;
            break;
        }
        if (!foundDefault) {
            return null;
        }
        return PhingActionIdUtils.getActionIdPrefix(buildFile.getProject()) + "_" + VfsUtilCore.getRelativePath((VirtualFile)buildFile.getFile(), (VirtualFile)baseDir, (char)'/') + "_";
    }

    @Nullable
    public static String getActionId(PhingBuildFile buildFile) {
        VirtualFile baseDir = buildFile.getProject().getBaseDir();
        if (baseDir == null) {
            return null;
        }
        return PhingActionIdUtils.getActionIdPrefix(buildFile.getProject()) + "_" + VfsUtilCore.getRelativePath((VirtualFile)buildFile.getFile(), (VirtualFile)baseDir, (char)'/');
    }

    @NotNull
    public static String getActionId(PhingBuildTarget target) {
        VirtualFile baseDir = target.getContextBuildFile().getProject().getBaseDir();
        assert (baseDir != null);
        String string = PhingActionIdUtils.getActionIdPrefix(target.getContextBuildFile().getProject()) + "_" + VfsUtilCore.getRelativePath((VirtualFile)target.getContextBuildFile().getFile(), (VirtualFile)baseDir, (char)'/') + "_" + target.getName();
        if (string == null) {
            PhingActionIdUtils.$$$reportNull$$$0(1);
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateRegisteredActions(@NotNull Project project, @NotNull PhingStateService stateService) {
        if (project == null) {
            PhingActionIdUtils.$$$reportNull$$$0(2);
        }
        if (stateService == null) {
            PhingActionIdUtils.$$$reportNull$$$0(3);
        }
        if (project.isDisposed()) {
            return;
        }
        HashMap<String, PhingRunTargetAction> actionMap = new HashMap<String, PhingRunTargetAction>();
        for (PhingBuildFile buildFile : stateService.getBuildFiles()) {
            PhingBuildFileParsedData phingBuildFileParsedData;
            String defaultTargetActionId = PhingActionIdUtils.getDefaultTargetActionId(buildFile);
            if (defaultTargetActionId != null) {
                PhingRunTargetAction phingRunTargetAction = new PhingRunTargetAction(buildFile, PhingRunTargetAction.getDefaultTargetName(), null, null);
                actionMap.put(defaultTargetActionId, phingRunTargetAction);
            }
            if ((phingBuildFileParsedData = stateService.getParsedData(buildFile)) == null) continue;
            for (PhingBuildTarget target : phingBuildFileParsedData.getTargets()) {
                if (target.isHiddenByAttribute() || buildFile.getTargetsToHide().contains(target.getName())) continue;
                PhingRunTargetAction action = new PhingRunTargetAction(buildFile, target.getName(), target.getName(), null);
                actionMap.put(PhingActionIdUtils.getActionId(target), action);
            }
        }
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        Object object = LOCK;
        synchronized (object) {
            for (String string : actionManager.getActionIdList(PhingActionIdUtils.getActionIdPrefix(project))) {
                if (actionMap.remove(string) != null) continue;
                actionManager.unregisterAction(string);
            }
            for (Map.Entry entry : actionMap.entrySet()) {
                actionManager.registerAction((String)entry.getKey(), (AnAction)entry.getValue());
            }
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 2: 
            case 3: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 2: 
            case 3: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/jetbrains/php/phing/PhingActionIdUtils";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stateService";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionIdPrefix";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionId";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "com/jetbrains/php/phing/PhingActionIdUtils";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "updateRegisteredActions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 2: 
            case 3: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

