/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.wip;

import com.google.gson.JsonParseException;
import com.google.gson.stream.JsonToken;
import com.intellij.util.Function;
import com.intellij.util.SmartList;
import com.intellij.util.containers.UtilKt;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.AsyncValueLoader;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.Breakpoint;
import org.jetbrains.debugger.CallFrame;
import org.jetbrains.debugger.ExceptionData;
import org.jetbrains.debugger.SuspendContextBase;
import org.jetbrains.io.JsonReaderEx;
import org.jetbrains.wip.WipAsyncCallFrame;
import org.jetbrains.wip.WipBreakpoint;
import org.jetbrains.wip.WipCallFrame;
import org.jetbrains.wip.WipExceptionData;
import org.jetbrains.wip.WipReaderService;
import org.jetbrains.wip.WipScript;
import org.jetbrains.wip.WipSuspendContext;
import org.jetbrains.wip.WipSuspendContextKt;
import org.jetbrains.wip.WipValueManager;
import org.jetbrains.wip.WipVm;
import org.jetbrains.wip.protocol.WipProtocolReader;
import org.jetbrains.wip.protocol.debugger.LocationValue;
import org.jetbrains.wip.protocol.debugger.PausedEventData;
import org.jetbrains.wip.protocol.runtime.CallFrameValue;
import org.jetbrains.wip.protocol.runtime.StackTraceValue;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000y\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000*\u0001\u001f\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0015\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007J\u0010\u00105\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\u0010\u00106\u001a\u00020\"2\u0006\u0010\u0005\u001a\u00020\u0006H\u0002J\n\u00107\u001a\u0006\u0012\u0002\b\u00030\u001aJ\u001e\u00108\u001a\u0002092\f\u0010:\u001a\b\u0012\u0004\u0012\u00020;0\u000f2\b\u0010<\u001a\u0004\u0018\u00010=R\u0018\u0010\b\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\u000bR\u0018\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u0002\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0004\n\u0002\u0010\rR\u001a\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\u00100\u000f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001c\u0010\u0013\u001a\u0004\u0018\u00010\u0014X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0015\u0010\u0016\"\u0004\b\u0017\u0010\u0018R \u0010\u0019\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001b0\t0\u001a8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0010\u0010\u001e\u001a\u00020\u001fX\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010 R\u0014\u0010!\u001a\u00020\"8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b#\u0010$R\u0016\u0010%\u001a\n\u0012\u0004\u0012\u00020&\u0018\u00010\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010'\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010$R\u0011\u0010(\u001a\u00020\"\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010$R(\u0010*\u001a\u0004\u0018\u00010\u00022\b\u0010)\u001a\u0004\u0018\u00010\u0002@RX\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u0014\u0010/\u001a\u000200X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0014\u0010\u0003\u001a\u00020\u0004X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104\u00a8\u0006>"}, d2={"Lorg/jetbrains/wip/WipSuspendContext;", "Lorg/jetbrains/debugger/SuspendContextBase;", "Lorg/jetbrains/wip/WipCallFrame;", "vm", "Lorg/jetbrains/wip/WipVm;", "data", "Lorg/jetbrains/wip/protocol/debugger/PausedEventData;", "(Lorg/jetbrains/wip/WipVm;Lorg/jetbrains/wip/protocol/debugger/PausedEventData;)V", "_asyncFrames", "", "Lorg/jetbrains/wip/WipAsyncCallFrame;", "[Lorg/jetbrains/wip/WipAsyncCallFrame;", "_frames", "[Lorg/jetbrains/wip/WipCallFrame;", "breakpointsHit", "", "Lorg/jetbrains/debugger/Breakpoint;", "getBreakpointsHit", "()Ljava/util/List;", "exceptionData", "Lorg/jetbrains/debugger/ExceptionData;", "getExceptionData", "()Lorg/jetbrains/debugger/ExceptionData;", "setExceptionData", "(Lorg/jetbrains/debugger/ExceptionData;)V", "frames", "Lorg/jetbrains/concurrency/Promise;", "Lorg/jetbrains/debugger/CallFrame;", "getFrames", "()Lorg/jetbrains/concurrency/Promise;", "framesLoader", "org/jetbrains/wip/WipSuspendContext$framesLoader$1", "Lorg/jetbrains/wip/WipSuspendContext$framesLoader$1;", "hasUnresolvedBreakpointsHit", "", "getHasUnresolvedBreakpointsHit", "()Z", "hitBreakpoints", "", "isBreakOnFirstStatement", "isBreakOnStart", "value", "topFrame", "getTopFrame", "()Lorg/jetbrains/wip/WipCallFrame;", "setTopFrame", "(Lorg/jetbrains/wip/WipCallFrame;)V", "valueManager", "Lorg/jetbrains/wip/WipValueManager;", "getValueManager", "()Lorg/jetbrains/wip/WipValueManager;", "getVm", "()Lorg/jetbrains/wip/WipVm;", "isInstrumentationBreakpoint", "isMeteorOnStartDebuggerStatement", "reloadFrames", "setFrames", "", "frameDataList", "Lorg/jetbrains/wip/protocol/debugger/CallFrameValue;", "asyncFrameDataList", "Lorg/jetbrains/wip/protocol/runtime/StackTraceValue;", "intellij.javascript.wip.backend"})
public final class WipSuspendContext
extends SuspendContextBase<WipCallFrame> {
    @NotNull
    private final WipValueManager valueManager;
    private final List<String> hitBreakpoints;
    @Nullable
    private volatile WipCallFrame topFrame;
    private volatile WipCallFrame[] _frames;
    private volatile WipAsyncCallFrame[] _asyncFrames;
    @Nullable
    private ExceptionData exceptionData;
    private final boolean isBreakOnStart;
    private final boolean isBreakOnFirstStatement;
    private final framesLoader.1 framesLoader;
    @NotNull
    private final WipVm vm;

    @NotNull
    public WipValueManager getValueManager() {
        return this.valueManager;
    }

    @Nullable
    public WipCallFrame getTopFrame() {
        return this.topFrame;
    }

    private void setTopFrame(WipCallFrame value) {
        this.topFrame = value;
    }

    @Nullable
    public ExceptionData getExceptionData() {
        return this.exceptionData;
    }

    public void setExceptionData(@Nullable ExceptionData exceptionData) {
        this.exceptionData = exceptionData;
    }

    public final boolean isBreakOnStart() {
        return this.isBreakOnStart;
    }

    public final boolean isBreakOnFirstStatement() {
        return this.isBreakOnFirstStatement;
    }

    @NotNull
    public Promise<CallFrame[]> getFrames() {
        Promise promise2 = this.framesLoader.get();
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"framesLoader.get()");
        return promise2;
    }

    private final boolean isInstrumentationBreakpoint(PausedEventData data) {
        block7: {
            if (data.reason() == PausedEventData.Reason.INSTRUMENTATION) {
                return true;
            }
            PausedEventData.Data additionalData = data.getData();
            if (data.reason() == PausedEventData.Reason.EVENT_LISTENER && additionalData != null) {
                try {
                    JsonReaderEx reader = additionalData.getDeferredReader();
                    if (reader.peek() != JsonToken.BEGIN_OBJECT) break block7;
                    reader.beginObject();
                    while (reader.peek() == JsonToken.NAME) {
                        String name = reader.nextName();
                        if (Intrinsics.areEqual((Object)name, (Object)"eventName")) {
                            if (reader.peek() == JsonToken.STRING && Intrinsics.areEqual((Object)reader.nextString(), (Object)"instrumentation:scriptFirstStatement")) {
                                return true;
                            }
                            break;
                        }
                        reader.skipValue();
                    }
                }
                catch (JsonParseException jsonParseException) {
                    // empty catch block
                }
            }
        }
        return false;
    }

    private final boolean isMeteorOnStartDebuggerStatement(PausedEventData data) {
        WipScript script;
        org.jetbrains.wip.protocol.debugger.CallFrameValue topFrame;
        if (Intrinsics.areEqual((Object)((Boolean)this.getVm().getUserData(WipSuspendContextKt.getIS_METEOR())), (Object)true) ^ true) {
            return false;
        }
        List<org.jetbrains.wip.protocol.debugger.CallFrameValue> callFrames = data.callFrames();
        if (!callFrames.isEmpty() && Intrinsics.areEqual((Object)(topFrame = callFrames.get(0)).functionName(), (Object)"exports.pause") && (script = (WipScript)this.getVm().getScriptManager().findScriptById(topFrame.location().scriptId())) != null) {
            String string = script.getUrl().getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"script.url.path");
            if (StringsKt.endsWith$default((String)string, (String)"/debug.js", (boolean)false, (int)2, null)) {
                Thread.sleep(102L);
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public final void setFrames(@NotNull List<? extends org.jetbrains.wip.protocol.debugger.CallFrameValue> frameDataList, @Nullable StackTraceValue asyncFrameDataList) {
        WipCallFrame[] frames;
        int it;
        WipCallFrame wipCallFrame;
        WipCallFrame[] wipCallFrameArray;
        int n;
        Intrinsics.checkNotNullParameter(frameDataList, (String)"frameDataList");
        int n2 = frameDataList.size();
        WipCallFrame[] wipCallFrameArray2 = new WipCallFrame[n2];
        int n3 = 0;
        while (n3 < n2) {
            int n4 = n3;
            n = n3++;
            wipCallFrameArray = wipCallFrameArray2;
            boolean bl = false;
            wipCallFrameArray[n] = wipCallFrame = new WipCallFrame(this.getValueManager(), frameDataList.get(it));
        }
        WipCallFrame[] wipCallFrameArray3 = frames = wipCallFrameArray2;
        boolean bl = false;
        WipCallFrame[] wipCallFrameArray4 = wipCallFrameArray3;
        it = 0;
        if (!(wipCallFrameArray4.length == 0)) {
            this.setTopFrame(frames[0]);
        }
        this._frames = frames;
        bl = false;
        List asyncFrames = new ArrayList();
        for (StackTraceValue currentStackTrace = asyncFrameDataList; currentStackTrace != null; currentStackTrace = currentStackTrace.getParent()) {
            String description = currentStackTrace.getDescription();
            Iterable $this$forEachIndexed$iv = currentStackTrace.callFrames();
            boolean $i$f$forEachIndexed = false;
            int index$iv = 0;
            for (Object item$iv : $this$forEachIndexed$iv) {
                void callFrameValue;
                int n5 = index$iv++;
                boolean bl2 = false;
                if (n5 < 0) {
                    CollectionsKt.throwIndexOverflow();
                }
                CallFrameValue callFrameValue2 = (CallFrameValue)item$iv;
                int i = n5;
                boolean bl3 = false;
                asyncFrames.add(new WipAsyncCallFrame((CallFrameValue)callFrameValue, i == 0 ? description : null));
            }
        }
        Collection $this$toTypedArray$iv = asyncFrames;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        WipAsyncCallFrame[] wipAsyncCallFrameArray = thisCollection$iv.toArray(new WipAsyncCallFrame[0]);
        if (wipAsyncCallFrameArray == null) {
            throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        this._asyncFrames = wipAsyncCallFrameArray;
        int n6 = frames.length + asyncFrames.size();
        CallFrame[] callFrameArray = new CallFrame[n6];
        for (int i = 0; i < n6; ++i) {
            void it2;
            int n7 = i;
            n = i;
            wipCallFrameArray = callFrameArray;
            boolean bl4 = false;
            wipCallFrameArray[n] = wipCallFrame = it2 < frames.length ? (CallFrame)frames[it2] : (CallFrame)asyncFrames.get((int)(it2 - frames.length));
        }
        CallFrame[] result = callFrameArray;
        this.framesLoader.set(result);
    }

    public boolean getHasUnresolvedBreakpointsHit() {
        if (UtilKt.isNullOrEmpty((Collection)this.hitBreakpoints)) {
            return false;
        }
        HashSet hitVmBreakpoints = new HashSet(this.hitBreakpoints);
        for (WipBreakpoint breakpoint : this.getValueManager().getVm().getBreakpointManager().getBreakpoints()) {
            hitVmBreakpoints.remove(breakpoint.getVmIdImmediately());
        }
        Collection collection = hitVmBreakpoints;
        boolean bl = false;
        return !collection.isEmpty();
    }

    @NotNull
    public List<Breakpoint> getBreakpointsHit() {
        Set breakpoints = this.getValueManager().getVm().getBreakpointManager().getBreakpoints();
        if (this.hitBreakpoints != null) {
            SmartList result = new SmartList();
            for (WipBreakpoint breakpoint : breakpoints) {
                String vmId = breakpoint.getVmIdImmediately();
                if (vmId == null || !this.hitBreakpoints.contains(vmId)) continue;
                result.add((Object)breakpoint);
            }
            return (List)result;
        }
        WipCallFrame wipCallFrame = this.getTopFrame();
        if (wipCallFrame == null) {
            return CollectionsKt.emptyList();
        }
        WipCallFrame topFrame = wipCallFrame;
        int line = topFrame.getLine();
        int column = topFrame.getColumn();
        List result = null;
        block1: for (WipBreakpoint breakpoint : breakpoints) {
            for (LocationValue actualLocation : breakpoint.getActualLocations()) {
                int actualColumnNumber = actualLocation.getColumnNumber();
                if (!Intrinsics.areEqual((Object)actualLocation.scriptId(), (Object)topFrame.getScriptId()) || actualLocation.getLineNumber() != line || actualColumnNumber != column && actualColumnNumber > 0) continue;
                if (result == null) {
                    result = (List)new SmartList();
                }
                result.add(breakpoint);
                continue block1;
            }
        }
        List list = result;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    @NotNull
    public final Promise<?> reloadFrames() {
        this.framesLoader.markDirty();
        Promise promise2 = this.framesLoader.get();
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"framesLoader.get()");
        Promise $this$thenRun$iv = promise2;
        boolean $i$f$thenRun = false;
        Promise promise3 = $this$thenRun$iv.then((Function)new Function<Object, Unit>(this){
            final /* synthetic */ WipSuspendContext this$0;
            {
                this.this$0 = wipSuspendContext;
            }

            public final Unit fun(@Nullable Object it) {
                boolean bl = false;
                this.this$0.getValueManager().clearCaches();
                return Unit.INSTANCE;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"(this as Promise<Any?>).then { handler() }");
        return promise3;
    }

    @NotNull
    public WipVm getVm() {
        return this.vm;
    }

    public WipSuspendContext(@NotNull WipVm vm, @NotNull PausedEventData data) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        this.vm = vm;
        this.valueManager = new WipValueManager(this.getVm(), null);
        this.framesLoader = new AsyncValueLoader<CallFrame[]>(this){
            final /* synthetic */ WipSuspendContext this$0;

            /*
             * WARNING - void declaration
             */
            @NotNull
            protected Promise<CallFrame[]> load(@NotNull AsyncPromise<CallFrame[]> result) {
                Intrinsics.checkNotNullParameter(result, (String)"result");
                WipCallFrame[] wipCallFrameArray = WipSuspendContext.access$get_frames$p(this.this$0);
                Intrinsics.checkNotNull((Object)wipCallFrameArray);
                int n = wipCallFrameArray.length;
                WipAsyncCallFrame[] wipAsyncCallFrameArray = WipSuspendContext.access$get_asyncFrames$p(this.this$0);
                Intrinsics.checkNotNull((Object)wipAsyncCallFrameArray);
                int n2 = n + wipAsyncCallFrameArray.length;
                CallFrame[] callFrameArray = new CallFrame[n2];
                for (int i = 0; i < n2; ++i) {
                    CallFrame callFrame;
                    CallFrame callFrame2;
                    void i2;
                    int n3 = i;
                    int n4 = i;
                    CallFrame[] callFrameArray2 = callFrameArray;
                    boolean bl = false;
                    WipCallFrame[] wipCallFrameArray2 = WipSuspendContext.access$get_frames$p(this.this$0);
                    Intrinsics.checkNotNull((Object)wipCallFrameArray2);
                    if (i2 < wipCallFrameArray2.length) {
                        WipCallFrame[] wipCallFrameArray3 = WipSuspendContext.access$get_frames$p(this.this$0);
                        Intrinsics.checkNotNull((Object)wipCallFrameArray3);
                        callFrame2 = wipCallFrameArray3[i2];
                    } else {
                        WipAsyncCallFrame[] wipAsyncCallFrameArray2 = WipSuspendContext.access$get_asyncFrames$p(this.this$0);
                        Intrinsics.checkNotNull((Object)wipAsyncCallFrameArray2);
                        WipCallFrame[] wipCallFrameArray4 = WipSuspendContext.access$get_frames$p(this.this$0);
                        Intrinsics.checkNotNull((Object)wipCallFrameArray4);
                        callFrame2 = wipAsyncCallFrameArray2[i2 - wipCallFrameArray4.length];
                    }
                    callFrameArray2[n4] = callFrame = callFrame2;
                }
                return Promises.resolvedPromise((Object)callFrameArray);
            }
            {
                this.this$0 = this$0;
            }
        };
        PausedEventData.Data additionalData = data.getData();
        if (data.reason() == PausedEventData.Reason.EXCEPTION && additionalData != null) {
            WipValueManager wipValueManager = this.getValueManager();
            WipProtocolReader wipProtocolReader = WipReaderService.get();
            JsonReaderEx jsonReaderEx = additionalData.getDeferredReader();
            Intrinsics.checkNotNullExpressionValue((Object)jsonReaderEx, (String)"additionalData.deferredReader");
            this.setExceptionData(new WipExceptionData(wipValueManager.createValue(wipProtocolReader.parseRemoteObjectValue(jsonReaderEx))));
        } else {
            this.setExceptionData(null);
        }
        Object isFirstPauseMarker = new Object();
        boolean isFirstPause = UtilKt.isNullOrEmpty((Collection)data.getHitBreakpoints()) && Intrinsics.areEqual((Object)this.getVm().putUserDataIfAbsent(WipSuspendContextKt.access$getIS_FIRST_PAUSE$p(), isFirstPauseMarker), (Object)isFirstPauseMarker);
        this.isBreakOnStart = data.reason() == PausedEventData.Reason.BREAK_ON_START || data.reason() == PausedEventData.Reason.DEBUG_COMMAND || isFirstPause && Intrinsics.areEqual((Object)((Boolean)this.getVm().getUserData(WipSuspendContextKt.getSKIP_FIRST_PAUSE())), (Object)true);
        this.isBreakOnFirstStatement = this.isInstrumentationBreakpoint(data) || this.isMeteorOnStartDebuggerStatement(data);
        List<org.jetbrains.wip.protocol.debugger.CallFrameValue> callFrames = data.callFrames();
        this.setFrames(callFrames, data.getAsyncStackTrace());
        this.hitBreakpoints = data.getHitBreakpoints();
    }

    public static final /* synthetic */ WipCallFrame[] access$get_frames$p(WipSuspendContext $this) {
        return $this._frames;
    }

    public static final /* synthetic */ void access$set_frames$p(WipSuspendContext $this, WipCallFrame[] wipCallFrameArray) {
        $this._frames = wipCallFrameArray;
    }

    public static final /* synthetic */ WipAsyncCallFrame[] access$get_asyncFrames$p(WipSuspendContext $this) {
        return $this._asyncFrames;
    }

    public static final /* synthetic */ void access$set_asyncFrames$p(WipSuspendContext $this, WipAsyncCallFrame[] wipAsyncCallFrameArray) {
        $this._asyncFrames = wipAsyncCallFrameArray;
    }
}

