/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.v8.value;

import com.intellij.util.Function;
import com.intellij.util.containers.IntIntHashMap;
import com.intellij.util.containers.UtilKt;
import gnu.trove.TIntObjectHashMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Obsolescent;
import org.jetbrains.concurrency.ObsolescentFunction;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;
import org.jetbrains.debugger.values.PrimitiveValue;
import org.jetbrains.debugger.values.Value;
import org.jetbrains.debugger.values.ValueManager;
import org.jetbrains.debugger.values.ValueType;
import org.jetbrains.jsonProtocol.Request;
import org.jetbrains.v8.V8Vm;
import org.jetbrains.v8.protocol.GetObjectsResult;
import org.jetbrains.v8.protocol.Handle;
import org.jetbrains.v8.protocol.LookupMessage;
import org.jetbrains.v8.protocol.ObjectDescriptor;
import org.jetbrains.v8.protocol.PropertyDescriptor;
import org.jetbrains.v8.protocol.Protocol_exKt;
import org.jetbrains.v8.protocol.SomeHandle;
import org.jetbrains.v8.protocol.SomeRef;
import org.jetbrains.v8.protocol.ValueHandle;
import org.jetbrains.v8.value.ArrayReference;
import org.jetbrains.v8.value.DataWithRef;
import org.jetbrains.v8.value.FunctionReference;
import org.jetbrains.v8.value.LoadableString;
import org.jetbrains.v8.value.ObjectReference;
import org.jetbrains.v8.value.PropertyItem;
import org.jetbrains.v8.value.V8Function;
import org.jetbrains.v8.value.V8Object;
import org.jetbrains.v8.value.V8PrimitiveValue;
import org.jetbrains.v8.value.V8ValueManager$WhenMappings;
import org.jetbrains.v8.value.V8ValueManagerKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000t\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0011\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0010\u0010\n\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000b\u001a\u00020\fJ\b\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0012\u001a\u00020\u0013J\u000e\u0010\u000f\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\u0010\u0010\u0019\u001a\u00020\u00072\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0016\u0010\u001a\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00070\u001b2\u0006\u0010\u001c\u001a\u00020\u001dJ \u0010\u001e\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u001f0\u001b2\f\u0010 \u001a\b\u0012\u0004\u0012\u00020\"0!J\u0010\u0010#\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u001c\u001a\u00020\u001dJ/\u0010$\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\u0007 %*\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u001f0\u001f0\u001b\u00a2\u0006\u0002\b&2\u0006\u0010'\u001a\u00020(H\u0002J\u0016\u0010)\u001a\u00020\u000e2\u000e\u0010*\u001a\n\u0012\u0004\u0012\u00020\u0011\u0018\u00010!R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\t\u00a8\u0006+"}, d2={"Lorg/jetbrains/v8/value/V8ValueManager;", "Lorg/jetbrains/debugger/values/ValueManager;", "vm", "Lorg/jetbrains/v8/V8Vm;", "(Lorg/jetbrains/v8/V8Vm;)V", "refToValue", "Lit/unimi/dsi/fastutil/ints/Int2ObjectOpenHashMap;", "Lorg/jetbrains/debugger/values/Value;", "getVm", "()Lorg/jetbrains/v8/V8Vm;", "addHandleFromRefs", "handle", "Lorg/jetbrains/v8/protocol/Handle;", "clearCaches", "", "createValue", "objectDescriptor", "Lorg/jetbrains/v8/protocol/ObjectDescriptor;", "propertyDescriptor", "Lorg/jetbrains/v8/protocol/PropertyDescriptor;", "valueHandle", "Lorg/jetbrains/v8/protocol/ValueHandle;", "createValueIfSure", "refWithDisplayData", "Lorg/jetbrains/v8/protocol/SomeRef;", "doCreateValue", "getOrLoadValue", "Lorg/jetbrains/concurrency/Promise;", "id", "", "getOrLoadValueFromRefs", "", "propertyRefs", "", "Lorg/jetbrains/v8/value/PropertyItem;", "getValue", "loadValuesFromRemote", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "propertyRefIds", "", "store", "objects", "intellij.javascript.v8.backend"})
public final class V8ValueManager
extends ValueManager {
    private final Int2ObjectOpenHashMap<Value> refToValue;
    @NotNull
    private final V8Vm vm;

    private final Value createValueIfSure(SomeRef refWithDisplayData) {
        String value;
        ValueType type;
        ValueType valueType;
        String className = refWithDisplayData.getClassName();
        String typeString = refWithDisplayData.getType();
        if (typeString == null && className == null) {
            valueType = null;
        } else {
            String string = typeString;
            Intrinsics.checkNotNull((Object)string);
            valueType = type = V8ValueManagerKt.access$calculateType(string, className, false);
        }
        if (type == ValueType.STRING) {
            String string = refWithDisplayData.getValue();
            Intrinsics.checkNotNull((Object)string);
            String possiblyTruncatedValue = string;
            if (possiblyTruncatedValue.length() > 100) {
                String pattern = "... (length: ";
                if (StringsKt.regionMatches$default((String)possiblyTruncatedValue, (int)100, (String)pattern, (int)0, (int)pattern.length(), (boolean)false, (int)16, null)) {
                    int beginIndex = 100 + pattern.length();
                    String string2 = possiblyTruncatedValue;
                    int n = StringsKt.indexOf$default((CharSequence)possiblyTruncatedValue, (char)')', (int)beginIndex, (boolean)false, (int)4, null);
                    boolean bl = false;
                    String string3 = string2;
                    if (string3 == null) {
                        throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                    }
                    String string4 = string3.substring(beginIndex, n);
                    Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    int actualLength = Integer.parseInt(string4);
                    return (Value)new LoadableString(this, refWithDisplayData.getRef(), possiblyTruncatedValue, actualLength);
                }
                return null;
            }
        } else if (!V8ValueManagerKt.access$getTYPES_WITH_ACCURATE_DISPLAY$p().contains(type)) {
            return null;
        }
        if ((value = refWithDisplayData.getValue()) == null) {
            value = typeString;
        }
        int n = refWithDisplayData.getRef();
        ValueType valueType2 = type;
        Intrinsics.checkNotNull((Object)valueType2);
        String string = value;
        Intrinsics.checkNotNull((Object)string);
        return (Value)new V8PrimitiveValue(n, valueType2, string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCaches() {
        super.clearCaches();
        Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (int2ObjectOpenHashMap) {
            boolean bl3 = false;
            this.refToValue.clear();
            Unit unit = Unit.INSTANCE;
        }
    }

    @Nullable
    public final Value addHandleFromRefs(@NotNull Handle handle) {
        Intrinsics.checkNotNullParameter((Object)handle, (String)"handle");
        String type = handle.type();
        if (!Intrinsics.areEqual((Object)"script", (Object)type) && !Intrinsics.areEqual((Object)"context", (Object)type)) {
            return this.createValue(handle instanceof ValueHandle ? (ValueHandle)handle : ((SomeHandle)handle).asValueHandle());
        }
        return null;
    }

    private final Value doCreateValue(ValueHandle valueHandle) {
        String string = valueHandle.type();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"valueHandle.type()");
        ValueType type = V8ValueManagerKt.access$calculateType(string, valueHandle.className(), true);
        if (V8ValueManagerKt.access$getTYPES_WITH_ACCURATE_DISPLAY$p().contains(type)) {
            String string2 = valueHandle.value() == null ? valueHandle.type() : valueHandle.value();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"if (valueHandle.value() \u2026 else valueHandle.value()");
            return (Value)new PrimitiveValue(type, string2);
        }
        if (type == ValueType.STRING) {
            int length = valueHandle.length();
            int toIndex = valueHandle.toIndex();
            if (length != -1 && toIndex != -1 && length != toIndex) {
                return (Value)new LoadableString(this, valueHandle.handle(), valueHandle.value(), length);
            }
            int n = valueHandle.handle();
            String string3 = valueHandle.value();
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"valueHandle.value()");
            return (Value)new V8PrimitiveValue(n, type, string3);
        }
        return type == ValueType.FUNCTION ? (Value)new V8Function(valueHandle, this) : (Value)new V8Object(type, valueHandle, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public final Value createValue(@NotNull ValueHandle valueHandle) {
        Value value;
        Intrinsics.checkNotNullParameter((Object)valueHandle, (String)"valueHandle");
        Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (int2ObjectOpenHashMap) {
            boolean bl3 = false;
            Value mirror = (Value)this.refToValue.get(valueHandle.handle());
            if (mirror == null) {
                mirror = this.doCreateValue(valueHandle);
                this.refToValue.put(valueHandle.handle(), (Object)mirror);
            }
            value = mirror;
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @Nullable
    public final Value createValue(@NotNull PropertyDescriptor propertyDescriptor) {
        void valueType;
        Intrinsics.checkNotNullParameter((Object)propertyDescriptor, (String)"propertyDescriptor");
        if (propertyDescriptor.getObjectId() != -1) {
            Value value;
            Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (int2ObjectOpenHashMap) {
                boolean bl3 = false;
                value = (Value)this.refToValue.get(propertyDescriptor.getObjectId());
            }
            return value;
        }
        ValueType valueType2 = ValueType.Companion.fromIndex(propertyDescriptor.getType());
        switch (V8ValueManager$WhenMappings.$EnumSwitchMapping$0[valueType2.ordinal()]) {
            case 1: {
                return (Value)PrimitiveValue.NULL;
            }
            case 2: {
                return (Value)PrimitiveValue.UNDEFINED;
            }
            case 3: {
                String string = propertyDescriptor.getValue();
                Intrinsics.checkNotNull((Object)string);
                return (Value)PrimitiveValue.Companion.bool(string);
            }
            case 4: 
            case 5: {
                String string = propertyDescriptor.getValue();
                Intrinsics.checkNotNull((Object)string);
                return (Value)new PrimitiveValue((ValueType)valueType, string);
            }
        }
        throw (Throwable)new IllegalArgumentException(valueType.name());
    }

    /*
     * WARNING - void declaration
     */
    private final Value createValue(ObjectDescriptor objectDescriptor) {
        void valueType;
        ValueType valueType2 = ValueType.Companion.fromIndex(objectDescriptor.getType());
        switch (V8ValueManager$WhenMappings.$EnumSwitchMapping$1[valueType2.ordinal()]) {
            case 1: {
                int length = objectDescriptor.getLength();
                String string = objectDescriptor.getDescription();
                Intrinsics.checkNotNull((Object)string);
                String value = string;
                if (length != -1 && length > value.length()) {
                    return (Value)new LoadableString(this, objectDescriptor.getId(), value, length);
                }
                return (Value)new V8PrimitiveValue(objectDescriptor.getId(), (ValueType)valueType, value);
            }
            case 2: {
                return (Value)new ObjectReference((ValueType)valueType, objectDescriptor, this);
            }
            case 3: {
                return (Value)new FunctionReference(objectDescriptor, this);
            }
            case 4: {
                return (Value)new ArrayReference(objectDescriptor, this);
            }
        }
        throw (Throwable)new IllegalArgumentException(valueType.name());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final Value getValue(int id) {
        Value value;
        Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (int2ObjectOpenHashMap) {
            boolean bl3 = false;
            value = (Value)this.refToValue.get(id);
        }
        return value;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Value> getOrLoadValue(int id) {
        Value value = this.getValue(id);
        if (value == null) {
            void $this$then$iv;
            Promise promise2 = this.vm.getCommandProcessor().send((Request)Protocol_exKt.GetObjects$default(id, 0, false, 6, null));
            Obsolescent obsolescent$iv = (Obsolescent)this;
            boolean $i$f$then = false;
            Promise promise3 = $this$then$iv.then((Function)new ObsolescentFunction<GetObjectsResult, Value>(obsolescent$iv, this, id){
                final /* synthetic */ Obsolescent $obsolescent;
                final /* synthetic */ V8ValueManager this$0;
                final /* synthetic */ int $id$inlined;
                {
                    this.$obsolescent = $captured_local_variable$1;
                    this.this$0 = v8ValueManager;
                    this.$id$inlined = n;
                }

                /*
                 * Ignored method signature, as it can't be verified against descriptor
                 */
                public Object fun(Object param) {
                    GetObjectsResult it = (GetObjectsResult)param;
                    boolean bl = false;
                    this.this$0.store(it.objects());
                    return this.this$0.getValue(this.$id$inlined);
                }

                public boolean isObsolete() {
                    return this.$obsolescent.isObsolete();
                }
            });
            Intrinsics.checkNotNullExpressionValue((Object)promise3, (String)"then(object : Obsolescen\u2026obsolescent.isObsolete\n})");
            return promise3;
        }
        return Promises.resolvedPromise((Object)value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    @NotNull
    public final Promise<Value[]> getOrLoadValueFromRefs(@NotNull List<? extends PropertyItem> propertyRefs) {
        Intrinsics.checkNotNullParameter(propertyRefs, (String)"propertyRefs");
        Value[] result = new Value[propertyRefs.size()];
        if (propertyRefs.isEmpty()) {
            return Promises.resolvedPromise((Object)result);
        }
        IntIntHashMap refToRequestIndex = new IntIntHashMap();
        IntArrayList needsLoading = null;
        int n = 0;
        int n2 = ((Collection)propertyRefs).size();
        while (n < n2) {
            Value value;
            void i;
            PropertyItem property = propertyRefs.get((int)i);
            DataWithRef dataWithRef = property.getValueObject();
            int ref = dataWithRef.ref();
            Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (int2ObjectOpenHashMap) {
                boolean bl3 = false;
                value = (Value)this.refToValue.get(ref);
            }
            Value mirror = value;
            if (mirror == null) {
                DataWithRef dataWithRef2 = dataWithRef;
                Intrinsics.checkNotNullExpressionValue((Object)dataWithRef2, (String)"dataWithRef");
                SomeRef dataWithDisplayData = dataWithRef2.getWithDisplayData();
                if (dataWithDisplayData != null) {
                    mirror = this.createValueIfSure(dataWithDisplayData);
                }
            }
            if (mirror == null) {
                int requestPos = refToRequestIndex.get(ref);
                if (requestPos == -1) {
                    if (needsLoading == null) {
                        needsLoading = new IntArrayList();
                    }
                    refToRequestIndex.put(ref, needsLoading.size());
                    needsLoading.add(property.getRef());
                }
            } else {
                result[i] = mirror;
            }
            ++i;
        }
        if (needsLoading == null) {
            return Promises.resolvedPromise((Object)result);
        }
        int[] nArray = needsLoading.toIntArray();
        Intrinsics.checkNotNullExpressionValue((Object)nArray, (String)"needsLoading.toIntArray()");
        Promise promise2 = this.loadValuesFromRemote(nArray).then((Function)new Function<Value[], Value[]>(propertyRefs, result, refToRequestIndex){
            final /* synthetic */ List $propertyRefs;
            final /* synthetic */ Value[] $result;
            final /* synthetic */ IntIntHashMap $refToRequestIndex;

            /*
             * WARNING - void declaration
             */
            public final Value[] fun(Value[] it) {
                int n = 0;
                int n2 = ((Collection)this.$propertyRefs).size();
                while (n < n2) {
                    void i;
                    if (this.$result[i] == null) {
                        this.$result[i] = it[this.$refToRequestIndex.get(((PropertyItem)this.$propertyRefs.get((int)i)).getValueObject().ref())];
                    }
                    ++i;
                }
                if (this.$result == null) {
                    throw new NullPointerException("null cannot be cast to non-null type kotlin.Array<org.jetbrains.debugger.values.Value>");
                }
                return this.$result;
            }
            {
                this.$propertyRefs = list;
                this.$result = valueArray;
                this.$refToRequestIndex = intIntHashMap;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"loadValuesFromRemote(nee\u2026 as Array<Value>)\n      }");
        return promise2;
    }

    private final Promise<Value[]> loadValuesFromRemote(int[] propertyRefIds) {
        Promise promise2 = this.vm.getCommandProcessor().send((Request)new LookupMessage(propertyRefIds, false, 0, 4, null)).then((Function)new Function<TIntObjectHashMap<ValueHandle>, Value[]>(this, propertyRefIds){
            final /* synthetic */ V8ValueManager this$0;
            final /* synthetic */ int[] $propertyRefIds;

            /*
             * WARNING - void declaration
             */
            public final Value[] fun(TIntObjectHashMap<ValueHandle> objects) {
                void var2_12;
                int n = this.$propertyRefIds.length;
                Value[] valueArray = new Value[n];
                int n2 = 0;
                while (n2 < n) {
                    Value value;
                    ValueHandle valueHandle;
                    void it;
                    int n3 = n2;
                    int n4 = n2++;
                    Value[] valueArray2 = valueArray;
                    boolean bl = false;
                    int ref = this.$propertyRefIds[it];
                    if ((ValueHandle)objects.get(ref) == null) {
                        throw (Throwable)new IllegalStateException("Failed to find value for ref=" + ref);
                    }
                    if (valueHandle.handle() != ref) {
                        throw (Throwable)new IllegalStateException("Inconsistent ref in response, ref=" + ref);
                    }
                    valueArray2[n4] = value = this.this$0.createValue(valueHandle);
                }
                Value[] result = valueArray;
                return var2_12;
            }
            {
                this.this$0 = v8ValueManager;
                this.$propertyRefIds = nArray;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)promise2, (String)"vm.commandProcessor.send\u2026     }\n      result\n    }");
        return promise2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void store(@Nullable List<? extends ObjectDescriptor> objects) {
        if (UtilKt.isNullOrEmpty((Collection)objects)) {
            return;
        }
        Int2ObjectOpenHashMap<Value> int2ObjectOpenHashMap = this.refToValue;
        boolean bl = false;
        boolean bl2 = false;
        synchronized (int2ObjectOpenHashMap) {
            boolean bl3 = false;
            List<? extends ObjectDescriptor> list = objects;
            Intrinsics.checkNotNull(list);
            for (ObjectDescriptor objectDescriptor : list) {
                this.refToValue.put(objectDescriptor.getId(), (Object)this.createValue(objectDescriptor));
            }
            Unit unit = Unit.INSTANCE;
        }
    }

    @NotNull
    public final V8Vm getVm() {
        return this.vm;
    }

    public V8ValueManager(@NotNull V8Vm vm) {
        Intrinsics.checkNotNullParameter((Object)((Object)vm), (String)"vm");
        this.vm = vm;
        this.refToValue = new Int2ObjectOpenHashMap();
    }
}

