/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.lang.metadata.stubs;

import com.intellij.json.psi.JsonArray;
import com.intellij.json.psi.JsonObject;
import com.intellij.json.psi.JsonProperty;
import com.intellij.json.psi.JsonStringLiteral;
import com.intellij.json.psi.JsonValue;
import com.intellij.lang.javascript.index.flags.BooleanStructureElement;
import com.intellij.lang.javascript.index.flags.FlagsStructure;
import com.intellij.lang.javascript.index.flags.FlagsStructureElement;
import com.intellij.lang.javascript.index.flags.IntFlagsSerializer;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.io.DataInputOutputUtilRt;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.stubs.IndexSink;
import com.intellij.psi.stubs.StubBase;
import com.intellij.psi.stubs.StubElement;
import com.intellij.psi.stubs.StubInputStream;
import com.intellij.psi.stubs.StubOutputStream;
import com.intellij.util.ObjectUtils;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.StringRef;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.angular2.lang.metadata.MetadataUtils;
import org.angular2.lang.metadata.psi.MetadataElement;
import org.angular2.lang.metadata.psi.MetadataElementType;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MetadataElementStub<Psi extends MetadataElement>
extends StubBase<Psi> {
    @NonNls
    protected static final String SYMBOL_TYPE = "__symbolic";
    @NonNls
    protected static final String SYMBOL_REFERENCE = "reference";
    @NonNls
    protected static final String SYMBOL_PROPERTY = "property";
    @NonNls
    protected static final String SYMBOL_FUNCTION = "function";
    @NonNls
    protected static final String SYMBOL_METHOD = "method";
    @NonNls
    protected static final String SYMBOL_CALL = "call";
    @NonNls
    protected static final String SYMBOL_CLASS = "class";
    @NonNls
    protected static final String SYMBOL_SPREAD = "spread";
    @NonNls
    protected static final String PARAMETER_DECORATORS = "parameterDecorators";
    @NonNls
    protected static final String DECORATORS = "decorators";
    @NonNls
    protected static final String EXPRESSION = "expression";
    @NonNls
    protected static final String ARGUMENTS = "arguments";
    @NonNls
    protected static final String MEMBERS = "members";
    @NonNls
    protected static final String STATICS = "statics";
    @NonNls
    protected static final String EXTENDS = "extends";
    @NonNls
    protected static final String CONSTRUCTOR = "__ctor__";
    @NonNls
    protected static final String REFERENCE_NAME = "name";
    @NonNls
    protected static final String REFERENCE_MODULE = "module";
    @NonNls
    protected static final String FUNCTION_VALUE = "value";
    @NonNls
    protected static final String STRING_TYPE = "#string";
    @NonNls
    protected static final String ARRAY_TYPE = "#array";
    @NonNls
    protected static final String OBJECT_TYPE = "#object";
    private static final BooleanStructureElement HAS_MEMBER_NAME = new BooleanStructureElement();
    protected static final FlagsStructure FLAGS_STRUCTURE = new FlagsStructure(new FlagsStructureElement[]{HAS_MEMBER_NAME});
    private final StringRef myMemberName;
    private int myFlags;
    private final NotNullLazyValue<Map<String, MetadataElementStub>> membersMap;

    public MetadataElementStub(@Nullable String memberName, @Nullable StubElement parent, @NotNull MetadataElementType elementType) {
        if (elementType == null) {
            MetadataElementStub.$$$reportNull$$$0(0);
        }
        super(parent, (IStubElementType)elementType);
        this.membersMap = NotNullLazyValue.atomicLazy(() -> this.getChildrenStubs().stream().filter(stub -> ((MetadataElementStub)((Object)((Object)((Object)stub)))).getMemberName() != null).collect(Collectors.toMap(stub -> ((MetadataElementStub)((Object)((Object)((Object)stub)))).getMemberName(), stub -> (MetadataElementStub)((Object)((Object)((Object)stub))), (a, b) -> a)));
        this.myMemberName = StringRef.fromString((String)memberName);
    }

    public MetadataElementStub(@NotNull StubInputStream stream, @Nullable StubElement parent, @NotNull MetadataElementType elementType) throws IOException {
        if (stream == null) {
            MetadataElementStub.$$$reportNull$$$0(1);
        }
        if (elementType == null) {
            MetadataElementStub.$$$reportNull$$$0(2);
        }
        super(parent, (IStubElementType)elementType);
        this.membersMap = NotNullLazyValue.atomicLazy(() -> this.getChildrenStubs().stream().filter(stub -> ((MetadataElementStub)((Object)((Object)((Object)stub)))).getMemberName() != null).collect(Collectors.toMap(stub -> ((MetadataElementStub)((Object)((Object)((Object)stub)))).getMemberName(), stub -> (MetadataElementStub)((Object)((Object)((Object)stub))), (a, b) -> a)));
        int flagsSize = this.getFlagsStructure().size();
        if (flagsSize > 0) {
            assert (flagsSize <= 32) : ((Object)((Object)this)).getClass();
            this.myFlags = DataInputOutputUtil.readINT((DataInput)stream);
        }
        this.myMemberName = (Boolean)this.readFlag((FlagsStructureElement)HAS_MEMBER_NAME) != false ? stream.readName() : null;
    }

    @Nullable
    public String getMemberName() {
        return StringRef.toString((StringRef)this.myMemberName);
    }

    protected abstract Map<String, ConstructorFromJsonValue> getTypeFactory();

    public void serialize(@NotNull StubOutputStream stream) throws IOException {
        if (stream == null) {
            MetadataElementStub.$$$reportNull$$$0(3);
        }
        this.writeFlag((FlagsStructureElement)HAS_MEMBER_NAME, this.myMemberName != null);
        if (this.getFlagsStructure().size() > 0) {
            DataInputOutputUtil.writeINT((DataOutput)stream, (int)this.myFlags);
        }
        if (this.myMemberName != null) {
            MetadataElementStub.writeString(this.myMemberName, stream);
        }
    }

    public void index(@NotNull IndexSink sink) {
        if (sink == null) {
            MetadataElementStub.$$$reportNull$$$0(4);
        }
    }

    protected <T> T readFlag(FlagsStructureElement<T> structureElement) {
        return (T)IntFlagsSerializer.INSTANCE.readValue(this.getFlagsStructure(), structureElement, this.myFlags);
    }

    protected <T> void writeFlag(FlagsStructureElement<T> structureElement, T value) {
        this.myFlags = IntFlagsSerializer.INSTANCE.writeValue(this.getFlagsStructure(), structureElement, value, this.myFlags);
    }

    protected FlagsStructure getFlagsStructure() {
        return FLAGS_STRUCTURE;
    }

    protected void loadMemberProperty(@NotNull JsonProperty p) {
        if (p == null) {
            MetadataElementStub.$$$reportNull$$$0(5);
        }
        this.createMember(p.getName(), p.getValue());
    }

    protected void createMember(@Nullable String name, @Nullable JsonValue member) {
        ConstructorFromJsonValue constructor = null;
        if (member instanceof JsonArray) {
            constructor = this.getTypeFactory().get(ARRAY_TYPE);
        } else if (member instanceof JsonObject) {
            String type = MetadataUtils.readStringPropertyValue(((JsonObject)member).findProperty(SYMBOL_TYPE));
            constructor = this.getTypeFactory().get(type == null ? OBJECT_TYPE : type);
        } else if (member instanceof JsonStringLiteral) {
            constructor = this.getTypeFactory().get(STRING_TYPE);
        }
        if (constructor != null) {
            constructor.construct(name, member, (StubElement)this);
        }
    }

    public MetadataElementStub findMember(@Nullable String name) {
        return (MetadataElementStub)((Object)((Map)this.membersMap.getValue()).get(name));
    }

    protected static void writeString(@Nullable StringRef ref, @NotNull StubOutputStream dataStream) throws IOException {
        if (dataStream == null) {
            MetadataElementStub.$$$reportNull$$$0(6);
        }
        dataStream.writeName(StringRef.toString((StringRef)ref));
    }

    protected static void writeStringMap(@NotNull Map<String, String> map, @NotNull StubOutputStream stream) throws IOException {
        if (map == null) {
            MetadataElementStub.$$$reportNull$$$0(7);
        }
        if (stream == null) {
            MetadataElementStub.$$$reportNull$$$0(8);
        }
        DataInputOutputUtilRt.writeMap((DataOutput)stream, map, arg_0 -> ((StubOutputStream)stream).writeName(arg_0), arg_0 -> ((StubOutputStream)stream).writeName(arg_0));
    }

    protected static void writeIntegerMap(@NotNull Map<String, Integer> map, @NotNull StubOutputStream stream) throws IOException {
        if (map == null) {
            MetadataElementStub.$$$reportNull$$$0(9);
        }
        if (stream == null) {
            MetadataElementStub.$$$reportNull$$$0(10);
        }
        DataInputOutputUtilRt.writeMap((DataOutput)stream, map, arg_0 -> ((StubOutputStream)stream).writeName(arg_0), arg_0 -> ((StubOutputStream)stream).writeVarInt(arg_0));
    }

    @NotNull
    protected static Map<String, String> readStringMap(@NotNull StubInputStream stream) throws IOException {
        if (stream == null) {
            MetadataElementStub.$$$reportNull$$$0(11);
        }
        Map map = DataInputOutputUtilRt.readMap((DataInput)stream, () -> ((StubInputStream)stream).readNameString(), () -> ((StubInputStream)stream).readNameString());
        if (map == null) {
            MetadataElementStub.$$$reportNull$$$0(12);
        }
        return map;
    }

    protected static void writeStringList(@NotNull List<String> list, @NotNull StubOutputStream stream) throws IOException {
        if (list == null) {
            MetadataElementStub.$$$reportNull$$$0(13);
        }
        if (stream == null) {
            MetadataElementStub.$$$reportNull$$$0(14);
        }
        DataInputOutputUtilRt.writeSeq((DataOutput)stream, list, arg_0 -> ((StubOutputStream)stream).writeName(arg_0));
    }

    @NotNull
    protected static List<String> readStringList(@NotNull StubInputStream stream) throws IOException {
        if (stream == null) {
            MetadataElementStub.$$$reportNull$$$0(15);
        }
        List list = DataInputOutputUtilRt.readSeq((DataInput)stream, () -> ((StubInputStream)stream).readNameString());
        if (list == null) {
            MetadataElementStub.$$$reportNull$$$0(16);
        }
        return list;
    }

    @NotNull
    protected static Map<String, Integer> readIntegerMap(@NotNull StubInputStream stream) throws IOException {
        if (stream == null) {
            MetadataElementStub.$$$reportNull$$$0(17);
        }
        Map map = DataInputOutputUtilRt.readMap((DataInput)stream, () -> ((StubInputStream)stream).readNameString(), () -> ((StubInputStream)stream).readVarInt());
        if (map == null) {
            MetadataElementStub.$$$reportNull$$$0(18);
        }
        return map;
    }

    @NotNull
    protected static Stream<Pair<String, JsonObject>> streamDecorators(@NotNull JsonObject sourceClass) {
        JsonArray list;
        if (sourceClass == null) {
            MetadataElementStub.$$$reportNull$$$0(19);
        }
        if ((list = (JsonArray)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)sourceClass.findProperty(DECORATORS), JsonProperty::getValue), JsonArray.class)) == null) {
            Stream<Pair<String, JsonObject>> stream = Stream.empty();
            if (stream == null) {
                MetadataElementStub.$$$reportNull$$$0(20);
            }
            return stream;
        }
        Stream<Pair<String, JsonObject>> stream = list.getValueList().stream().map(v -> (JsonObject)ObjectUtils.tryCast((Object)v, JsonObject.class)).filter(obj -> obj != null && SYMBOL_CALL.equals(MetadataUtils.readStringPropertyValue(obj.findProperty(SYMBOL_TYPE)))).map(obj -> (JsonObject)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)obj.findProperty(EXPRESSION), JsonProperty::getValue), JsonObject.class)).filter(obj -> obj != null && SYMBOL_REFERENCE.equals(MetadataUtils.readStringPropertyValue(obj.findProperty(SYMBOL_TYPE)))).map(obj -> Pair.create((Object)MetadataUtils.readStringPropertyValue(obj.findProperty(REFERENCE_NAME)), (Object)((JsonObject)obj.getParent().getParent()))).filter(pair -> pair.first != null);
        if (stream == null) {
            MetadataElementStub.$$$reportNull$$$0(21);
        }
        return stream;
    }

    @Nullable
    protected static <T extends JsonValue> T getDecoratorInitializer(@NotNull JsonObject decorator, Class<T> initializerClass) {
        JsonArray args;
        if (decorator == null) {
            MetadataElementStub.$$$reportNull$$$0(22);
        }
        return (T)((args = (JsonArray)ObjectUtils.tryCast((Object)ObjectUtils.doIfNotNull((Object)decorator.findProperty(ARGUMENTS), JsonProperty::getValue), JsonArray.class)) != null && args.getValueList().size() == 1 ? (JsonValue)ObjectUtils.tryCast(args.getValueList().get(0), initializerClass) : null);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementType";
                break;
            }
            case 1: 
            case 3: 
            case 8: 
            case 10: 
            case 11: 
            case 14: 
            case 15: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stream";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "p";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataStream";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/lang/metadata/stubs/MetadataElementStub";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sourceClass";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "decorator";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/lang/metadata/stubs/MetadataElementStub";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringMap";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "readStringList";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "readIntegerMap";
                break;
            }
            case 20: 
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "streamDecorators";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "serialize";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "index";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "loadMemberProperty";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "writeString";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "writeStringMap";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "writeIntegerMap";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "readStringMap";
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "writeStringList";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "readStringList";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "readIntegerMap";
                break;
            }
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "streamDecorators";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "getDecoratorInitializer";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 12: 
            case 16: 
            case 18: 
            case 20: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    protected static interface ConstructorFromJsonValue {
        public MetadataElementStub construct(@Nullable String var1, @NotNull JsonValue var2, @Nullable StubElement var3);
    }
}

