/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities;

import com.intellij.lang.javascript.psi.JSImplicitElementProvider;
import com.intellij.lang.javascript.psi.ecma6.ES6Decorator;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptClass;
import com.intellij.lang.javascript.psi.ecma6.TypeScriptFunction;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeList;
import com.intellij.lang.javascript.psi.ecmal4.JSAttributeListOwner;
import com.intellij.lang.javascript.psi.stubs.JSElementIndexingData;
import com.intellij.lang.javascript.psi.stubs.JSImplicitElement;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.ObjectUtils;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import one.util.streamex.StreamEx;
import org.angular2.Angular2DecoratorUtil;
import org.angular2.entities.Angular2Component;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2Directive;
import org.angular2.entities.Angular2DirectiveSelectorPsiElement;
import org.angular2.entities.Angular2Entity;
import org.angular2.entities.Angular2EntityUtils;
import org.angular2.entities.Angular2Module;
import org.angular2.entities.Angular2Pipe;
import org.angular2.entities.ivy.Angular2IvyUtil;
import org.angular2.entities.metadata.Angular2MetadataUtil;
import org.angular2.entities.metadata.psi.Angular2MetadataDirectiveBase;
import org.angular2.entities.metadata.psi.Angular2MetadataEntity;
import org.angular2.entities.metadata.psi.Angular2MetadataModule;
import org.angular2.entities.metadata.psi.Angular2MetadataPipe;
import org.angular2.entities.source.Angular2SourceComponent;
import org.angular2.entities.source.Angular2SourceDirective;
import org.angular2.entities.source.Angular2SourceEntity;
import org.angular2.entities.source.Angular2SourceModule;
import org.angular2.entities.source.Angular2SourcePipe;
import org.angular2.index.Angular2IndexingHandler;
import org.angular2.index.Angular2IvyDirectiveIndex;
import org.angular2.index.Angular2IvyModuleIndex;
import org.angular2.index.Angular2IvyPipeIndex;
import org.angular2.index.Angular2MetadataDirectiveIndex;
import org.angular2.index.Angular2MetadataModuleIndex;
import org.angular2.index.Angular2MetadataPipeIndex;
import org.angular2.index.Angular2SourceDirectiveIndex;
import org.angular2.index.Angular2SourceModuleIndex;
import org.angular2.index.Angular2SourcePipeIndex;
import org.angular2.lang.Angular2LangUtil;
import org.angular2.lang.selector.Angular2DirectiveSimpleSelector;
import org.angularjs.index.AngularIndexUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class Angular2EntitiesProvider {
    static final String TRANSFORM_METHOD = "transform";

    public static Angular2Entity getEntity(@Nullable PsiElement element) {
        if (element == null) {
            return null;
        }
        Angular2SourceEntity result = Angular2EntitiesProvider.getSourceEntity(element);
        if (result != null) {
            return result;
        }
        return Angular2EntitiesProvider.withJsonMetadataFallback(element, Angular2IvyUtil::getIvyEntity, Angular2MetadataUtil::getMetadataEntity);
    }

    @Nullable
    public static <R, E extends PsiElement> R withJsonMetadataFallback(E element, Function<E, R> ivy, Function<TypeScriptClass, R> jsonFallback) {
        R result = ivy.apply(element);
        if (result == null && element instanceof TypeScriptClass && !Angular2IvyUtil.hasIvyMetadata(element) && Angular2LangUtil.isAngular2Context(element)) {
            return jsonFallback.apply((TypeScriptClass)element);
        }
        return result;
    }

    @Nullable
    public static Angular2Declaration getDeclaration(@Nullable PsiElement element) {
        return (Angular2Declaration)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getEntity(element), Angular2Declaration.class);
    }

    @Nullable
    public static Angular2Component getComponent(@Nullable PsiElement element) {
        return (Angular2Component)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getEntity(element), Angular2Component.class);
    }

    @Nullable
    public static Angular2Directive getDirective(@Nullable PsiElement element) {
        return (Angular2Directive)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getEntity(element), Angular2Directive.class);
    }

    @Nullable
    public static Angular2Pipe getPipe(@Nullable PsiElement element) {
        if (element instanceof TypeScriptFunction && TRANSFORM_METHOD.equals(((TypeScriptFunction)element).getName()) && element.getContext() instanceof TypeScriptClass) {
            element = element.getContext();
        }
        return (Angular2Pipe)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getEntity(element), Angular2Pipe.class);
    }

    @Nullable
    public static Angular2Module getModule(@Nullable PsiElement element) {
        return (Angular2Module)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getEntity(element), Angular2Module.class);
    }

    @NotNull
    public static List<Angular2Directive> findElementDirectivesCandidates(@NotNull Project project, @NotNull String elementName) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(0);
        }
        if (elementName == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(1);
        }
        return Angular2EntitiesProvider.findDirectivesCandidates(project, Angular2EntityUtils.getElementDirectiveIndexName(elementName));
    }

    @NotNull
    public static List<Angular2Directive> findAttributeDirectivesCandidates(@NotNull Project project, @NotNull String attributeName) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(2);
        }
        if (attributeName == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(3);
        }
        return Angular2EntitiesProvider.findDirectivesCandidates(project, Angular2EntityUtils.getAttributeDirectiveIndexName(attributeName));
    }

    @NotNull
    public static List<Angular2Pipe> findPipes(@NotNull Project project, @NotNull String name) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(4);
        }
        if (name == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(5);
        }
        SmartList result = new SmartList();
        AngularIndexUtil.multiResolve(project, Angular2SourcePipeIndex.KEY, name, (Processor<? super JSImplicitElement>)((Processor)arg_0 -> Angular2EntitiesProvider.lambda$findPipes$0((List)result, arg_0)));
        Angular2EntitiesProvider.processIvyEntities(project, name, Angular2IvyPipeIndex.KEY, Angular2Pipe.class, ((List)result)::add);
        Angular2EntitiesProvider.processMetadataEntities(project, name, Angular2MetadataPipe.class, Angular2MetadataPipeIndex.KEY, ((List)result)::add);
        SmartList smartList = result;
        if (smartList == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(6);
        }
        return smartList;
    }

    @NotNull
    public static List<Angular2Directive> findDirectives(@NotNull Angular2DirectiveSelectorPsiElement selector) {
        if (selector == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(7);
        }
        if (selector.isElementSelector()) {
            return Angular2EntitiesProvider.findElementDirectivesCandidates(selector.getProject(), selector.getName());
        }
        if (selector.isAttributeSelector()) {
            return Angular2EntitiesProvider.findAttributeDirectivesCandidates(selector.getProject(), selector.getName());
        }
        List<Angular2Directive> list = Collections.emptyList();
        if (list == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(8);
        }
        return list;
    }

    @Nullable
    public static Angular2Component findComponent(@NotNull Angular2DirectiveSelectorPsiElement selector) {
        if (selector == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(9);
        }
        return (Angular2Component)ContainerUtil.find(Angular2EntitiesProvider.findDirectives(selector), Angular2Directive::isComponent);
    }

    @NotNull
    public static Map<String, List<Angular2Directive>> getAllElementDirectives(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(10);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)StreamEx.of(Angular2EntitiesProvider.findDirectivesCandidates(project, Angular2EntityUtils.getAnyElementDirectiveIndexName())).flatCollection(directive -> {
            SmartList result = new SmartList();
            Consumer<Angular2DirectiveSimpleSelector> selectorProcessor = arg_0 -> Angular2EntitiesProvider.lambda$getAllElementDirectives$1((List)result, directive, arg_0);
            for (Angular2DirectiveSimpleSelector sel : directive.getSelector().getSimpleSelectors()) {
                selectorProcessor.accept(sel);
                sel.getNotSelectors().forEach(selectorProcessor);
            }
            return result;
        }).groupingBy(p -> (String)p.first, Collectors.mapping(p -> (Angular2Directive)p.second, Collectors.toList())), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (map == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(11);
        }
        return map;
    }

    @NotNull
    public static Map<String, List<Angular2Pipe>> getAllPipes(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(12);
        }
        Map map = (Map)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> CachedValueProvider.Result.create((Object)((Map)((StreamEx)StreamEx.of(AngularIndexUtil.getAllKeys(Angular2SourcePipeIndex.KEY, project)).append(AngularIndexUtil.getAllKeys(Angular2MetadataPipeIndex.KEY, project)).append(AngularIndexUtil.getAllKeys(Angular2IvyPipeIndex.KEY, project)).distinct()).collect(Collectors.toMap(Function.identity(), name -> Angular2EntitiesProvider.findPipes(project, name)))), (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT}));
        if (map == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(13);
        }
        return map;
    }

    public static boolean isPipeTransformMethod(@Nullable PsiElement element) {
        return element instanceof TypeScriptFunction && TRANSFORM_METHOD.equals(((TypeScriptFunction)element).getName()) && Angular2EntitiesProvider.getPipe(element) != null;
    }

    public static MultiMap<Angular2Declaration, Angular2Module> getExportedDeclarationToModuleMap(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(14);
        }
        return (MultiMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            MultiMap result = new MultiMap();
            Angular2EntitiesProvider.getAllModules(project).forEach(module -> module.getAllExportedDeclarations().forEach(decl -> result.putValue(decl, module)));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static MultiMap<Angular2Declaration, Angular2Module> getDeclarationToModuleMap(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(15);
        }
        return (MultiMap)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            MultiMap result = new MultiMap();
            Angular2EntitiesProvider.getAllModules(project).forEach(module -> module.getDeclarations().forEach(decl -> result.putValue(decl, module)));
            return CachedValueProvider.Result.create((Object)result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static List<Angular2Module> getAllModules(@NotNull Project project) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(16);
        }
        return (List)CachedValuesManager.getManager((Project)project).getCachedValue((UserDataHolder)project, () -> {
            ArrayList result = new ArrayList();
            StubIndex.getInstance().processElements(Angular2SourceModuleIndex.KEY, (Object)"ngModule", project, GlobalSearchScope.allScope((Project)project), JSImplicitElementProvider.class, module -> {
                if (module.isValid()) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)((Angular2Module)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getSourceEntity((PsiElement)module), Angular2Module.class)));
                }
                return true;
            });
            Angular2EntitiesProvider.processIvyEntities(project, "ngModule", Angular2IvyModuleIndex.KEY, Angular2Module.class, result::add);
            Angular2EntitiesProvider.processMetadataEntities(project, "ngModule", Angular2MetadataModule.class, Angular2MetadataModuleIndex.KEY, result::add);
            return CachedValueProvider.Result.create(result, (Object[])new Object[]{PsiModificationTracker.MODIFICATION_COUNT});
        });
    }

    public static Angular2SourceEntity getSourceEntity(@NotNull PsiElement element) {
        if (element == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(17);
        }
        if (element instanceof JSImplicitElement) {
            if (!Angular2EntitiesProvider.isEntityImplicitElement((JSImplicitElement)element)) {
                return null;
            }
            element = element.getContext();
        }
        if (element instanceof TypeScriptClass ? (element = Angular2DecoratorUtil.findDecorator((JSAttributeListOwner)((TypeScriptClass)element), "Pipe", "Component", "NgModule", "Directive")) == null : !(element instanceof ES6Decorator) || !Angular2DecoratorUtil.isAngularEntityDecorator((ES6Decorator)element, "Pipe", "Component", "NgModule", "Directive")) {
            return null;
        }
        ES6Decorator dec = (ES6Decorator)element;
        return (Angular2SourceEntity)CachedValuesManager.getCachedValue((PsiElement)dec, () -> {
            JSImplicitElement entityElement = null;
            if (dec.getIndexingData() != null) {
                entityElement = (JSImplicitElement)ContainerUtil.find((Iterable)((Iterable)ObjectUtils.notNull((Object)dec.getIndexingData().getImplicitElements(), Collections::emptyList)), Angular2EntitiesProvider::isEntityImplicitElement);
            }
            String decoratorName = dec.getDecoratorName();
            Angular2SourceEntity entity = null;
            if (entityElement != null && decoratorName != null) {
                if (decoratorName.equals("Component")) {
                    entity = new Angular2SourceComponent(dec, entityElement);
                } else if (decoratorName.equals("Directive")) {
                    entity = new Angular2SourceDirective(dec, entityElement);
                } else if (decoratorName.equals("NgModule")) {
                    entity = new Angular2SourceModule(dec, entityElement);
                } else if (decoratorName.equals("Pipe")) {
                    entity = new Angular2SourcePipe(dec, entityElement);
                }
            }
            return CachedValueProvider.Result.create(entity, (Object[])new Object[]{dec});
        });
    }

    public static boolean isDeclaredClass(@NotNull TypeScriptClass typeScriptClass) {
        if (typeScriptClass == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(18);
        }
        return Objects.requireNonNull(typeScriptClass.getAttributeList()).hasModifier(JSAttributeList.ModifierType.DECLARE);
    }

    private static boolean isEntityImplicitElement(JSImplicitElement element) {
        return Angular2IndexingHandler.isDirective(element) || Angular2IndexingHandler.isPipe(element) || Angular2IndexingHandler.isModule(element);
    }

    @NotNull
    private static List<Angular2Directive> findDirectivesCandidates(@NotNull Project project, @NotNull String indexLookupName) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(19);
        }
        if (indexLookupName == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(20);
        }
        ArrayList<Angular2Directive> result = new ArrayList<Angular2Directive>();
        StubIndex.getInstance().processElements(Angular2SourceDirectiveIndex.KEY, (Object)indexLookupName, project, GlobalSearchScope.allScope((Project)project), JSImplicitElementProvider.class, provider -> {
            Collection elements;
            JSElementIndexingData indexingData = provider.getIndexingData();
            if (indexingData != null && (elements = indexingData.getImplicitElements()) != null) {
                for (JSImplicitElement element : elements) {
                    Angular2Directive directive;
                    if (!element.isValid() || (directive = (Angular2Directive)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getSourceEntity((PsiElement)element), Angular2Directive.class)) == null) continue;
                    result.add(directive);
                    return true;
                }
            }
            return true;
        });
        Angular2EntitiesProvider.processIvyEntities(project, indexLookupName, Angular2IvyDirectiveIndex.KEY, Angular2Directive.class, result::add);
        Angular2EntitiesProvider.processMetadataEntities(project, indexLookupName, Angular2MetadataDirectiveBase.class, Angular2MetadataDirectiveIndex.KEY, result::add);
        ArrayList<Angular2Directive> arrayList = result;
        if (arrayList == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(21);
        }
        return arrayList;
    }

    private static <T extends Angular2MetadataEntity<?>> void processMetadataEntities(@NotNull Project project, @NotNull String name, @NotNull Class<T> entityClass, @NotNull StubIndexKey<String, T> key, @NotNull Consumer<? super T> consumer) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(22);
        }
        if (name == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(23);
        }
        if (entityClass == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(24);
        }
        if (key == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(25);
        }
        if (consumer == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(26);
        }
        StubIndex.getInstance().processElements(key, (Object)name, project, GlobalSearchScope.allScope((Project)project), entityClass, el -> {
            if (el.isValid() && !Angular2IvyUtil.hasIvyMetadata((PsiElement)el)) {
                consumer.accept(el);
            }
            return true;
        });
    }

    private static <T extends Angular2Entity> void processIvyEntities(@NotNull Project project, @NotNull String name, @NotNull StubIndexKey<String, TypeScriptClass> key, @NotNull Class<T> entityClass, @NotNull Consumer<? super T> consumer) {
        if (project == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(27);
        }
        if (name == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(28);
        }
        if (key == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(29);
        }
        if (entityClass == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(30);
        }
        if (consumer == null) {
            Angular2EntitiesProvider.$$$reportNull$$$0(31);
        }
        StubIndex.getInstance().processElements(key, (Object)name, project, GlobalSearchScope.allScope((Project)project), TypeScriptClass.class, el -> {
            Angular2Entity entity;
            if (el.isValid() && (entity = (Angular2Entity)ObjectUtils.tryCast(Angular2IvyUtil.getIvyEntity((PsiElement)el), (Class)entityClass)) != null) {
                consumer.accept(entity);
            }
            return true;
        });
    }

    private static /* synthetic */ void lambda$getAllElementDirectives$1(List result, Angular2Directive directive, Angular2DirectiveSimpleSelector sel) {
        String elementName = sel.getElementName();
        if (!StringUtil.isEmpty((String)elementName) && !"*".equals(elementName)) {
            result.add(Pair.pair((Object)elementName, (Object)directive));
        }
    }

    private static /* synthetic */ boolean lambda$findPipes$0(List result, JSImplicitElement pipe) {
        ContainerUtil.addIfNotNull((Collection)result, (Object)((Angular2Pipe)ObjectUtils.tryCast((Object)Angular2EntitiesProvider.getSourceEntity((PsiElement)pipe), Angular2Pipe.class)));
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 21: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "elementName";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "attributeName";
                break;
            }
            case 5: 
            case 23: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/entities/Angular2EntitiesProvider";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selector";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "typeScriptClass";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "indexLookupName";
                break;
            }
            case 24: 
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "entityClass";
                break;
            }
            case 25: 
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 26: 
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "consumer";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/entities/Angular2EntitiesProvider";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findPipes";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectives";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllElementDirectives";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getAllPipes";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "findDirectivesCandidates";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "findElementDirectivesCandidates";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findAttributeDirectivesCandidates";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findPipes";
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 21: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "findDirectives";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "findComponent";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getAllElementDirectives";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getAllPipes";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "getExportedDeclarationToModuleMap";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getDeclarationToModuleMap";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "getAllModules";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "getSourceEntity";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "isDeclaredClass";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "findDirectivesCandidates";
                break;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "processMetadataEntities";
                break;
            }
            case 27: 
            case 28: 
            case 29: 
            case 30: 
            case 31: {
                objectArray = objectArray;
                objectArray[2] = "processIvyEntities";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

