/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.entities;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import org.angular2.entities.Angular2DirectiveProperty;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class Angular2DirectiveProperties {
    private final Collection<? extends Angular2DirectiveProperty> myInputs;
    private final Collection<? extends Angular2DirectiveProperty> myOutputs;
    private final NotNullLazyValue<List<Pair<Angular2DirectiveProperty, Angular2DirectiveProperty>>> myInOuts = NotNullLazyValue.createValue(() -> {
        @NonNls String OUTPUT_CHANGE_SUFFIX = "Change";
        Collection<? extends Angular2DirectiveProperty> outputs = this.getOutputs();
        Collection<? extends Angular2DirectiveProperty> inputs = this.getInputs();
        if (inputs.isEmpty() || outputs.isEmpty()) {
            return Collections.emptyList();
        }
        HashMap<String, Angular2DirectiveProperty> inputMap = new HashMap<String, Angular2DirectiveProperty>();
        for (Angular2DirectiveProperty angular2DirectiveProperty : inputs) {
            inputMap.putIfAbsent(angular2DirectiveProperty.getName(), angular2DirectiveProperty);
        }
        ArrayList<Pair> result = new ArrayList<Pair>();
        for (Angular2DirectiveProperty angular2DirectiveProperty : outputs) {
            Angular2DirectiveProperty input;
            String name = angular2DirectiveProperty.getName();
            if (!angular2DirectiveProperty.getName().endsWith("Change") || (input = (Angular2DirectiveProperty)inputMap.get(name.substring(0, name.length() - "Change".length()))) == null) continue;
            result.add(Pair.create((Object)input, (Object)angular2DirectiveProperty));
        }
        return result;
    });

    public Angular2DirectiveProperties(Collection<? extends Angular2DirectiveProperty> inputs, Collection<? extends Angular2DirectiveProperty> outputs) {
        this.myInputs = Collections.unmodifiableCollection(inputs);
        this.myOutputs = Collections.unmodifiableCollection(outputs);
    }

    @NotNull
    public Collection<? extends Angular2DirectiveProperty> getInputs() {
        Collection<? extends Angular2DirectiveProperty> collection = this.myInputs;
        if (collection == null) {
            Angular2DirectiveProperties.$$$reportNull$$$0(0);
        }
        return collection;
    }

    @NotNull
    public Collection<? extends Angular2DirectiveProperty> getOutputs() {
        Collection<? extends Angular2DirectiveProperty> collection = this.myOutputs;
        if (collection == null) {
            Angular2DirectiveProperties.$$$reportNull$$$0(1);
        }
        return collection;
    }

    public List<Pair<Angular2DirectiveProperty, Angular2DirectiveProperty>> getInOuts() {
        return (List)this.myInOuts.getValue();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[2];
        objectArray2[0] = "org/angular2/entities/Angular2DirectiveProperties";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getInputs";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getOutputs";
                break;
            }
        }
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
    }
}

