/*
 * Decompiled with CFR 0.152.
 */
package org.angular2.codeInsight.tags;

import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.psi.PsiElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.function.Function;
import org.angular2.codeInsight.Angular2DeclarationsScope;
import org.angular2.entities.Angular2Declaration;
import org.angular2.entities.Angular2Directive;
import org.jetbrains.annotations.NotNull;

public final class Angular2XmlElementSourcesResolver {
    private final XmlTag myScope;
    private final Collection<?> mySources;
    private final NotNullLazyValue<Collection<PsiElement>> myDeclarations;

    public Angular2XmlElementSourcesResolver(@NotNull XmlTag scope, @NotNull Collection<?> sources, @NotNull Function<Angular2Directive, Collection<? extends PsiElement>> getProperties, @NotNull Function<Angular2Directive, Collection<? extends PsiElement>> getSelectors) {
        if (scope == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(0);
        }
        if (sources == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(1);
        }
        if (getProperties == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(2);
        }
        if (getSelectors == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(3);
        }
        this.myScope = scope;
        this.mySources = new ArrayList(sources);
        this.myDeclarations = NotNullLazyValue.atomicLazy(() -> this.buildDeclarations(getProperties, getSelectors));
    }

    @NotNull
    public XmlTag getScope() {
        XmlTag xmlTag = this.myScope;
        if (xmlTag == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(4);
        }
        return xmlTag;
    }

    @NotNull
    public Collection<?> getSources() {
        Collection<?> collection = this.mySources;
        if (collection == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(5);
        }
        return collection;
    }

    @NotNull
    public List<Angular2Directive> getSourceDirectives() {
        List list = ContainerUtil.filterIsInstance(this.mySources, Angular2Directive.class);
        if (list == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(6);
        }
        return list;
    }

    @NotNull
    public Collection<PsiElement> getDeclarations() {
        Collection collection = (Collection)this.myDeclarations.getValue();
        if (collection == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(7);
        }
        return collection;
    }

    @NotNull
    public Collection<PsiElement> buildDeclarations(@NotNull Function<Angular2Directive, Collection<? extends PsiElement>> getProperties, @NotNull Function<Angular2Directive, Collection<? extends PsiElement>> getSelectors) {
        if (getProperties == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(8);
        }
        if (getSelectors == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(9);
        }
        HashSet<PsiElement> result = new HashSet<PsiElement>(this.getNonDirectiveElements());
        MultiMap<Angular2DeclarationsScope.DeclarationProximity, Angular2Directive> directivesByProximity = this.getDeclarationsByProximity();
        directivesByProximity.remove((Object)Angular2DeclarationsScope.DeclarationProximity.NOT_REACHABLE);
        MultiMap<Angular2DeclarationsScope.DeclarationProximity, ? extends PsiElement> fieldsByProximity = Angular2XmlElementSourcesResolver.mapValues(directivesByProximity, getProperties);
        if (!fieldsByProximity.get((Object)Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE).isEmpty()) {
            result.addAll(fieldsByProximity.get((Object)Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE));
            HashSet<PsiElement> hashSet = result;
            if (hashSet == null) {
                Angular2XmlElementSourcesResolver.$$$reportNull$$$0(10);
            }
            return hashSet;
        }
        MultiMap<Angular2DeclarationsScope.DeclarationProximity, ? extends PsiElement> selectorsByProximity = Angular2XmlElementSourcesResolver.mapValues(directivesByProximity, getSelectors);
        if (!selectorsByProximity.get((Object)Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE).isEmpty()) {
            result.addAll(selectorsByProximity.get((Object)Angular2DeclarationsScope.DeclarationProximity.IN_SCOPE));
            HashSet<PsiElement> hashSet = result;
            if (hashSet == null) {
                Angular2XmlElementSourcesResolver.$$$reportNull$$$0(11);
            }
            return hashSet;
        }
        if (!fieldsByProximity.isEmpty()) {
            result.addAll(fieldsByProximity.values());
        } else {
            result.addAll(selectorsByProximity.values());
        }
        HashSet<PsiElement> hashSet = result;
        if (hashSet == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(12);
        }
        return hashSet;
    }

    @NotNull
    private List<PsiElement> getNonDirectiveElements() {
        ArrayList<PsiElement> result = new ArrayList<PsiElement>(this.mySources.size());
        for (Object source : this.mySources) {
            if (!(source instanceof PsiElement) || source instanceof Angular2Declaration) continue;
            result.add((PsiElement)source);
        }
        ArrayList<PsiElement> arrayList = result;
        if (arrayList == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(13);
        }
        return arrayList;
    }

    @NotNull
    private MultiMap<Angular2DeclarationsScope.DeclarationProximity, Angular2Directive> getDeclarationsByProximity() {
        MultiMap result = new MultiMap();
        Angular2DeclarationsScope scope = new Angular2DeclarationsScope((PsiElement)this.myScope);
        for (Object source : this.mySources) {
            if (!(source instanceof Angular2Directive)) continue;
            Angular2Directive directive = (Angular2Directive)source;
            result.putValue((Object)scope.getDeclarationProximity(directive), (Object)directive);
        }
        MultiMap multiMap = result;
        if (multiMap == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(14);
        }
        return multiMap;
    }

    private static <K, V, T> MultiMap<K, T> mapValues(@NotNull MultiMap<K, ? extends V> source, @NotNull Function<? super V, Collection<? extends T>> mapper) {
        if (source == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(15);
        }
        if (mapper == null) {
            Angular2XmlElementSourcesResolver.$$$reportNull$$$0(16);
        }
        MultiMap result = MultiMap.createSet();
        source.entrySet().forEach(entry -> ((Collection)entry.getValue()).forEach(value -> result.putValues(entry.getKey(), (Collection)mapper.apply((Object)value))));
        return result;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "scope";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sources";
                break;
            }
            case 2: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getProperties";
                break;
            }
            case 3: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "getSelectors";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/angular2/codeInsight/tags/Angular2XmlElementSourcesResolver";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "source";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "mapper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/angular2/codeInsight/tags/Angular2XmlElementSourcesResolver";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getScope";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getSources";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getSourceDirectives";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarations";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "buildDeclarations";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonDirectiveElements";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getDeclarationsByProximity";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "buildDeclarations";
                break;
            }
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "mapValues";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

