/*
 * Decompiled with CFR 0.152.
 */
package net.vektah.codeglance.render;

import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.psi.tree.IElementType;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import net.vektah.codeglance.config.Config;
import net.vektah.codeglance.render.CharacterWeightKt;
import net.vektah.codeglance.render.Folds;
import net.vektah.codeglance.render.UtillKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0010\r\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 02\u00020\u0001:\u000201B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J \u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002J\u000e\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020\u0006J(\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0002J(\u0010&\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010$\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u0006H\u0002J(\u0010'\u001a\u00020!2\u0006\u0010\"\u001a\u00020\u00062\u0006\u0010#\u001a\u00020\u00062\u0006\u0010%\u001a\u00020\u00062\u0006\u0010(\u001a\u00020)H\u0002J&\u0010*\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0006\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010-\u001a\u00020.J\u0016\u0010/\u001a\u00020!2\u0006\u0010+\u001a\u00020,2\u0006\u0010-\u001a\u00020.R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0005\u001a\u00020\u0006X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001c\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0016\u0010\u0011\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lnet/vektah/codeglance/render/Minimap;", "", "config", "Lnet/vektah/codeglance/config/Config;", "(Lnet/vektah/codeglance/config/Config;)V", "height", "", "getHeight", "()I", "setHeight", "(I)V", "img", "Ljava/awt/image/BufferedImage;", "getImg", "()Ljava/awt/image/BufferedImage;", "setImg", "(Ljava/awt/image/BufferedImage;)V", "line_endings", "Ljava/util/ArrayList;", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "getColorForElementType", "element", "Lcom/intellij/psi/tree/IElementType;", "hl", "Lcom/intellij/openapi/fileTypes/SyntaxHighlighter;", "colorScheme", "Lcom/intellij/openapi/editor/colors/EditorColorsScheme;", "getLine", "Lnet/vektah/codeglance/render/Minimap$LineInfo;", "i", "renderAccurate", "", "x", "y", "char", "color", "renderClean", "setPixel", "alpha", "", "update", "text", "", "folds", "Lnet/vektah/codeglance/render/Folds;", "updateDimensions", "Companion", "LineInfo", "CodeGlance_main"})
public final class Minimap {
    @Nullable
    private BufferedImage img;
    private int height;
    private final Logger logger;
    private ArrayList<Integer> line_endings;
    private final Config config;
    private static final AlphaComposite CLEAR;
    private static final int[] unpackedColor;
    private static final LineInfo NO_LINES;
    public static final Companion Companion;

    @Nullable
    public final BufferedImage getImg() {
        return this.img;
    }

    public final void setImg(@Nullable BufferedImage bufferedImage) {
        this.img = bufferedImage;
    }

    public final int getHeight() {
        return this.height;
    }

    public final void setHeight(int n) {
        this.height = n;
    }

    public final void updateDimensions(@NotNull CharSequence text, @NotNull Folds folds) {
        block14: {
            block13: {
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull((Object)folds, (String)"folds");
                int line_length = 0;
                int longest_line = 1;
                int lines = 1;
                int last = 32;
                ArrayList<Integer> line_endings = new ArrayList<Integer>();
                line_endings.add(-1);
                int i = 0;
                int len = text.length();
                while (i < len) {
                    if (folds.isFolded(i)) {
                        ++i;
                        continue;
                    }
                    char ch = text.charAt(i);
                    if (ch == '\n' || ch == '\r' && last != 10) {
                        line_endings.add(i);
                        ++lines;
                        if (line_length > longest_line) {
                            longest_line = line_length;
                        }
                        line_length = 0;
                    } else {
                        line_length = ch == '\t' ? (line_length += 4) : ++line_length;
                    }
                    last = ch;
                    ++i;
                }
                if ((Integer)line_endings.get(line_endings.size() - 1) != Integer.valueOf(text.length() - 1)) {
                    line_endings.add(text.length() - 1);
                }
                this.line_endings = line_endings;
                this.height = (lines + 1) * this.config.getPixelsPerLine();
                if (this.img == null) break block13;
                BufferedImage bufferedImage = this.img;
                if (bufferedImage == null) {
                    Intrinsics.throwNpe();
                }
                if (bufferedImage.getHeight() < this.height) break block13;
                BufferedImage bufferedImage2 = this.img;
                if (bufferedImage2 == null) {
                    Intrinsics.throwNpe();
                }
                if (bufferedImage2.getWidth() >= this.config.getWidth()) break block14;
            }
            if (this.img != null) {
                BufferedImage bufferedImage = this.img;
                if (bufferedImage == null) {
                    Intrinsics.throwNpe();
                }
                bufferedImage.flush();
            }
            this.img = new BufferedImage(this.config.getWidth(), this.height + 100 * this.config.getPixelsPerLine(), 6);
            this.logger.debug("Created new image");
        }
    }

    @NotNull
    public final LineInfo getLine(int i) {
        int index_mid;
        if (this.line_endings == null) {
            return Minimap.Companion.getNO_LINES();
        }
        ArrayList<Integer> arrayList = this.line_endings;
        if (arrayList == null) {
            Intrinsics.throwNpe();
        }
        if (arrayList.size() == 0) {
            return Minimap.Companion.getNO_LINES();
        }
        ArrayList<Integer> arrayList2 = this.line_endings;
        if (arrayList2 == null) {
            Intrinsics.throwNpe();
        }
        ArrayList<Integer> arrayList3 = this.line_endings;
        if (arrayList3 == null) {
            Intrinsics.throwNpe();
        }
        Integer lines = arrayList2.get(arrayList3.size() - 1);
        ArrayList<Integer> arrayList4 = this.line_endings;
        if (arrayList4 == null) {
            Intrinsics.throwNpe();
        }
        if (arrayList4.size() == 0) {
            return Minimap.Companion.getNO_LINES();
        }
        ArrayList<Integer> arrayList5 = this.line_endings;
        if (arrayList5 == null) {
            Intrinsics.throwNpe();
        }
        if (arrayList5.size() == 1) {
            return Minimap.Companion.getNO_LINES();
        }
        ArrayList<Integer> arrayList6 = this.line_endings;
        if (arrayList6 == null) {
            Intrinsics.throwNpe();
        }
        if (arrayList6.size() == 2) {
            ArrayList<Integer> arrayList7 = this.line_endings;
            if (arrayList7 == null) {
                Intrinsics.throwNpe();
            }
            int n = ((Number)arrayList7.get(0)).intValue() + 1;
            ArrayList<Integer> arrayList8 = this.line_endings;
            if (arrayList8 == null) {
                Intrinsics.throwNpe();
            }
            return new LineInfo(1, n, ((Number)arrayList8.get(1)).intValue());
        }
        int index_min = 0;
        ArrayList<Integer> arrayList9 = this.line_endings;
        if (arrayList9 == null) {
            Intrinsics.throwNpe();
        }
        int index_max = arrayList9.size() - 1;
        int clampedI = UtillKt.clamp(i, 0, lines);
        while (true) {
            index_mid = (int)Math.floor((float)(index_min + index_max) / 2.0f);
            ArrayList<Integer> arrayList10 = this.line_endings;
            if (arrayList10 == null) {
                Intrinsics.throwNpe();
            }
            Integer n = arrayList10.get(index_mid);
            Intrinsics.checkExpressionValueIsNotNull((Object)n, (String)"line_endings!![index_mid]");
            int value = ((Number)n).intValue();
            if (value < clampedI) {
                ArrayList<Integer> arrayList11 = this.line_endings;
                if (arrayList11 == null) {
                    Intrinsics.throwNpe();
                }
                if (Intrinsics.compare((int)clampedI, (int)((Number)arrayList11.get(index_mid + 1)).intValue()) < 0) {
                    ArrayList<Integer> arrayList12 = this.line_endings;
                    if (arrayList12 == null) {
                        Intrinsics.throwNpe();
                    }
                    return new LineInfo(index_mid + 1, value + 1, ((Number)arrayList12.get(index_mid + 1)).intValue());
                }
                index_min = index_mid + 1;
                continue;
            }
            if (clampedI >= value) break;
            ArrayList<Integer> arrayList13 = this.line_endings;
            if (arrayList13 == null) {
                Intrinsics.throwNpe();
            }
            if (Intrinsics.compare((int)((Number)arrayList13.get(index_mid - 1)).intValue(), (int)clampedI) < 0) {
                ArrayList<Integer> arrayList14 = this.line_endings;
                if (arrayList14 == null) {
                    Intrinsics.throwNpe();
                }
                return new LineInfo(index_mid, ((Number)arrayList14.get(index_mid - 1)).intValue() + 1, value);
            }
            index_max = index_mid - 1;
        }
        ArrayList<Integer> arrayList15 = this.line_endings;
        if (arrayList15 == null) {
            Intrinsics.throwNpe();
        }
        return new LineInfo(index_mid, ((Number)arrayList15.get(index_mid - 1)).intValue() + 1, clampedI);
    }

    private final int getColorForElementType(IElementType element, SyntaxHighlighter hl, EditorColorsScheme colorScheme) {
        int color = colorScheme.getDefaultForeground().getRGB();
        TextAttributesKey[] attributes = hl.getTokenHighlights(element);
        for (int i = 0; i < attributes.length; ++i) {
            Color tmp;
            TextAttributesKey attribute = attributes[i];
            TextAttributes attr = colorScheme.getAttributes(attribute);
            if (attr == null || (tmp = attr.getForegroundColor()) == null) continue;
            color = tmp.getRGB();
        }
        return color;
    }

    public final void update(@NotNull CharSequence text, @NotNull EditorColorsScheme colorScheme, @NotNull SyntaxHighlighter hl, @NotNull Folds folds) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)colorScheme, (String)"colorScheme");
        Intrinsics.checkParameterIsNotNull((Object)hl, (String)"hl");
        Intrinsics.checkParameterIsNotNull((Object)folds, (String)"folds");
        this.logger.debug("Updating file image.");
        this.updateDimensions(text, folds);
        Lexer lexer = hl.getHighlightingLexer();
        BufferedImage bufferedImage = this.img;
        if (bufferedImage == null) {
            Intrinsics.throwNpe();
        }
        Graphics graphics = bufferedImage.getGraphics();
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g = (Graphics2D)graphics;
        g.setComposite(Minimap.Companion.getCLEAR());
        BufferedImage bufferedImage2 = this.img;
        if (bufferedImage2 == null) {
            Intrinsics.throwNpe();
        }
        int n = bufferedImage2.getWidth();
        BufferedImage bufferedImage3 = this.img;
        if (bufferedImage3 == null) {
            Intrinsics.throwNpe();
        }
        g.fillRect(0, 0, n, bufferedImage3.getHeight());
        lexer.start(text);
        IElementType tokenType = lexer.getTokenType();
        while (tokenType != null) {
            int i;
            int n2;
            int start = lexer.getTokenStart();
            LineInfo startLine = this.getLine(start);
            int y = startLine.getNumber() * this.config.getPixelsPerLine();
            int color = this.getColorForElementType(tokenType, hl, colorScheme);
            int x = 0;
            int n3 = startLine.getBegin();
            if (n3 <= (n2 = start - 1)) {
                while (true) {
                    if (!folds.isFolded(i)) {
                        x = text.charAt(i) == '\t' ? (x += 4) : ++x;
                        if (x > this.config.getWidth()) break;
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            if ((i = start) <= (n2 = lexer.getTokenEnd() - 1)) {
                while (true) {
                    if (!folds.isFolded(i)) {
                        if (i >= text.length()) {
                            return;
                        }
                        char ch = text.charAt(i);
                        if (ch == '\n') {
                            x = 0;
                            y += this.config.getPixelsPerLine();
                        } else {
                            x = ch == '\t' ? (x += 4) : ++x;
                        }
                        if (0 <= x) {
                            BufferedImage bufferedImage4 = this.img;
                            if (bufferedImage4 == null) {
                                Intrinsics.throwNpe();
                            }
                            if (x < bufferedImage4.getWidth() && 0 <= y) {
                                int n4 = y + this.config.getPixelsPerLine();
                                BufferedImage bufferedImage5 = this.img;
                                if (bufferedImage5 == null) {
                                    Intrinsics.throwNpe();
                                }
                                if (n4 < bufferedImage5.getHeight()) {
                                    if (this.config.getClean()) {
                                        this.renderClean(x, y, text.charAt(i), color);
                                    } else {
                                        this.renderAccurate(x, y, text.charAt(i), color);
                                    }
                                }
                            }
                        }
                    }
                    if (i == n2) break;
                    ++i;
                }
            }
            lexer.advance();
            tokenType = lexer.getTokenType();
        }
    }

    private final void renderClean(int x, int y, int n, int color) {
        float weight;
        int n2 = n;
        int n3 = n2;
        float f = 0 <= n3 && n3 <= 32 ? 0.0f : (weight = 33 <= (n3 = n2) && n3 <= 126 ? 0.8f : 0.4f);
        if (weight == 0.0f) {
            return;
        }
        switch (this.config.getPixelsPerLine()) {
            case 1: {
                this.setPixel(x, y + 1, color, weight * 0.6f);
                break;
            }
            case 2: {
                this.setPixel(x, y, color, weight * 0.3f);
                this.setPixel(x, y + 1, color, weight * 0.6f);
                break;
            }
            case 3: {
                this.setPixel(x, y, color, weight * 0.1f);
                this.setPixel(x, y + 1, color, weight * 0.6f);
                this.setPixel(x, y + 2, color, weight * 0.6f);
                break;
            }
            case 4: {
                this.setPixel(x, y + 1, color, weight * 0.6f);
                this.setPixel(x, y + 2, color, weight * 0.6f);
                this.setPixel(x, y + 3, color, weight * 0.6f);
            }
        }
    }

    private final void renderAccurate(int x, int y, int n, int color) {
        float topWeight = CharacterWeightKt.GetTopWeight(n);
        float bottomWeight = CharacterWeightKt.GetBottomWeight(n);
        if (topWeight == 0.0f && bottomWeight == 0.0f) {
            return;
        }
        switch (this.config.getPixelsPerLine()) {
            case 1: {
                this.setPixel(x, y + 1, color, (float)((double)(topWeight + bottomWeight) / 2.0));
                break;
            }
            case 2: {
                this.setPixel(x, y, color, topWeight * 0.5f);
                this.setPixel(x, y + 1, color, bottomWeight);
                break;
            }
            case 3: {
                this.setPixel(x, y, color, topWeight * 0.3f);
                this.setPixel(x, y + 1, color, (float)((double)(topWeight + bottomWeight) / 2.0));
                this.setPixel(x, y + 2, color, bottomWeight * 0.7f);
                break;
            }
            case 4: {
                this.setPixel(x, y + 1, color, topWeight);
                this.setPixel(x, y + 2, color, (float)((double)(topWeight + bottomWeight) / 2.0));
                this.setPixel(x, y + 3, color, bottomWeight);
            }
        }
    }

    private final void setPixel(int x, int y, int color, float alpha) {
        float a = alpha;
        if (a > 1.0f) {
            a = color;
        }
        if (a < 0.0f) {
            a = 0.0f;
        }
        ((Companion)Minimap.Companion).getUnpackedColor()[3] = (int)(a * (float)255);
        ((Companion)Minimap.Companion).getUnpackedColor()[0] = (color & 0xFF0000) >> 16;
        ((Companion)Minimap.Companion).getUnpackedColor()[1] = (color & 0xFF00) >> 8;
        ((Companion)Minimap.Companion).getUnpackedColor()[2] = color & 0xFF;
        BufferedImage bufferedImage = this.img;
        if (bufferedImage == null) {
            Intrinsics.throwNpe();
        }
        bufferedImage.getRaster().setPixel(x, y, Minimap.Companion.getUnpackedColor());
    }

    public Minimap(@NotNull Config config) {
        Intrinsics.checkParameterIsNotNull((Object)config, (String)"config");
        this.config = config;
        this.logger = Logger.getInstance(this.getClass());
    }

    static {
        Companion = new Companion(null);
        CLEAR = AlphaComposite.getInstance(1);
        unpackedColor = new int[4];
        NO_LINES = new LineInfo(1, 0, 0);
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\f\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0006R\u001a\u0010\u0004\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0007\u0010\b\"\u0004\b\t\u0010\nR\u001a\u0010\u0005\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\b\"\u0004\b\f\u0010\nR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\b\"\u0004\b\u000e\u0010\n\u00a8\u0006\u000f"}, d2={"Lnet/vektah/codeglance/render/Minimap$LineInfo;", "", "number", "", "begin", "end", "(III)V", "getBegin", "()I", "setBegin", "(I)V", "getEnd", "setEnd", "getNumber", "setNumber", "CodeGlance_main"})
    public static final class LineInfo {
        private int number;
        private int begin;
        private int end;

        public final int getNumber() {
            return this.number;
        }

        public final void setNumber(int n) {
            this.number = n;
        }

        public final int getBegin() {
            return this.begin;
        }

        public final void setBegin(int n) {
            this.begin = n;
        }

        public final int getEnd() {
            return this.end;
        }

        public final void setEnd(int n) {
            this.end = n;
        }

        public LineInfo(int number, int begin, int end) {
            this.number = number;
            this.begin = begin;
            this.end = end;
        }
    }

    @Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0015\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001c\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lnet/vektah/codeglance/render/Minimap$Companion;", "", "()V", "CLEAR", "Ljava/awt/AlphaComposite;", "kotlin.jvm.PlatformType", "getCLEAR", "()Ljava/awt/AlphaComposite;", "NO_LINES", "Lnet/vektah/codeglance/render/Minimap$LineInfo;", "getNO_LINES", "()Lnet/vektah/codeglance/render/Minimap$LineInfo;", "unpackedColor", "", "getUnpackedColor", "()[I", "CodeGlance_main"})
    public static final class Companion {
        private final AlphaComposite getCLEAR() {
            return CLEAR;
        }

        private final int[] getUnpackedColor() {
            return unpackedColor;
        }

        private final LineInfo getNO_LINES() {
            return NO_LINES;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

