/*
 * Decompiled with CFR 0.152.
 */
package net.vektah.codeglance.config;

import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ConfigForm {
    private JComboBox pixelsPerLine;
    private JPanel rootPanel;
    private JCheckBox disabled;
    private JComboBox jumpToPosition;
    private JComboBox clickStyle;
    private JTextField width;
    private JTextField viewportColor;
    private JTextField minLinesCount;
    private JTextField minWindowWidth;
    private JComboBox renderStyle;
    private JComboBox alignment;
    private JCheckBox locked;

    public ConfigForm() {
        this.$$$setupUI$$$();
        this.pixelsPerLine.setModel(new DefaultComboBoxModel<Integer>(new Integer[]{1, 2, 3, 4}));
        this.jumpToPosition.setModel(new DefaultComboBoxModel<String>(new String[]{"Mouse Down", "Mouse Up"}));
        this.clickStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Scrollbar (old sublime)", "To Text (new sublime)"}));
        this.renderStyle.setModel(new DefaultComboBoxModel<String>(new String[]{"Clean", "Accurate"}));
        this.alignment.setModel(new DefaultComboBoxModel<String>(new String[]{"Right", "Left"}));
    }

    public JPanel getRoot() {
        return this.rootPanel;
    }

    public int getPixelsPerLine() {
        return (Integer)this.pixelsPerLine.getSelectedItem();
    }

    public void setPixelsPerLine(int pixelsPerLine) {
        this.pixelsPerLine.setSelectedIndex(pixelsPerLine - 1);
    }

    public boolean isDisabled() {
        return this.disabled.getModel().isSelected();
    }

    public void setDisabled(boolean isDisabled) {
        this.disabled.getModel().setSelected(isDisabled);
    }

    public boolean isLocked() {
        return this.locked.getModel().isSelected();
    }

    public void setLocked(boolean isLocked) {
        this.locked.getModel().setSelected(isLocked);
    }

    public boolean jumpOnMouseDown() {
        return this.jumpToPosition.getSelectedIndex() == 0;
    }

    public void setJumpOnMouseDown(boolean jump) {
        this.jumpToPosition.setSelectedIndex(jump ? 0 : 1);
    }

    public boolean percentageBasedClick() {
        return this.clickStyle.getSelectedIndex() == 0;
    }

    public void setPercentageBasedClick(boolean click) {
        this.clickStyle.setSelectedIndex(click ? 0 : 1);
    }

    public String getViewportColor() {
        return this.viewportColor.getText();
    }

    public void setViewportColor(String color) {
        this.viewportColor.setText(color);
    }

    public boolean getCleanStyle() {
        return this.renderStyle.getSelectedIndex() == 0;
    }

    public void setCleanStyle(boolean isClean) {
        this.renderStyle.setSelectedIndex(isClean ? 0 : 1);
    }

    public boolean isRightAligned() {
        return this.alignment.getSelectedIndex() == 0;
    }

    public void setRightAligned(boolean isRightAligned) {
        this.renderStyle.setSelectedIndex(isRightAligned ? 0 : 1);
    }

    public int getWidth() {
        try {
            return Integer.parseInt(this.width.getText());
        }
        catch (NumberFormatException e) {
            return 100;
        }
    }

    public void setWidth(int width) {
        this.width.setText(Integer.toString(width));
    }

    public int getMinLinesCount() {
        try {
            return Integer.parseInt(this.minLinesCount.getText());
        }
        catch (NumberFormatException e) {
            return 85;
        }
    }

    public void setMinLinesCount(int minLinesCount) {
        this.minLinesCount.setText(Integer.toString(minLinesCount));
    }

    public int getMinWindowWidth() {
        try {
            return Integer.parseInt(this.minWindowWidth.getText());
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setMinWindowWidth(int minWindowWidth) {
        this.minWindowWidth.setText(Integer.toString(minWindowWidth));
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JComboBox jComboBox;
        JComboBox jComboBox2;
        JTextField jTextField2;
        JTextField jTextField3;
        JTextField jTextField4;
        JComboBox jComboBox3;
        JCheckBox jCheckBox2;
        JComboBox jComboBox4;
        JComboBox jComboBox5;
        JPanel jPanel;
        this.rootPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(11, 4, new Insets(0, 0, 0, 0), -1, -1, false, false));
        JLabel jLabel = new JLabel();
        jLabel.setText("Pixels Per Line:");
        jLabel.setDisplayedMnemonic('P');
        jLabel.setDisplayedMnemonicIndex(0);
        jPanel.add((Component)jLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.pixelsPerLine = jComboBox5 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        defaultComboBoxModel.addElement("1");
        defaultComboBoxModel.addElement("2");
        defaultComboBoxModel.addElement("3");
        defaultComboBoxModel.addElement("4");
        jComboBox5.setModel(defaultComboBoxModel);
        jPanel.add(jComboBox5, new GridConstraints(0, 1, 1, 1, 8, 1, 2, 0, null, new Dimension(200, 24), null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(0, 3, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("Jump to position on:");
        jPanel.add((Component)jLabel2, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.jumpToPosition = jComboBox4 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel2 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel2.addElement("Mouse Down");
        defaultComboBoxModel2.addElement("Mouse Up");
        jComboBox4.setModel(defaultComboBoxModel2);
        jPanel.add(jComboBox4, new GridConstraints(1, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setText("Disabled:");
        jPanel.add((Component)jLabel3, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.disabled = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("");
        jPanel.add((Component)jCheckBox2, new GridConstraints(3, 1, 1, 1, 8, 0, 3, 0, null, null, null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setText("Click style");
        jPanel.add((Component)jLabel4, new GridConstraints(2, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.clickStyle = jComboBox3 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel3 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel3.addElement("Scrollbar (old sublime)");
        defaultComboBoxModel3.addElement("To Text (new sublime)");
        jComboBox3.setModel(defaultComboBoxModel3);
        jPanel.add(jComboBox3, new GridConstraints(2, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        this.width = jTextField4 = new JTextField();
        jPanel.add((Component)jTextField4, new GridConstraints(4, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("Width:");
        jPanel.add((Component)jLabel5, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        JLabel jLabel6 = new JLabel();
        jLabel6.setText("Viewport Color");
        jPanel.add((Component)jLabel6, new GridConstraints(5, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.viewportColor = jTextField3 = new JTextField();
        jPanel.add((Component)jTextField3, new GridConstraints(5, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel7 = new JLabel();
        jLabel7.setToolTipText("Minimum number of lines to show minimap.");
        jLabel7.setText("Minimum lines count:");
        jPanel.add((Component)jLabel7, new GridConstraints(6, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(10, 0, 1, 1, 0, 2, 1, 6, null, null, null));
        this.minLinesCount = jTextField2 = new JTextField();
        jTextField2.setText("");
        jPanel.add((Component)jTextField2, new GridConstraints(6, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        JLabel jLabel8 = new JLabel();
        jLabel8.setText("Render Style");
        jPanel.add((Component)jLabel8, new GridConstraints(8, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.renderStyle = jComboBox2 = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel4 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel4.addElement("Clean");
        defaultComboBoxModel4.addElement("Accurate");
        jComboBox2.setModel(defaultComboBoxModel4);
        jPanel.add(jComboBox2, new GridConstraints(8, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel9 = new JLabel();
        jLabel9.setText("Alignment (restart)");
        jPanel.add((Component)jLabel9, new GridConstraints(9, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.alignment = jComboBox = new JComboBox();
        DefaultComboBoxModel<String> defaultComboBoxModel5 = new DefaultComboBoxModel<String>();
        defaultComboBoxModel5.addElement("Right");
        defaultComboBoxModel5.addElement("Left");
        jComboBox.setModel(defaultComboBoxModel5);
        jPanel.add(jComboBox, new GridConstraints(9, 1, 1, 1, 8, 1, 2, 0, null, null, null));
        JLabel jLabel10 = new JLabel();
        jLabel10.setText("Minimum Window Width:");
        jPanel.add((Component)jLabel10, new GridConstraints(7, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.minWindowWidth = jTextField = new JTextField();
        jPanel.add((Component)jTextField, new GridConstraints(7, 1, 1, 1, 8, 1, 6, 0, null, new Dimension(150, -1), null));
        this.locked = jCheckBox = new JCheckBox();
        jCheckBox.setText("lock");
        jPanel.add((Component)jCheckBox, new GridConstraints(4, 2, 1, 1, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jComboBox5);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.rootPanel;
    }
}

