/*
 * Decompiled with CFR 0.152.
 */
package net.vektah.codeglance;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.vektah.codeglance.config.Config;
import net.vektah.codeglance.config.ConfigService;
import net.vektah.codeglance.render.ScrollState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u00032\u00020\u0004B\u0015\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020\u0016H\u0002J\u0012\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010%\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010&\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010'\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010(\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010)\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0012\u0010*\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$H\u0016J\u0010\u0010+\u001a\u00020\"2\u0006\u0010,\u001a\u00020-H\u0016J\u0012\u0010.\u001a\u00020\"2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0010\u00101\u001a\u00020\"2\u0006\u00102\u001a\u00020\u0016H\u0002R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001e\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lnet/vektah/codeglance/Scrollbar;", "Ljavax/swing/JPanel;", "Ljava/awt/event/MouseListener;", "Ljava/awt/event/MouseWheelListener;", "Ljava/awt/event/MouseMotionListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "scrollstate", "Lnet/vektah/codeglance/render/ScrollState;", "(Lcom/intellij/openapi/editor/Editor;Lnet/vektah/codeglance/render/ScrollState;)V", "config", "Lnet/vektah/codeglance/config/Config;", "configService", "Lnet/vektah/codeglance/config/ConfigService;", "kotlin.jvm.PlatformType", "defaultCursor", "Ljava/awt/Cursor;", "dragging", "", "getEditor", "()Lcom/intellij/openapi/editor/Editor;", "mouseStart", "", "resizeStart", "resizing", "scrollStart", "getScrollstate", "()Lnet/vektah/codeglance/render/ScrollState;", "visibleRectColor", "Ljava/awt/Color;", "widthStart", "isInReizeGutter", "x", "mouseClicked", "", "e", "Ljava/awt/event/MouseEvent;", "mouseDragged", "mouseEntered", "mouseExited", "mouseMoved", "mousePressed", "mouseReleased", "mouseWheelMoved", "mouseWheelEvent", "Ljava/awt/event/MouseWheelEvent;", "paint", "gfx", "Ljava/awt/Graphics;", "scrollTo", "y", "CodeGlance_main"})
public final class Scrollbar
extends JPanel
implements MouseListener,
MouseWheelListener,
MouseMotionListener {
    private int scrollStart;
    private int mouseStart;
    private final Cursor defaultCursor;
    private boolean resizing;
    private boolean dragging;
    private int resizeStart;
    private int widthStart;
    private final ConfigService configService;
    private Config config;
    private Color visibleRectColor;
    @NotNull
    private final Editor editor;
    @NotNull
    private final ScrollState scrollstate;

    @Override
    public void mouseEntered(@Nullable MouseEvent e) {
    }

    @Override
    public void mouseExited(@Nullable MouseEvent e) {
    }

    private final boolean isInReizeGutter(int x) {
        if (this.config.getLocked()) {
            return false;
        }
        if (this.config.isRightAligned()) {
            return x >= 0 && x < 8;
        }
        return x >= this.config.getWidth() - 8 && x <= this.config.getWidth();
    }

    @Override
    public void mouseDragged(@Nullable MouseEvent e) {
        if (this.resizing) {
            int n;
            if (this.config.isRightAligned()) {
                MouseEvent mouseEvent = e;
                if (mouseEvent == null) {
                    Intrinsics.throwNpe();
                }
                n = this.resizeStart - mouseEvent.getXOnScreen();
            } else {
                MouseEvent mouseEvent = e;
                if (mouseEvent == null) {
                    Intrinsics.throwNpe();
                }
                n = mouseEvent.getXOnScreen() - this.resizeStart;
            }
            this.config.setWidth(this.widthStart + n);
            if (this.config.getWidth() < 50) {
                this.config.setWidth(50);
            } else if (this.config.getWidth() > 250) {
                this.config.setWidth(250);
            }
            this.configService.notifyChange();
        }
        if (this.dragging) {
            this.editor.getScrollingModel().disableAnimation();
            MouseEvent mouseEvent = e;
            if (mouseEvent == null) {
                Intrinsics.throwNpe();
            }
            this.scrollTo(mouseEvent.getY());
            this.editor.getScrollingModel().enableAnimation();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void mousePressed(@Nullable MouseEvent e) {
        if (this.dragging) ** GOTO lbl-1000
        v0 = e;
        if (v0 == null) {
            Intrinsics.throwNpe();
        }
        if (this.isInReizeGutter(v0.getX())) {
            this.resizing = true;
        } else if (!this.resizing) {
            this.dragging = true;
        }
        if (this.resizing) {
            v1 = e;
            if (v1 == null) {
                Intrinsics.throwNpe();
            }
            this.resizeStart = v1.getXOnScreen();
            this.widthStart = this.config.getWidth();
        }
        if (this.dragging) {
            if (this.config.getJumpOnMouseDown()) {
                v2 = e;
                if (v2 == null) {
                    Intrinsics.throwNpe();
                }
                this.scrollTo(v2.getY());
            }
            this.scrollStart = this.editor.getScrollingModel().getVerticalScrollOffset();
            v3 = e;
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            this.mouseStart = v3.getY();
        }
    }

    private final void scrollTo(int y) {
        float percentage = (float)(y + this.scrollstate.getVisibleStart()) / (float)this.scrollstate.getDocumentHeight();
        int offset = this.editor.getComponent().getSize().height / 2;
        this.editor.getScrollingModel().scrollVertically((int)(percentage * (float)this.editor.getContentComponent().getSize().height - (float)offset));
    }

    @Override
    public void mouseReleased(@Nullable MouseEvent e) {
        this.dragging = false;
        this.resizing = false;
    }

    @Override
    public void mouseClicked(@Nullable MouseEvent e) {
        if (!this.config.getJumpOnMouseDown()) {
            MouseEvent mouseEvent = e;
            if (mouseEvent == null) {
                Intrinsics.throwNpe();
            }
            this.scrollTo(mouseEvent.getY());
        }
    }

    @Override
    public void mouseMoved(@Nullable MouseEvent e) {
        MouseEvent mouseEvent = e;
        if (mouseEvent == null) {
            Intrinsics.throwNpe();
        }
        if (this.isInReizeGutter(mouseEvent.getX())) {
            this.setCursor(this.config.isRightAligned() ? new Cursor(10) : new Cursor(11));
        } else {
            this.setCursor(this.defaultCursor);
        }
    }

    @Override
    public void mouseWheelMoved(@NotNull MouseWheelEvent mouseWheelEvent) {
        Intrinsics.checkParameterIsNotNull((Object)mouseWheelEvent, (String)"mouseWheelEvent");
        this.editor.getScrollingModel().scrollVertically(this.editor.getScrollingModel().getVerticalScrollOffset() + mouseWheelEvent.getWheelRotation() * this.editor.getLineHeight() * 3);
    }

    @Override
    public void paint(@Nullable Graphics gfx) {
        Graphics graphics = gfx;
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g = (Graphics2D)graphics;
        g.setColor(this.visibleRectColor);
        g.setComposite(AlphaComposite.getInstance(3, 0.2f));
        g.fillRect(0, this.scrollstate.getViewportStart() - this.scrollstate.getVisibleStart(), this.getWidth(), this.scrollstate.getViewportHeight());
    }

    @NotNull
    public final Editor getEditor() {
        return this.editor;
    }

    @NotNull
    public final ScrollState getScrollstate() {
        return this.scrollstate;
    }

    public Scrollbar(@NotNull Editor editor, @NotNull ScrollState scrollstate) {
        Intrinsics.checkParameterIsNotNull((Object)editor, (String)"editor");
        Intrinsics.checkParameterIsNotNull((Object)scrollstate, (String)"scrollstate");
        this.editor = editor;
        this.scrollstate = scrollstate;
        this.defaultCursor = new Cursor(0);
        this.configService = (ConfigService)ServiceManager.getService(ConfigService.class);
        Config config = this.configService.getState();
        if (config == null) {
            Intrinsics.throwNpe();
        }
        this.config = config;
        Color color = Color.decode("#" + this.config.getViewportColor());
        Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.decode(\"#\" + config.viewportColor)");
        this.visibleRectColor = color;
        this.configService.onChange((Function0<Unit>)((Function0)new Function0<Unit>(){

            public final void invoke() {
                Config config = configService.getState();
                if (config == null) {
                    Intrinsics.throwNpe();
                }
                config = config;
                Color color = Color.decode("#" + config.getViewportColor());
                Intrinsics.checkExpressionValueIsNotNull((Object)color, (String)"Color.decode(\"#\" + config.viewportColor)");
                visibleRectColor = color;
            }
        }));
        this.addMouseWheelListener(this);
        this.addMouseListener(this);
        this.addMouseMotionListener(this);
    }

    @NotNull
    public static final /* synthetic */ Color access$getVisibleRectColor$p(Scrollbar $this) {
        return $this.visibleRectColor;
    }
}

