/*
 * Decompiled with CFR 0.152.
 */
package net.vektah.codeglance;

import com.intellij.lang.Language;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.ColorKey;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.event.SelectionEvent;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.event.VisibleAreaEvent;
import com.intellij.openapi.editor.event.VisibleAreaListener;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.fileTypes.SyntaxHighlighter;
import com.intellij.openapi.fileTypes.SyntaxHighlighterFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.ui.JBColor;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.image.BufferedImage;
import java.lang.ref.SoftReference;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.ArraysKt;
import kotlin.collections.IndexedValue;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import net.vektah.codeglance.Scrollbar;
import net.vektah.codeglance.concurrent.DirtyLock;
import net.vektah.codeglance.config.Config;
import net.vektah.codeglance.config.ConfigService;
import net.vektah.codeglance.render.Folds;
import net.vektah.codeglance.render.Minimap;
import net.vektah.codeglance.render.ScrollState;
import net.vektah.codeglance.render.TaskRunner;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000\u00a0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B%\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\n\u0010,\u001a\u0004\u0018\u00010 H\u0002J\u0006\u0010-\u001a\u00020#J\u0012\u0010.\u001a\u00020#2\b\u0010/\u001a\u0004\u0018\u000100H\u0016J\u0010\u00101\u001a\u00020#2\b\u0010/\u001a\u0004\u0018\u000100J \u00102\u001a\u00020#2\u0006\u00103\u001a\u0002042\u0006\u00105\u001a\u00020\u001d2\u0006\u00106\u001a\u00020\u001dH\u0002J\u0010\u00107\u001a\u00020#2\u0006\u00103\u001a\u000204H\u0002J\b\u00108\u001a\u00020#H\u0002J\b\u00109\u001a\u00020#H\u0002J\b\u0010:\u001a\u00020#H\u0002J\u0010\u0010;\u001a\u00020#2\u0006\u0010<\u001a\u00020=H\u0016R\u0010\u0010\u000b\u001a\u0004\u0018\u00010\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0011\u001a\n \u0013*\u0004\u0018\u00010\u00120\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0016\u001a\u00070\u0017\u00a2\u0006\u0002\b\u0018X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0019\u001a\u00020\u001a8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001bR\u000e\u0010\u001c\u001a\u00020\u001dX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010!\u001a\b\u0012\u0004\u0012\u00020#0\"X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020%X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010&\u001a\u00020'X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010(\u001a\u00020)X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010*\u001a\u00020+X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006>"}, d2={"Lnet/vektah/codeglance/GlancePanel;", "Ljavax/swing/JPanel;", "Lcom/intellij/openapi/editor/event/VisibleAreaListener;", "project", "Lcom/intellij/openapi/project/Project;", "fileEditor", "Lcom/intellij/openapi/fileEditor/FileEditor;", "container", "runner", "Lnet/vektah/codeglance/render/TaskRunner;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/fileEditor/FileEditor;Ljavax/swing/JPanel;Lnet/vektah/codeglance/render/TaskRunner;)V", "buf", "Ljava/awt/image/BufferedImage;", "componentListener", "Ljava/awt/event/ComponentListener;", "config", "Lnet/vektah/codeglance/config/Config;", "configService", "Lnet/vektah/codeglance/config/ConfigService;", "kotlin.jvm.PlatformType", "documentListener", "Lcom/intellij/openapi/editor/event/DocumentListener;", "editor", "Lcom/intellij/openapi/editor/Editor;", "Lorg/jetbrains/annotations/NotNull;", "isDisabled", "", "()Z", "lastFoldCount", "", "mapRef", "Ljava/lang/ref/SoftReference;", "Lnet/vektah/codeglance/render/Minimap;", "onConfigChange", "Lkotlin/Function0;", "", "renderLock", "Lnet/vektah/codeglance/concurrent/DirtyLock;", "scrollbar", "Lnet/vektah/codeglance/Scrollbar;", "scrollstate", "Lnet/vektah/codeglance/render/ScrollState;", "selectionListener", "Lcom/intellij/openapi/editor/event/SelectionListener;", "getOrCreateMap", "onClose", "paint", "gfx", "Ljava/awt/Graphics;", "paintLast", "paintSelection", "g", "Ljava/awt/Graphics2D;", "startByte", "endByte", "paintSelections", "updateImage", "updateImageSoon", "updateSize", "visibleAreaChanged", "visibleAreaEvent", "Lcom/intellij/openapi/editor/event/VisibleAreaEvent;", "CodeGlance_main"})
public final class GlancePanel
extends JPanel
implements VisibleAreaListener {
    private final Editor editor;
    private SoftReference<Minimap> mapRef;
    private final ConfigService configService;
    private Config config;
    private int lastFoldCount;
    private BufferedImage buf;
    private final DirtyLock renderLock;
    private final ScrollState scrollstate;
    private final Scrollbar scrollbar;
    private final ComponentListener componentListener;
    private final DocumentListener documentListener;
    private final SelectionListener selectionListener;
    private final Function0<Unit> onConfigChange;
    private final Project project;
    private final JPanel container;
    private final TaskRunner runner;

    private final boolean isDisabled() {
        return this.config.getDisabled() || this.editor.getDocument().getTextLength() > this.config.getMaxFileSize() || this.editor.getDocument().getLineCount() < this.config.getMinLineCount() || this.container.getWidth() < this.config.getMinWindowWidth();
    }

    private final void updateSize() {
        if (this.isDisabled()) {
            this.setPreferredSize(new Dimension(0, 0));
        } else {
            Dimension size = new Dimension(this.config.getWidth(), 0);
            this.setPreferredSize(size);
        }
    }

    private final Minimap getOrCreateMap() {
        Minimap map = this.mapRef.get();
        if (map == null) {
            Config config = this.configService.getState();
            if (config == null) {
                Intrinsics.throwNpe();
            }
            map = new Minimap(config);
            this.mapRef = new SoftReference<Minimap>(map);
        }
        return map;
    }

    private final void updateImage() {
        if (this.isDisabled()) {
            return;
        }
        if (this.project.isDisposed()) {
            return;
        }
        PsiFile psiFile = PsiDocumentManager.getInstance((Project)this.project).getPsiFile(this.editor.getDocument());
        if (psiFile == null) {
            return;
        }
        PsiFile file = psiFile;
        Minimap minimap = this.getOrCreateMap();
        if (minimap == null) {
            return;
        }
        Minimap map = minimap;
        if (!this.renderLock.acquire()) {
            return;
        }
        SyntaxHighlighter hl = SyntaxHighlighterFactory.getSyntaxHighlighter((Language)file.getLanguage(), (Project)this.project, (VirtualFile)file.getVirtualFile());
        String text = this.editor.getDocument().getText();
        FoldRegion[] foldRegionArray = this.editor.getFoldingModel().getAllFoldRegions();
        Intrinsics.checkExpressionValueIsNotNull((Object)foldRegionArray, (String)"editor.foldingModel.allFoldRegions");
        Folds folds = new Folds(foldRegionArray);
        this.runner.run((Function0<Unit>)((Function0)new Function0<Unit>(this, map, text, hl, folds){
            final /* synthetic */ GlancePanel this$0;
            final /* synthetic */ Minimap $map;
            final /* synthetic */ String $text;
            final /* synthetic */ SyntaxHighlighter $hl;
            final /* synthetic */ Folds $folds;

            public final void invoke() {
                CharSequence charSequence = this.$text;
                Intrinsics.checkExpressionValueIsNotNull((Object)charSequence, (String)"text");
                EditorColorsScheme editorColorsScheme = GlancePanel.access$getEditor$p(this.this$0).getColorsScheme();
                Intrinsics.checkExpressionValueIsNotNull((Object)editorColorsScheme, (String)"editor.colorsScheme");
                SyntaxHighlighter syntaxHighlighter = this.$hl;
                Intrinsics.checkExpressionValueIsNotNull((Object)syntaxHighlighter, (String)"hl");
                this.$map.update(charSequence, editorColorsScheme, syntaxHighlighter, this.$folds);
                GlancePanel.access$getScrollstate$p(this.this$0).setDocumentSize(GlancePanel.access$getConfig$p(this.this$0).getWidth(), this.$map.getHeight());
                GlancePanel.access$getRenderLock$p(this.this$0).release();
                if (GlancePanel.access$getRenderLock$p(this.this$0).getDirty()) {
                    GlancePanel.access$updateImageSoon(this.this$0);
                    GlancePanel.access$getRenderLock$p(this.this$0).clean();
                }
                this.this$0.repaint();
            }
            {
                this.this$0 = glancePanel;
                this.$map = minimap;
                this.$text = string;
                this.$hl = syntaxHighlighter;
                this.$folds = folds;
                super(0);
            }
        }));
    }

    private final void updateImageSoon() {
        SwingUtilities.invokeLater(new Runnable(this){
            final /* synthetic */ GlancePanel this$0;

            public final void run() {
                GlancePanel.access$updateImage(this.this$0);
            }
            {
                this.this$0 = glancePanel;
            }
        });
    }

    public final void paintLast(@Nullable Graphics gfx) {
        Graphics graphics = gfx;
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        Graphics2D g = (Graphics2D)graphics;
        if (this.buf != null) {
            Image image = this.buf;
            BufferedImage bufferedImage = this.buf;
            if (bufferedImage == null) {
                Intrinsics.throwNpe();
            }
            int n = bufferedImage.getWidth();
            BufferedImage bufferedImage2 = this.buf;
            if (bufferedImage2 == null) {
                Intrinsics.throwNpe();
            }
            int n2 = bufferedImage2.getHeight();
            BufferedImage bufferedImage3 = this.buf;
            if (bufferedImage3 == null) {
                Intrinsics.throwNpe();
            }
            int n3 = bufferedImage3.getWidth();
            BufferedImage bufferedImage4 = this.buf;
            if (bufferedImage4 == null) {
                Intrinsics.throwNpe();
            }
            g.drawImage(image, 0, 0, n, n2, 0, 0, n3, bufferedImage4.getHeight(), null);
        }
        this.paintSelections(g);
        this.scrollbar.paint(gfx);
    }

    @Override
    public void paint(@Nullable Graphics gfx) {
        Minimap minimap;
        block11: {
            block10: {
                if (this.renderLock.getLocked()) {
                    this.paintLast(gfx);
                    return;
                }
                minimap = this.mapRef.get();
                if (minimap == null) {
                    this.updateImageSoon();
                    this.paintLast(gfx);
                    return;
                }
                if (this.buf == null) break block10;
                BufferedImage bufferedImage = this.buf;
                Integer n = bufferedImage != null ? Integer.valueOf(bufferedImage.getWidth()) : null;
                if (n == null) {
                    Intrinsics.throwNpe();
                }
                if (n < this.getWidth()) break block10;
                BufferedImage bufferedImage2 = this.buf;
                Integer n2 = bufferedImage2 != null ? Integer.valueOf(bufferedImage2.getHeight()) : null;
                if (n2 == null) {
                    Intrinsics.throwNpe();
                }
                if (n2 >= this.getHeight()) break block11;
            }
            this.buf = new BufferedImage(this.getWidth(), this.getHeight(), 6);
        }
        BufferedImage bufferedImage = this.buf;
        if (bufferedImage == null) {
            Intrinsics.throwNpe();
        }
        Graphics2D g = bufferedImage.createGraphics();
        g.setComposite(AlphaComposite.getInstance(1));
        g.fillRect(0, 0, this.getWidth(), this.getHeight());
        g.setComposite(AlphaComposite.getInstance(3));
        if (this.editor.getDocument().getTextLength() != 0) {
            g.drawImage(minimap.getImg(), 0, 0, this.scrollstate.getDocumentWidth(), this.scrollstate.getDrawHeight(), 0, this.scrollstate.getVisibleStart(), this.scrollstate.getDocumentWidth(), this.scrollstate.getVisibleEnd(), null);
        }
        Graphics graphics = gfx;
        if (graphics == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.Graphics2D");
        }
        this.paintSelections((Graphics2D)graphics);
        gfx.drawImage(this.buf, 0, 0, null);
        this.scrollbar.paint(gfx);
    }

    private final void paintSelection(Graphics2D g, int startByte, int endByte) {
        VisualPosition start = this.editor.offsetToVisualPosition(startByte);
        VisualPosition end = this.editor.offsetToVisualPosition(endByte);
        int sX = start.column;
        int sY = (start.line + 1) * this.config.getPixelsPerLine() - this.scrollstate.getVisibleStart();
        int eX = end.column;
        int eY = (end.line + 1) * this.config.getPixelsPerLine() - this.scrollstate.getVisibleStart();
        g.setComposite(AlphaComposite.getInstance(3, 0.8f));
        g.setColor(this.editor.getColorsScheme().getColor(ColorKey.createColorKey((String)"SELECTION_BACKGROUND", (Color)((Color)JBColor.BLUE))));
        if (start.line == end.line) {
            g.fillRect(sX, sY, eX - sX, this.config.getPixelsPerLine());
        } else {
            g.fillRect(sX, sY, this.getWidth() - sX, this.config.getPixelsPerLine());
            g.fillRect(0, eY, eX, this.config.getPixelsPerLine());
            if (eY + this.config.getPixelsPerLine() != sY) {
                g.fillRect(0, sY + this.config.getPixelsPerLine(), this.getWidth(), eY - sY - this.config.getPixelsPerLine());
            }
        }
    }

    private final void paintSelections(Graphics2D g) {
        this.paintSelection(g, this.editor.getSelectionModel().getSelectionStart(), this.editor.getSelectionModel().getSelectionEnd());
        for (IndexedValue indexedValue : ArraysKt.withIndex((int[])this.editor.getSelectionModel().getBlockSelectionStarts())) {
            int index = indexedValue.component1();
            int start = ((Number)indexedValue.component2()).intValue();
            this.paintSelection(g, start, this.editor.getSelectionModel().getBlockSelectionEnds()[index]);
        }
    }

    public void visibleAreaChanged(@NotNull VisibleAreaEvent visibleAreaEvent) {
        Intrinsics.checkParameterIsNotNull((Object)visibleAreaEvent, (String)"visibleAreaEvent");
        int currentFoldCount = 0;
        FoldRegion[] foldRegionArray = this.editor.getFoldingModel().getAllFoldRegions();
        for (int i = 0; i < foldRegionArray.length; ++i) {
            FoldRegion fold = foldRegionArray[i];
            if (fold.isExpanded()) continue;
            ++currentFoldCount;
        }
        Rectangle visibleArea = this.editor.getScrollingModel().getVisibleArea();
        double factor = (double)this.scrollstate.getDocumentHeight() / (double)this.editor.getContentComponent().getHeight();
        this.scrollstate.setViewportArea((int)(factor * (double)visibleArea.y), (int)(factor * (double)visibleArea.height));
        this.scrollstate.setVisibleHeight(this.getHeight());
        if (currentFoldCount != this.lastFoldCount) {
            this.updateImage();
        }
        this.lastFoldCount = currentFoldCount;
        this.updateSize();
        this.repaint();
    }

    public final void onClose() {
        this.container.removeComponentListener(this.componentListener);
        this.editor.getDocument().removeDocumentListener(this.documentListener);
        this.editor.getSelectionModel().removeSelectionListener(this.selectionListener);
        this.remove(this.scrollbar);
        this.mapRef.clear();
    }

    public GlancePanel(@NotNull Project project, @NotNull FileEditor fileEditor, @NotNull JPanel container, @NotNull TaskRunner runner) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)fileEditor, (String)"fileEditor");
        Intrinsics.checkParameterIsNotNull((Object)container, (String)"container");
        Intrinsics.checkParameterIsNotNull((Object)runner, (String)"runner");
        this.project = project;
        this.container = container;
        this.runner = runner;
        FileEditor fileEditor2 = fileEditor;
        if (fileEditor2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.openapi.fileEditor.TextEditor");
        }
        this.editor = ((TextEditor)fileEditor2).getEditor();
        this.mapRef = new SoftReference<Object>(null);
        this.configService = (ConfigService)ServiceManager.getService(ConfigService.class);
        Config config = this.configService.getState();
        if (config == null) {
            Intrinsics.throwNpe();
        }
        this.config = config;
        this.lastFoldCount = -1;
        this.renderLock = new DirtyLock();
        this.scrollstate = new ScrollState();
        Editor editor = this.editor;
        Intrinsics.checkExpressionValueIsNotNull((Object)editor, (String)"editor");
        this.scrollbar = new Scrollbar(editor, this.scrollstate);
        this.selectionListener = new SelectionListener(this){
            final /* synthetic */ GlancePanel this$0;

            public final void selectionChanged(SelectionEvent it) {
                this.this$0.repaint();
            }
            {
                this.this$0 = glancePanel;
            }
        };
        this.onConfigChange = (Function0)new Function0<Unit>(this){
            final /* synthetic */ GlancePanel this$0;

            public final void invoke() {
                GlancePanel.access$updateImage(this.this$0);
                GlancePanel.access$updateSize(this.this$0);
                this.this$0.revalidate();
                this.this$0.repaint();
            }
            {
                this.this$0 = glancePanel;
                super(0);
            }
        };
        this.componentListener = new ComponentAdapter(){

            @Override
            public void componentResized(@Nullable ComponentEvent componentEvent) {
                this.updateSize();
                scrollstate.setVisibleHeight(this.getHeight());
                this.revalidate();
                this.repaint();
            }
        };
        this.container.addComponentListener(this.componentListener);
        this.documentListener = (DocumentListener)new DocumentAdapter(){

            public void documentChanged(@Nullable DocumentEvent documentEvent) {
                this.updateImage();
            }
        };
        this.editor.getDocument().addDocumentListener(this.documentListener);
        this.configService.onChange(this.onConfigChange);
        this.editor.getScrollingModel().addVisibleAreaListener((VisibleAreaListener)this);
        this.editor.getSelectionModel().addSelectionListener(this.selectionListener);
        this.updateSize();
        this.updateImage();
        this.setOpaque(false);
        this.setLayout(new BorderLayout());
        this.add(this.scrollbar);
    }

    @NotNull
    public static final /* synthetic */ Editor access$getEditor$p(GlancePanel $this) {
        return $this.editor;
    }

    @NotNull
    public static final /* synthetic */ Config access$getConfig$p(GlancePanel $this) {
        return $this.config;
    }

    public static final /* synthetic */ void access$setConfig$p(GlancePanel $this, @NotNull Config config) {
        $this.config = config;
    }

    @NotNull
    public static final /* synthetic */ DirtyLock access$getRenderLock$p(GlancePanel $this) {
        return $this.renderLock;
    }

    public static final /* synthetic */ void access$updateImageSoon(GlancePanel $this) {
        $this.updateImageSoon();
    }
}

