/*
 * Decompiled with CFR 0.152.
 */
package net.vektah.codeglance;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.fileEditor.FileEditorManagerEvent;
import com.intellij.openapi.fileEditor.FileEditorManagerListener;
import com.intellij.openapi.fileEditor.TextEditor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.JBSplitter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashMap;
import java.util.HashSet;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import net.vektah.codeglance.GlancePanel;
import net.vektah.codeglance.config.Config;
import net.vektah.codeglance.config.ConfigService;
import net.vektah.codeglance.render.TaskRunner;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 1}, bv={1, 0, 0}, k=1, d1={"\u0000b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0018\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0018\u0010\u0019\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0010\u0010\u001a\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u001b\u001a\u0004\u0018\u00010\u001c2\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\u0010\u0010\u001e\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020\u00142\u0006\u0010 \u001a\u00020!H\u0016J\u0010\u0010\"\u001a\u00020\u00142\u0006\u0010\u001d\u001a\u00020\u0011H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\f\u001a\u00070\r\u00a2\u0006\u0002\b\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u000f\u001a\u000e\u0012\u0004\u0012\u00020\u0011\u0012\u0004\u0012\u00020\u00120\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/vektah/codeglance/EditorPanelInjector;", "Lcom/intellij/openapi/fileEditor/FileEditorManagerListener;", "project", "Lcom/intellij/openapi/project/Project;", "runner", "Lnet/vektah/codeglance/render/TaskRunner;", "(Lcom/intellij/openapi/project/Project;Lnet/vektah/codeglance/render/TaskRunner;)V", "config", "Lnet/vektah/codeglance/config/Config;", "configService", "Lnet/vektah/codeglance/config/ConfigService;", "kotlin.jvm.PlatformType", "logger", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "panels", "Ljava/util/HashMap;", "Lcom/intellij/openapi/fileEditor/FileEditor;", "Lnet/vektah/codeglance/GlancePanel;", "fileClosed", "", "fem", "Lcom/intellij/openapi/fileEditor/FileEditorManager;", "virtualFile", "Lcom/intellij/openapi/vfs/VirtualFile;", "fileOpened", "freeUnusedPanels", "getPanel", "Ljavax/swing/JPanel;", "editor", "inject", "selectionChanged", "fileEditorManagerEvent", "Lcom/intellij/openapi/fileEditor/FileEditorManagerEvent;", "uninject", "CodeGlance_main"})
public final class EditorPanelInjector
implements FileEditorManagerListener {
    private final Logger logger;
    private final HashMap<FileEditor, GlancePanel> panels;
    private final ConfigService configService;
    private Config config;
    private final Project project;
    private final TaskRunner runner;

    public void fileOpened(@NotNull FileEditorManager fem, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)fem, (String)"fem");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        FileEditor[] editors = fem.getAllEditors();
        for (int i = 0; i < editors.length; ++i) {
            FileEditor editor;
            FileEditor fileEditor = editor = editors[i];
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor, (String)"editor");
            this.inject(fileEditor);
        }
        this.freeUnusedPanels(fem);
    }

    private final JPanel getPanel(FileEditor editor) {
        if (!(editor instanceof TextEditor)) {
            this.logger.debug("I01: Injection failed, only text editors are supported currently.");
            return null;
        }
        try {
            JPanel jPanel;
            JComponent jComponent = ((TextEditor)editor).getComponent();
            if (jComponent == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.swing.JPanel");
            }
            JPanel outerPanel = (JPanel)jComponent;
            LayoutManager layoutManager = outerPanel.getLayout();
            if (layoutManager == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.awt.BorderLayout");
            }
            BorderLayout outerLayout = (BorderLayout)layoutManager;
            Component layoutComponent = outerLayout.getLayoutComponent("Center");
            if (layoutComponent instanceof JBSplitter) {
                JComponent jComponent2 = ((JBSplitter)layoutComponent).getFirstComponent();
                if (jComponent2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.swing.JPanel");
                }
                JPanel editorComp = (JPanel)jComponent2;
                LayoutManager layoutManager2 = editorComp.getLayout();
                if (layoutManager2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type java.awt.BorderLayout");
                }
                layoutComponent = ((BorderLayout)layoutManager2).getLayoutComponent("Center");
            }
            Component component = layoutComponent;
            if (component == null) {
                throw new TypeCastException("null cannot be cast to non-null type javax.swing.JLayeredPane");
            }
            JLayeredPane pane = (JLayeredPane)component;
            if (pane.getComponentCount() > 1) {
                Component component2 = pane.getComponent(1);
                if (component2 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.swing.JPanel");
                }
                jPanel = (JPanel)component2;
            } else {
                Component component3 = pane.getComponent(0);
                if (component3 == null) {
                    throw new TypeCastException("null cannot be cast to non-null type javax.swing.JPanel");
                }
                jPanel = (JPanel)component3;
            }
            JPanel panel = jPanel;
            LayoutManager layoutManager3 = panel.getLayout();
            if (layoutManager3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.awt.BorderLayout");
            }
            BorderLayout cfr_ignored_0 = (BorderLayout)layoutManager3;
            return panel;
        }
        catch (ClassCastException e) {
            this.logger.warn("Injection failed");
            Throwable throwable = e;
            Throwable throwable2 = throwable;
            if (throwable2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.Throwable");
            }
            throwable2.printStackTrace();
            return null;
        }
    }

    private final void inject(FileEditor editor) {
        String where;
        JPanel jPanel = this.getPanel(editor);
        if (jPanel == null) {
            return;
        }
        JPanel panel = jPanel;
        LayoutManager layoutManager = panel.getLayout();
        if (layoutManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.BorderLayout");
        }
        BorderLayout innerLayout = (BorderLayout)layoutManager;
        String string = where = this.config.isRightAligned() ? "After" : "Before";
        if (innerLayout.getLayoutComponent(where) == null) {
            GlancePanel glancePanel = new GlancePanel(this.project, editor, panel, this.runner);
            panel.add((Component)glancePanel, where);
            this.panels.put(editor, glancePanel);
        }
    }

    private final void uninject(FileEditor editor) {
        Component leftPanel;
        JPanel jPanel = this.getPanel(editor);
        if (jPanel == null) {
            return;
        }
        JPanel panel = jPanel;
        LayoutManager layoutManager = panel.getLayout();
        if (layoutManager == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.awt.BorderLayout");
        }
        BorderLayout innerLayout = (BorderLayout)layoutManager;
        Component rightPanel = innerLayout.getLayoutComponent("After");
        if (rightPanel != null) {
            panel.remove(rightPanel);
        }
        if ((leftPanel = innerLayout.getLayoutComponent("Before")) != null) {
            panel.remove(leftPanel);
        }
    }

    public void fileClosed(@NotNull FileEditorManager fem, @NotNull VirtualFile virtualFile) {
        Intrinsics.checkParameterIsNotNull((Object)fem, (String)"fem");
        Intrinsics.checkParameterIsNotNull((Object)virtualFile, (String)"virtualFile");
        this.freeUnusedPanels(fem);
    }

    private final void freeUnusedPanels(FileEditorManager fem) {
        HashSet unseen = new HashSet(this.panels.keySet());
        FileEditor[] fileEditorArray = fem.getAllEditors();
        for (int i = 0; i < fileEditorArray.length; ++i) {
            FileEditor editor = fileEditorArray[i];
            if (!unseen.contains(editor)) continue;
            unseen.remove(editor);
        }
        for (FileEditor editor : unseen) {
            GlancePanel panel;
            if (this.panels.get(editor) == null) {
                Intrinsics.throwNpe();
            }
            panel.onClose();
            FileEditor fileEditor = editor;
            Intrinsics.checkExpressionValueIsNotNull((Object)fileEditor, (String)"editor");
            this.uninject(fileEditor);
            this.panels.remove(editor);
        }
    }

    public void selectionChanged(@NotNull FileEditorManagerEvent fileEditorManagerEvent) {
        Intrinsics.checkParameterIsNotNull((Object)fileEditorManagerEvent, (String)"fileEditorManagerEvent");
    }

    public EditorPanelInjector(@NotNull Project project, @NotNull TaskRunner runner) {
        Intrinsics.checkParameterIsNotNull((Object)project, (String)"project");
        Intrinsics.checkParameterIsNotNull((Object)runner, (String)"runner");
        this.project = project;
        this.runner = runner;
        this.logger = Logger.getInstance(this.getClass());
        this.panels = new HashMap();
        this.configService = (ConfigService)ServiceManager.getService(ConfigService.class);
        Config config = this.configService.getState();
        if (config == null) {
            Intrinsics.throwNpe();
        }
        this.config = config;
    }
}

