/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.cloud;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.remoteServer.agent.util.log.TerminalListener;
import com.intellij.remoteServer.impl.runtime.log.TerminalHandlerBase;
import com.intellij.terminal.JBTerminalPanel;
import com.intellij.terminal.JBTerminalWidget;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.InputStream;
import java.io.OutputStream;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalProcess;
import org.jetbrains.plugins.terminal.cloud.CloudTerminalRunner;

public class TerminalHandlerImpl
extends TerminalHandlerBase {
    private final JBTerminalWidget myTerminalWidget;
    private final JBTerminalPanel myTerminalPanel;
    private final KeyAdapter myCopyActionKeyListener;

    public TerminalHandlerImpl(@NotNull String presentableName, @NotNull Project project, @NotNull InputStream terminalOutput, @NotNull OutputStream terminalInput, boolean deferTerminalSessionUntilFirstShown) {
        if (presentableName == null) {
            TerminalHandlerImpl.$$$reportNull$$$0(0);
        }
        if (project == null) {
            TerminalHandlerImpl.$$$reportNull$$$0(1);
        }
        if (terminalOutput == null) {
            TerminalHandlerImpl.$$$reportNull$$$0(2);
        }
        if (terminalInput == null) {
            TerminalHandlerImpl.$$$reportNull$$$0(3);
        }
        super(presentableName);
        CloudTerminalProcess process = new CloudTerminalProcess(terminalInput, terminalOutput);
        TerminalListener.TtyResizeHandler handlerBoundLater = (w, h) -> this.getResizeHandler().onTtyResizeRequest(w, h);
        CloudTerminalRunner terminalRunner = new CloudTerminalRunner(project, presentableName, process, handlerBoundLater, deferTerminalSessionUntilFirstShown);
        this.myTerminalWidget = terminalRunner.createTerminalWidget((Disposable)project, null);
        this.myTerminalPanel = this.myTerminalWidget.getTerminalPanel();
        this.myCopyActionKeyListener = new MyCopyActionKeyListener();
    }

    public JComponent getComponent() {
        return this.myTerminalWidget.getComponent();
    }

    public JComponent getPreferredFocusableComponent() {
        return this.myTerminalWidget.getPreferredFocusableComponent();
    }

    public void dispose() {
        super.dispose();
        this.myTerminalPanel.removeCustomKeyListener((KeyListener)this.myCopyActionKeyListener);
    }

    public void close() {
        this.myTerminalWidget.getTerminalDisplay().setCursorVisible(false);
        this.myTerminalWidget.stop();
        this.myTerminalPanel.addCustomKeyListener((KeyListener)this.myCopyActionKeyListener);
        super.close();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "presentableName";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "project";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[0] = "terminalOutput";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[0] = "terminalInput";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/terminal/cloud/TerminalHandlerImpl";
        objectArray[2] = "<init>";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private class MyCopyActionKeyListener
    extends KeyAdapter {
        private MyCopyActionKeyListener() {
        }

        @Override
        public void keyPressed(KeyEvent e) {
            String copyActionName = TerminalHandlerImpl.this.myTerminalWidget.getSettingsProvider().getCopyActionPresentation().getName();
            TerminalHandlerImpl.this.myTerminalPanel.getActions().stream().filter(a -> a.getName().equals(copyActionName)).findFirst().ifPresent(a -> {
                if (a.matches(e) && a.isEnabled(e)) {
                    a.actionPerformed(e);
                }
            });
        }
    }
}

