/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.action;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalTabCloseListener;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.action.MoveTerminalToolwindowTabLeftRightAction;
import org.jetbrains.plugins.terminal.action.TerminalSessionContextMenuActionBase;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002B\r\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016J\u000e\u0010\u000e\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\rJ\u0016\u0010\u000f\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u000bJ \u0010\u0010\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\rH\u0016R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/action/MoveTerminalToolwindowTabLeftRightAction;", "Lorg/jetbrains/plugins/terminal/action/TerminalSessionContextMenuActionBase;", "Lcom/intellij/openapi/project/DumbAware;", "moveLeft", "", "(Z)V", "actionPerformedInTerminalToolWindow", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "project", "Lcom/intellij/openapi/project/Project;", "content", "Lcom/intellij/ui/content/Content;", "isAvailable", "move", "updateInTerminalToolWindow", "intellij.terminal"})
public class MoveTerminalToolwindowTabLeftRightAction
extends TerminalSessionContextMenuActionBase
implements DumbAware {
    private final boolean moveLeft;

    @Override
    public void actionPerformedInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        this.move(content, project);
    }

    @Override
    public void updateInTerminalToolWindow(@NotNull AnActionEvent e, @NotNull Project project, @NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Presentation presentation = e.getPresentation();
        Intrinsics.checkNotNullExpressionValue((Object)presentation, (String)"e.presentation");
        presentation.setEnabled(this.isAvailable(content));
    }

    public final boolean isAvailable(@NotNull Content content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        ContentManager contentManager = content.getManager();
        if (contentManager == null) {
            return false;
        }
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"content.manager ?: return false");
        ContentManager manager = contentManager;
        int ind = manager.getIndexOfContent(content);
        return this.moveLeft ? ind > 0 : ind >= 0 && ind < manager.getContentCount() - 1;
    }

    public final void move(@NotNull Content content, @NotNull Project project) {
        int otherInd;
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        ContentManager contentManager = content.getManager();
        if (contentManager == null) {
            return;
        }
        Intrinsics.checkNotNullExpressionValue((Object)contentManager, (String)"content.manager ?: return");
        ContentManager manager = contentManager;
        int ind = manager.getIndexOfContent(content);
        int n = otherInd = this.moveLeft ? ind - 1 : ind + 1;
        if (ind >= 0 && otherInd >= 0 && otherInd < manager.getContentCount()) {
            Content content2 = manager.getContent(otherInd);
            Intrinsics.checkNotNull((Object)content2);
            Intrinsics.checkNotNullExpressionValue((Object)content2, (String)"manager.getContent(otherInd)!!");
            Content otherContent = content2;
            TerminalTabCloseListener.Companion.executeContentOperationSilently(otherContent, (Function0<Unit>)((Function0)new Function0<Unit>(manager, otherContent, ind, project){
                final /* synthetic */ ContentManager $manager;
                final /* synthetic */ Content $otherContent;
                final /* synthetic */ int $ind;
                final /* synthetic */ Project $project;

                public final void invoke() {
                    this.$manager.removeContent(this.$otherContent, false, false, false).doWhenDone(new Runnable(this){
                        final /* synthetic */ move.1 this$0;

                        public final void run() {
                            this.this$0.$manager.addContent(this.this$0.$otherContent, this.this$0.$ind);
                            Content content = this.this$0.$otherContent;
                            Project project = this.this$0.$project;
                            TerminalView terminalView = TerminalView.getInstance(this.this$0.$project);
                            Intrinsics.checkNotNullExpressionValue((Object)terminalView, (String)"TerminalView.getInstance(project)");
                            new TerminalTabCloseListener(content, project, terminalView);
                        }
                        {
                            this.this$0 = var1_1;
                        }
                    });
                }
                {
                    this.$manager = contentManager;
                    this.$otherContent = content;
                    this.$ind = n;
                    this.$project = project;
                    super(0);
                }
            }));
        }
    }

    public MoveTerminalToolwindowTabLeftRightAction(boolean moveLeft) {
        this.moveLeft = moveLeft;
    }
}

