/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.internal.statistic.collectors.fus.TerminalFusAwareHandler;
import com.intellij.internal.statistic.collectors.fus.os.OsVersionUsageCollector;
import com.intellij.internal.statistic.eventLog.FeatureUsageData;
import com.intellij.internal.statistic.service.fus.collectors.FUCounterUsageLogger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.Version;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.util.PathUtil;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalUsageCollectorKt;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\u0018\u0000 \u00032\u00020\u0001:\u0001\u0003B\u0005\u00a2\u0006\u0002\u0010\u0002\u00a8\u0006\u0004"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalUsageTriggerCollector;", "", "()V", "Companion", "intellij.terminal"})
public final class TerminalUsageTriggerCollector {
    @NotNull
    public static final Companion Companion = new Companion(null);

    @JvmStatic
    public static final void triggerSshShellStarted(@NotNull Project project) {
        Companion.triggerSshShellStarted(project);
    }

    @JvmStatic
    public static final void triggerCommandExecuted(@NotNull Project project) {
        Companion.triggerCommandExecuted(project);
    }

    @JvmStatic
    public static final void triggerSmartCommand(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull TerminalShellCommandHandler handler, boolean executed) {
        Companion.triggerSmartCommand(project, workingDirectory, localSession, command, handler, executed);
    }

    @JvmStatic
    public static final void triggerLocalShellStarted(@NotNull Project project, @NotNull String[] shellCommand) {
        Companion.triggerLocalShellStarted(project, shellCommand);
    }

    @JvmStatic
    private static final String getShellNameForStat(String shellName) {
        return TerminalUsageTriggerCollector.Companion.getShellNameForStat(shellName);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u0004H\u0003J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J#\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\u00040\fH\u0007\u00a2\u0006\u0002\u0010\rJ:\u0010\u000e\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u00042\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0011H\u0007J\u0010\u0010\u0016\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0010\u0010\u0017\u001a\u00020\u00042\u0006\u0010\u0018\u001a\u00020\u0004H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalUsageTriggerCollector$Companion;", "", "()V", "getShellNameForStat", "", "shellName", "triggerCommandExecuted", "", "project", "Lcom/intellij/openapi/project/Project;", "triggerLocalShellStarted", "shellCommand", "", "(Lcom/intellij/openapi/project/Project;[Ljava/lang/String;)V", "triggerSmartCommand", "workingDirectory", "localSession", "", "command", "handler", "Lcom/intellij/terminal/TerminalShellCommandHandler;", "executed", "triggerSshShellStarted", "trimKnownExt", "name", "intellij.terminal"})
    public static final class Companion {
        @JvmStatic
        public final void triggerSshShellStarted(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            FUCounterUsageLogger.getInstance().logEvent(project, "terminalShell", "ssh.exec");
        }

        @JvmStatic
        public final void triggerCommandExecuted(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            FUCounterUsageLogger.getInstance().logEvent(project, "terminalShell", "terminal.command.executed");
        }

        @JvmStatic
        public final void triggerSmartCommand(@NotNull Project project, @Nullable String workingDirectory, boolean localSession, @NotNull String command, @NotNull TerminalShellCommandHandler handler, boolean executed) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)handler, (String)"handler");
            FeatureUsageData featureUsageData = new FeatureUsageData();
            String string = handler.getClass().getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"handler::class.java.name");
            FeatureUsageData data = featureUsageData.addData("terminalCommandHandler", string);
            if (handler instanceof TerminalFusAwareHandler) {
                ((TerminalFusAwareHandler)handler).fillData(project, workingDirectory, localSession, command, data);
            }
            String eventId = executed ? "terminal.smart.command.executed" : "terminal.smart.command.not.executed";
            FUCounterUsageLogger.getInstance().logEvent(project, "terminalShell", eventId, data);
        }

        @JvmStatic
        public final void triggerLocalShellStarted(@NotNull Project project, @NotNull String[] shellCommand) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Intrinsics.checkNotNullParameter((Object)shellCommand, (String)"shellCommand");
            Version osVersion = OsVersionUsageCollector.parse((String)SystemInfo.OS_VERSION);
            FUCounterUsageLogger fUCounterUsageLogger = FUCounterUsageLogger.getInstance();
            FeatureUsageData featureUsageData = new FeatureUsageData();
            String string = osVersion == null ? "unknown" : osVersion.toCompactString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"if (osVersion == null) \"\u2026Version.toCompactString()");
            fUCounterUsageLogger.logEvent(project, "terminalShell", "local.exec", featureUsageData.addData("os-version", string).addData("shell", this.getShellNameForStat((String)ArraysKt.firstOrNull((Object[])shellCommand))));
        }

        @JvmStatic
        private final String getShellNameForStat(String shellName) {
            boolean bl;
            String string;
            if (shellName == null) {
                return "unspecified";
            }
            String string2 = shellName;
            boolean bl2 = false;
            String name = ((Object)StringsKt.trimStart((CharSequence)string2)).toString();
            int ind = StringsKt.indexOf$default((CharSequence)name, (String)" ", (int)0, (boolean)false, (int)6, null);
            if (ind < 0) {
                string = name;
            } else {
                String string3 = name;
                int n = 0;
                bl = false;
                String string4 = string3;
                if (string4 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string5 = string4.substring(n, ind);
                string = string5;
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            }
            name = string;
            if (SystemInfo.isFileSystemCaseSensitive) {
                String string6 = name;
                Locale locale = Locale.ENGLISH;
                Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"Locale.ENGLISH");
                Locale locale2 = locale;
                bl = false;
                String string7 = string6;
                boolean bl3 = false;
                String string8 = string7;
                if (string8 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string9 = string8.toLowerCase(locale2);
                Intrinsics.checkNotNullExpressionValue((Object)string9, (String)"(this as java.lang.String).toLowerCase(locale)");
                name = string9;
            }
            String string10 = PathUtil.getFileName((String)name);
            Intrinsics.checkNotNullExpressionValue((Object)string10, (String)"PathUtil.getFileName(name)");
            name = string10;
            name = this.trimKnownExt(name);
            return TerminalUsageCollectorKt.access$getKNOWN_SHELLS$p().contains(name) ? name : "other";
        }

        private final String trimKnownExt(String name) {
            String string;
            String ext = PathUtil.getFileExtension((String)name);
            if (ext != null && TerminalUsageCollectorKt.access$getKNOWN_EXTENSIONS$p().contains(ext)) {
                String string2 = name;
                int n = 0;
                int n2 = name.length() - ext.length() - 1;
                boolean bl = false;
                String string3 = string2;
                if (string3 == null) {
                    throw new NullPointerException("null cannot be cast to non-null type java.lang.String");
                }
                String string4 = string3.substring(n, n2);
                string = string4;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            } else {
                string = name;
            }
            return string;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

