/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.Executor;
import com.intellij.execution.ExecutorRegistry;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationGroup;
import com.intellij.notification.NotificationListener;
import com.intellij.notification.NotificationType;
import com.intellij.notification.SingletonNotificationManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Experiments;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.terminal.TerminalShellCommandHandler;
import com.intellij.ui.JBColor;
import com.intellij.util.Alarm;
import com.jediterm.terminal.TerminalColor;
import com.jediterm.terminal.TextStyle;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.model.TerminalLineIntervalHighlighting;
import com.jediterm.terminal.model.TerminalModelListener;
import java.awt.event.KeyEvent;
import java.io.IOException;
import java.util.Arrays;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.KeyStroke;
import javax.swing.event.HyperlinkEvent;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalCommandHandlerCustomizer;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;
import org.jetbrains.plugins.terminal.arrangement.TerminalWorkingDirectoryManager;
import org.jetbrains.plugins.terminal.shellCommandRunner.TerminalDebugSmartCommandAction;
import org.jetbrains.plugins.terminal.shellCommandRunner.TerminalExecutorAction;
import org.jetbrains.plugins.terminal.shellCommandRunner.TerminalRunSmartCommandAction;

public final class TerminalShellCommandHandlerHelper {
    private static final Logger LOG = Logger.getInstance(TerminalShellCommandHandler.class);
    @NonNls
    private static final String TERMINAL_CUSTOM_COMMANDS_GOT_IT = "TERMINAL_CUSTOM_COMMANDS_GOT_IT";
    @NonNls
    private static final String GOT_IT = "got_it";
    @NonNls
    private static final String FEATURE_ID = "terminal.shell.command.handling";
    private static Experiments ourExperiments;
    private static final NotificationGroup ourToolWindowGroup;
    private final ShellTerminalWidget myWidget;
    private final Alarm myAlarm;
    private volatile String myWorkingDirectory;
    private volatile Boolean myHasRunningCommands;
    private PropertiesComponent myPropertiesComponent;
    private final SingletonNotificationManager mySingletonNotificationManager;
    private final AtomicBoolean myKeyPressed;
    private TerminalLineIntervalHighlighting myCurrentHighlighting;

    TerminalShellCommandHandlerHelper(@NotNull ShellTerminalWidget widget) {
        if (widget == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(0);
        }
        this.mySingletonNotificationManager = new SingletonNotificationManager(ourToolWindowGroup, NotificationType.INFORMATION, null);
        this.myKeyPressed = new AtomicBoolean(false);
        this.myWidget = widget;
        this.myAlarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)widget);
        ApplicationManager.getApplication().getMessageBus().connect((Disposable)this.myWidget).subscribe(TerminalCommandHandlerCustomizer.Companion.getTERMINAL_COMMAND_HANDLER_TOPIC(), () -> this.scheduleCommandHighlighting());
        TerminalModelListener listener = () -> {
            if (this.myKeyPressed.compareAndSet(true, false)) {
                this.scheduleCommandHighlighting();
            }
        };
        widget.getTerminalTextBuffer().addModelListener(listener);
        Disposer.register((Disposable)this.myWidget, () -> widget.getTerminalTextBuffer().removeModelListener(listener));
    }

    public void processKeyPressed() {
        if (TerminalShellCommandHandlerHelper.isFeatureEnabled()) {
            this.myKeyPressed.set(true);
            this.scheduleCommandHighlighting();
        }
    }

    private void scheduleCommandHighlighting() {
        this.myAlarm.cancelAllRequests();
        this.myAlarm.addRequest(() -> this.highlightMatchedCommand(this.myWidget.getProject()), 0);
    }

    public static boolean isFeatureEnabled() {
        Experiments experiments = ourExperiments;
        if (experiments == null) {
            ourExperiments = experiments = (Experiments)ReadAction.compute(() -> ApplicationManager.getApplication().isDisposed() ? null : Experiments.getInstance());
        }
        return experiments != null && experiments.isFeatureEnabled(FEATURE_ID);
    }

    private void highlightMatchedCommand(@NotNull Project project) {
        if (project == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(1);
        }
        if (!this.isEnabledForProject()) {
            this.setHighlighting(null);
            return;
        }
        String command = this.myWidget.getTypedShellCommand().trim();
        TerminalLineIntervalHighlighting commandHighlighting = null;
        if (TerminalShellCommandHandler.Companion.matches(project, this.getWorkingDirectory(), !this.hasRunningCommands(), command)) {
            commandHighlighting = this.doHighlight(command);
        }
        this.setHighlighting(commandHighlighting);
        if (this.getPropertiesComponent().getBoolean(TERMINAL_CUSTOM_COMMANDS_GOT_IT, false)) {
            return;
        }
        if (commandHighlighting != null) {
            String title = TerminalBundle.message("smart_command_execution.notification.title", new Object[0]);
            String content = TerminalBundle.message("smart_command_execution.notification.text", KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getRunAction()), KeymapUtil.getFirstKeyboardShortcutText((AnAction)TerminalShellCommandHandlerHelper.getDebugAction()), ShowSettingsUtil.getSettingsMenuName(), GOT_IT);
            NotificationListener.Adapter listener = new NotificationListener.Adapter(){

                protected void hyperlinkActivated(@NotNull Notification notification, @NotNull HyperlinkEvent e) {
                    if (notification == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if (e == null) {
                        1.$$$reportNull$$$0(1);
                    }
                    if (TerminalShellCommandHandlerHelper.GOT_IT.equals(e.getDescription())) {
                        TerminalShellCommandHandlerHelper.this.getPropertiesComponent().setValue(TerminalShellCommandHandlerHelper.TERMINAL_CUSTOM_COMMANDS_GOT_IT, true, false);
                    }
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2 = new Object[3];
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[0] = "notification";
                            break;
                        }
                        case 1: {
                            objectArray = objectArray2;
                            objectArray2[0] = "e";
                            break;
                        }
                    }
                    objectArray[1] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper$1";
                    objectArray[2] = "hyperlinkActivated";
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
                }
            };
            this.mySingletonNotificationManager.notify(title, content, project, (NotificationListener)listener);
        }
    }

    private synchronized void setHighlighting(@Nullable TerminalLineIntervalHighlighting highlighting) {
        TerminalLineIntervalHighlighting oldHighlighting = this.myCurrentHighlighting;
        if (oldHighlighting != null) {
            oldHighlighting.dispose();
            this.myWidget.getTerminalPanel().repaint();
        }
        this.myCurrentHighlighting = highlighting;
    }

    private boolean isEnabledForProject() {
        return this.getPropertiesComponent().getBoolean("terminalCustomCommandExecutionTurnOff", true);
    }

    @NotNull
    private PropertiesComponent getPropertiesComponent() {
        PropertiesComponent propertiesComponent = this.myPropertiesComponent;
        if (propertiesComponent == null) {
            this.myPropertiesComponent = propertiesComponent = (PropertiesComponent)ReadAction.compute(() -> PropertiesComponent.getInstance());
        }
        PropertiesComponent propertiesComponent2 = propertiesComponent;
        if (propertiesComponent2 == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(2);
        }
        return propertiesComponent2;
    }

    @Nullable
    private String getWorkingDirectory() {
        String workingDirectory = this.myWorkingDirectory;
        if (workingDirectory == null) {
            this.myWorkingDirectory = workingDirectory = StringUtil.notNullize((String)TerminalWorkingDirectoryManager.getWorkingDirectory(this.myWidget, null));
        }
        return StringUtil.nullize((String)workingDirectory);
    }

    private boolean hasRunningCommands() {
        Boolean hasRunningCommands = this.myHasRunningCommands;
        if (hasRunningCommands == null) {
            this.myHasRunningCommands = hasRunningCommands = Boolean.valueOf(this.myWidget.hasRunningCommands());
        }
        return hasRunningCommands;
    }

    @Nullable
    private TerminalLineIntervalHighlighting doHighlight(@NotNull String command) {
        if (command == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(3);
        }
        if (command.length() == 0) {
            return null;
        }
        return this.myWidget.processTerminalBuffer(textBuffer -> {
            int cursorLine = this.myWidget.getLineNumberAtCursor();
            if (cursorLine < 0 || cursorLine >= textBuffer.getHeight()) {
                return null;
            }
            String lineText = textBuffer.getLine(cursorLine).getText();
            int commandStartInd = lineText.lastIndexOf(command);
            if (commandStartInd < 0) {
                return null;
            }
            TextStyle style = new TextStyle(null, TerminalShellCommandHandlerHelper.getSmartCommandExecutionHighlightingColor());
            return this.myWidget.highlightLineInterval(cursorLine, commandStartInd, command.length(), style);
        });
    }

    @NotNull
    private static TerminalColor getSmartCommandExecutionHighlightingColor() {
        return new TerminalColor(() -> new JBColor(13627334, 4214844));
    }

    public boolean processEnterKeyPressed(@NotNull KeyEvent keyPressed) {
        boolean localSession;
        if (keyPressed == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(4);
        }
        if (!TerminalShellCommandHandlerHelper.isFeatureEnabled() || !this.isEnabledForProject()) {
            this.onShellCommandExecuted();
            return false;
        }
        String command = this.myWidget.getTypedShellCommand().trim();
        if (LOG.isDebugEnabled()) {
            LOG.debug("typed shell command to execute: " + command);
        }
        this.myAlarm.cancelAllRequests();
        Project project = this.myWidget.getProject();
        String workingDirectory = this.getWorkingDirectory();
        boolean bl = localSession = !this.hasRunningCommands();
        if (!TerminalShellCommandHandler.Companion.matches(project, workingDirectory, localSession, command)) {
            this.onShellCommandExecuted();
            return false;
        }
        TerminalShellCommandHandler handler = TerminalShellCommandHandler.Companion.getEP().getExtensionList().stream().filter(it -> it.matches(project, workingDirectory, localSession, command)).findFirst().orElseThrow(() -> new RuntimeException("Cannot find matching command handler."));
        Executor executor = TerminalShellCommandHandlerHelper.matchedExecutor(keyPressed);
        if (executor == null) {
            this.onShellCommandExecuted();
            TerminalUsageTriggerCollector.Companion.triggerSmartCommand(project, workingDirectory, localSession, command, handler, false);
            return false;
        }
        TerminalUsageTriggerCollector.Companion.triggerSmartCommand(project, workingDirectory, localSession, command, handler, true);
        TerminalShellCommandHandler.Companion.executeShellCommandHandler(this.myWidget.getProject(), this.getWorkingDirectory(), !this.hasRunningCommands(), command, executor);
        this.clearTypedCommand(command);
        return true;
    }

    private void onShellCommandExecuted() {
        this.myWorkingDirectory = null;
        this.myHasRunningCommands = null;
    }

    private void clearTypedCommand(@NotNull String command) {
        if (command == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(5);
        }
        TtyConnector connector = this.myWidget.getTtyConnector();
        byte[] array = new byte[command.length()];
        Arrays.fill(array, (byte)8);
        try {
            connector.write(array);
        }
        catch (IOException e) {
            LOG.info("Cannot clear shell command " + command, (Throwable)e);
        }
    }

    @Nullable
    static Executor matchedExecutor(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(6);
        }
        if (TerminalShellCommandHandlerHelper.matchedRunAction(e) != null) {
            return DefaultRunExecutor.getRunExecutorInstance();
        }
        if (TerminalShellCommandHandlerHelper.matchedDebugAction(e) != null) {
            return ExecutorRegistry.getInstance().getExecutorById("Debug");
        }
        return null;
    }

    private static TerminalExecutorAction matchedRunAction(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(7);
        }
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        AnAction action = TerminalShellCommandHandlerHelper.getRunAction();
        return action instanceof TerminalRunSmartCommandAction && Arrays.stream(action.getShortcutSet().getShortcuts()).anyMatch(sc -> sc.isKeyboard() && sc.startsWith((Shortcut)eventShortcut)) ? (TerminalRunSmartCommandAction)action : null;
    }

    private static TerminalExecutorAction matchedDebugAction(@NotNull KeyEvent e) {
        if (e == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(8);
        }
        KeyboardShortcut eventShortcut = new KeyboardShortcut(KeyStroke.getKeyStrokeForEvent(e), null);
        AnAction action = TerminalShellCommandHandlerHelper.getDebugAction();
        return action instanceof TerminalDebugSmartCommandAction && Arrays.stream(action.getShortcutSet().getShortcuts()).anyMatch(sc -> sc.isKeyboard() && sc.startsWith((Shortcut)eventShortcut)) ? (TerminalDebugSmartCommandAction)action : null;
    }

    @NotNull
    private static AnAction getRunAction() {
        AnAction anAction = Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Run"));
        if (anAction == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(9);
        }
        return anAction;
    }

    @NotNull
    private static AnAction getDebugAction() {
        AnAction anAction = Objects.requireNonNull(ActionManager.getInstance().getAction("Terminal.SmartCommandExecution.Debug"));
        if (anAction == null) {
            TerminalShellCommandHandlerHelper.$$$reportNull$$$0(10);
        }
        return anAction;
    }

    static {
        ourToolWindowGroup = NotificationGroup.toolWindowGroup((String)"Terminal", (String)"Terminal");
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "widget";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper";
                break;
            }
            case 3: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "command";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "keyPressed";
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/TerminalShellCommandHandlerHelper";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getPropertiesComponent";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getRunAction";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getDebugAction";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "highlightMatchedCommand";
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "doHighlight";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "processEnterKeyPressed";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "clearTypedCommand";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "matchedExecutor";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "matchedRunAction";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "matchedDebugAction";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 9: 
            case 10: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

