/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.JediTermWidget;
import com.pty4j.windows.WinPtyException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.ExecutionException;
import java.util.function.Consumer;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;
import org.jetbrains.plugins.terminal.ShellTerminalWidget;
import org.jetbrains.plugins.terminal.TerminalBundle;
import org.jetbrains.plugins.terminal.TerminalProcessOptions;
import org.jetbrains.plugins.terminal.TerminalTabState;

public abstract class AbstractTerminalRunner<T extends Process> {
    private static final Logger LOG = Logger.getInstance(AbstractTerminalRunner.class);
    @NotNull
    protected final Project myProject;
    private final JBTerminalSystemSettingsProvider mySettingsProvider;

    public JBTerminalSystemSettingsProvider getSettingsProvider() {
        return this.mySettingsProvider;
    }

    public AbstractTerminalRunner(@NotNull Project project) {
        if (project == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(0);
        }
        this.myProject = project;
        this.mySettingsProvider = new JBTerminalSystemSettingsProvider();
    }

    public void run() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, TerminalBundle.message("progress.title.running.terminal", new Object[0]), false){

            public void run(@NotNull ProgressIndicator indicator) {
                if (indicator == null) {
                    1.$$$reportNull$$$0(0);
                }
                indicator.setText(TerminalBundle.message("progress.text.running.terminal", new Object[0]));
                try {
                    AbstractTerminalRunner.this.doRun();
                }
                catch (Exception e) {
                    LOG.warn("Error running terminal", (Throwable)e);
                    UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)AbstractTerminalRunner.this.getProject(), (String)e.getMessage(), (String)this.getTitle()));
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "org/jetbrains/plugins/terminal/AbstractTerminalRunner$1", "run"));
            }
        });
    }

    private void doRun() {
        try {
            T process = this.createProcess(new TerminalProcessOptions(null, null, null), null);
            UIUtil.invokeLaterIfNeeded(() -> this.initConsoleUI(process));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    @NotNull
    public T createProcess(@NotNull TerminalProcessOptions options, @Nullable JBTerminalWidget widget) throws ExecutionException {
        if (options == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(1);
        }
        T t = this.createProcess(options.getWorkingDirectory(), null);
        if (t == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(2);
        }
        return t;
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    public T createProcess(@Nullable String directory) throws ExecutionException {
        throw new AssertionError((Object)"Call createProcess(TerminalProcessOptions, JBTerminalWidget)");
    }

    @Deprecated
    @ApiStatus.ScheduledForRemoval(inVersion="2021.3")
    protected T createProcess(@Nullable String directory, @Nullable String commandHistoryFilePath) throws ExecutionException {
        return this.createProcess(directory);
    }

    protected abstract ProcessHandler createProcessHandler(T var1);

    @NotNull
    public JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory) {
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(3);
        }
        JBTerminalWidget jBTerminalWidget = this.createTerminalWidget(parent, currentWorkingDirectory, true);
        if (jBTerminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(4);
        }
        return jBTerminalWidget;
    }

    @NotNull
    protected JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory, boolean deferSessionUntilFirstShown) {
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(5);
        }
        JBTerminalWidget jBTerminalWidget = this.createTerminalWidget(parent, (JBTerminalWidget terminalWidget) -> this.openSessionForFile((JBTerminalWidget)terminalWidget, currentWorkingDirectory), true);
        if (jBTerminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(6);
        }
        return jBTerminalWidget;
    }

    @NotNull
    protected JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable String currentWorkingDirectory, boolean deferSessionUntilFirstShown) {
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(7);
        }
        JBTerminalWidget jBTerminalWidget = this.createTerminalWidget(parent, (JBTerminalWidget terminalWidget) -> this.openSessionInDirectory((JBTerminalWidget)terminalWidget, currentWorkingDirectory), true);
        if (jBTerminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(8);
        }
        return jBTerminalWidget;
    }

    private JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @NotNull Consumer<JBTerminalWidget> openSession, boolean deferSessionUntilFirstShown) {
        if (parent == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(9);
        }
        if (openSession == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(10);
        }
        ShellTerminalWidget terminalWidget = new ShellTerminalWidget(this.myProject, this.mySettingsProvider, parent);
        if (deferSessionUntilFirstShown) {
            UiNotifyConnector.doWhenFirstShown((JComponent)((Object)terminalWidget), () -> openSession.accept(terminalWidget));
        } else {
            openSession.accept(terminalWidget);
        }
        return terminalWidget;
    }

    private void initConsoleUI(T process) {
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TerminalRunner", (ActionGroup)toolbarActions, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)actionToolbar.getComponent(), "West");
        actionToolbar.setTargetComponent((JComponent)panel);
        ProcessHandler processHandler = this.createProcessHandler(process);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, processHandler, (JComponent)panel, this.getTerminalConnectionName(process));
        contentDescriptor.setAutoFocusContent(true);
        toolbarActions.add(this.createCloseAction(defaultExecutor, contentDescriptor));
        JBTerminalSystemSettingsProvider provider = new JBTerminalSystemSettingsProvider();
        JBTerminalWidget widget = new JBTerminalWidget(this.myProject, (JBTerminalSystemSettingsProviderBase)provider, (Disposable)contentDescriptor);
        AbstractTerminalRunner.createAndStartSession(widget, this.createTtyConnector(process));
        panel.add((Component)widget.getComponent(), "Center");
        this.showConsole(defaultExecutor, contentDescriptor, widget.getComponent());
        processHandler.startNotify();
    }

    public void openSession(@NotNull JBTerminalWidget terminal) {
        if (terminal == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(11);
        }
        this.openSessionInDirectory(terminal, null);
    }

    @Nullable
    public String getCurrentWorkingDir(@Nullable TerminalTabState state) {
        String dir = state != null ? state.myWorkingDirectory : null;
        VirtualFile result = dir == null ? null : LocalFileSystem.getInstance().findFileByPath(dir);
        return result == null ? null : result.getPath();
    }

    private static void createAndStartSession(@NotNull JBTerminalWidget terminal, @NotNull TtyConnector ttyConnector) {
        if (terminal == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(12);
        }
        if (ttyConnector == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(13);
        }
        JediTermWidget session = terminal.createTerminalSession(ttyConnector);
        session.start();
    }

    protected abstract String getTerminalConnectionName(T var1);

    protected abstract TtyConnector createTtyConnector(T var1);

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected void showConsole(Executor defaultExecutor, @NotNull RunContentDescriptor myDescriptor, Component toFocus) {
        if (myDescriptor == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(14);
        }
        RunContentManager.getInstance((Project)this.myProject).showRunContent(defaultExecutor, myDescriptor);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(defaultExecutor.getId());
        if (toolWindow != null) {
            toolWindow.activate(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus(toFocus, true));
        }
    }

    @NotNull
    protected Project getProject() {
        Project project = this.myProject;
        if (project == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(15);
        }
        return project;
    }

    public abstract String runningTargetName();

    public void openSessionForFile(@NotNull JBTerminalWidget terminalWidget, @Nullable VirtualFile file) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(16);
        }
        this.openSessionInDirectory(terminalWidget, AbstractTerminalRunner.getParentDirectoryPath(file));
    }

    @Nullable
    private static String getParentDirectoryPath(@Nullable VirtualFile file) {
        VirtualFile dir = file != null && !file.isDirectory() ? file.getParent() : file;
        return dir != null ? dir.getPath() : null;
    }

    public void openSessionInDirectory(@NotNull JBTerminalWidget terminalWidget, @Nullable String directory) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(17);
        }
        ModalityState modalityState = ModalityState.stateForComponent((Component)terminalWidget.getComponent());
        Dimension size = terminalWidget.getTerminalPanel().getTerminalSizeFromComponent();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                T process = this.createProcess(new TerminalProcessOptions(directory, size != null ? Integer.valueOf(size.width) : null, size != null ? Integer.valueOf(size.height) : null), terminalWidget);
                TtyConnector connector = this.createTtyConnector(process);
                ApplicationManager.getApplication().invokeLater(() -> {
                    try {
                        terminalWidget.createTerminalSession(connector);
                    }
                    catch (Exception e) {
                        this.printError(terminalWidget, "Cannot create terminal session for " + this.runningTargetName(), e);
                    }
                    try {
                        terminalWidget.start();
                        terminalWidget.getComponent().revalidate();
                        terminalWidget.notifyStarted();
                    }
                    catch (RuntimeException e) {
                        this.printError(terminalWidget, "Cannot open " + this.runningTargetName(), e);
                    }
                }, modalityState);
            }
            catch (Exception e) {
                this.printError(terminalWidget, "Cannot open " + this.runningTargetName(), e);
            }
        });
    }

    private void printError(@NotNull JBTerminalWidget terminalWidget, @NotNull String errorMessage, @NotNull Exception e) {
        if (terminalWidget == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(18);
        }
        if (errorMessage == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(19);
        }
        if (e == null) {
            AbstractTerminalRunner.$$$reportNull$$$0(20);
        }
        LOG.info(errorMessage, (Throwable)e);
        @Nls StringBuilder message = new StringBuilder();
        if (terminalWidget.getTerminal().getCursorX() > 1) {
            message.append("\n");
        }
        message.append(errorMessage).append("\n").append(e.getMessage()).append("\n\n");
        WinPtyException winptyException = (WinPtyException)ExceptionUtil.findCause((Throwable)e, WinPtyException.class);
        if (winptyException != null) {
            message.append(winptyException.getMessage()).append("\n\n");
        }
        terminalWidget.writePlainMessage(message.toString());
        terminalWidget.writePlainMessage("\n" + TerminalBundle.message("see.ide.log.error.description", ShowLogAction.getActionName()) + "\n");
        ApplicationManager.getApplication().invokeLater(() -> terminalWidget.getTerminalPanel().setCursorVisible(false), this.myProject.getDisposed());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 15: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 15: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "options";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/terminal/AbstractTerminalRunner";
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parent";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "openSession";
                break;
            }
            case 11: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminal";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ttyConnector";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "myDescriptor";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "terminalWidget";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorMessage";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/terminal/AbstractTerminalRunner";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createProcess";
                break;
            }
            case 4: 
            case 6: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createTerminalWidget";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getProject";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createProcess";
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 15: {
                break;
            }
            case 3: 
            case 5: 
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "createTerminalWidget";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "openSession";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "createAndStartSession";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "showConsole";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "openSessionForFile";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "openSessionInDirectory";
                break;
            }
            case 18: 
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "printError";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 6: 
            case 8: 
            case 15: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

