/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.concurrency;

import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.InternalPromiseUtilKt;
import org.jetbrains.concurrency.Promise;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0003\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\b\n\u0002\b\u0002\b\u0000\u0018\u0000 \u0018*\u0004\b\u0000\u0010\u00012\u00020\u0002:\u0001\u0018B\u001b\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0006J\u0013\u0010\u0013\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\u0002H\u0096\u0002J\r\u0010\u0015\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\rJ\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\u000bR\u0015\u0010\u0003\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\n\n\u0002\u0010\u000e\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/concurrency/PromiseValue;", "T", "", "result", "error", "", "(Ljava/lang/Object;Ljava/lang/Throwable;)V", "getError", "()Ljava/lang/Throwable;", "isCancelled", "", "()Z", "getResult", "()Ljava/lang/Object;", "Ljava/lang/Object;", "state", "Lorg/jetbrains/concurrency/Promise$State;", "getState", "()Lorg/jetbrains/concurrency/Promise$State;", "equals", "other", "getResultOrThrowError", "hashCode", "", "Companion", "intellij.platform.concurrency"})
public final class PromiseValue<T> {
    @Nullable
    private final T result;
    @Nullable
    private final Throwable error;
    @NotNull
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Promise.State getState() {
        return this.error == null ? Promise.State.SUCCEEDED : Promise.State.REJECTED;
    }

    public final boolean isCancelled() {
        return this.error == InternalPromiseUtilKt.getOBSOLETE_ERROR();
    }

    @Nullable
    public final T getResultOrThrowError() {
        T t;
        if (this.error == null) {
            t = this.result;
        } else if (this.error == InternalPromiseUtilKt.getOBSOLETE_ERROR()) {
            t = null;
        } else {
            Throwable throwable = this.error.getCause();
            if (throwable == null) {
                throwable = this.error;
            }
            throw throwable;
        }
        return t;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (other == null || Intrinsics.areEqual(this.getClass(), other.getClass()) ^ true) {
            return false;
        }
        PromiseValue value = (PromiseValue)other;
        return Intrinsics.areEqual(this.result, value.result) && Intrinsics.areEqual((Object)this.error, (Object)value.error);
    }

    public int hashCode() {
        T t = this.result;
        Throwable throwable = this.error;
        return 31 * (t != null ? t.hashCode() : 0) + (throwable != null ? throwable.hashCode() : 0);
    }

    @Nullable
    public final T getResult() {
        return this.result;
    }

    @Nullable
    public final Throwable getError() {
        return this.error;
    }

    private PromiseValue(T result, Throwable error) {
        this.result = result;
        this.error = error;
    }

    public /* synthetic */ PromiseValue(Object result, Throwable error, DefaultConstructorMarker $constructor_marker) {
        this(result, error);
    }

    @JvmStatic
    @NotNull
    public static final <T> PromiseValue<T> createFulfilled(@Nullable T result) {
        return Companion.createFulfilled(result);
    }

    @Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J#\u0010\u0003\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\b\u0010\u0006\u001a\u0004\u0018\u0001H\u0005H\u0007\u00a2\u0006\u0002\u0010\u0007J\u001c\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\u00050\u0004\"\u0004\b\u0001\u0010\u00052\b\u0010\t\u001a\u0004\u0018\u00010\n\u00a8\u0006\u000b"}, d2={"Lorg/jetbrains/concurrency/PromiseValue$Companion;", "", "()V", "createFulfilled", "Lorg/jetbrains/concurrency/PromiseValue;", "T", "result", "(Ljava/lang/Object;)Lorg/jetbrains/concurrency/PromiseValue;", "createRejected", "error", "", "intellij.platform.concurrency"})
    public static final class Companion {
        @JvmStatic
        @NotNull
        public final <T> PromiseValue<T> createFulfilled(@Nullable T result) {
            return new PromiseValue(result, null, null);
        }

        @NotNull
        public final <T> PromiseValue<T> createRejected(@Nullable Throwable error) {
            return new PromiseValue(null, error, null);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

