/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.messages.impl;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EventDispatcher;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.MessageHandler;
import com.intellij.util.messages.SimpleMessageBusConnection;
import com.intellij.util.messages.Topic;
import com.intellij.util.messages.impl.CompositeMessageBus;
import com.intellij.util.messages.impl.JobQueue;
import com.intellij.util.messages.impl.Message;
import com.intellij.util.messages.impl.MessageBusConnectionImpl;
import com.intellij.util.messages.impl.MessageDeliveryListener;
import com.intellij.util.messages.impl.MethodHandleCache;
import com.intellij.util.messages.impl.SimpleMessageBusConnectionImpl;
import java.lang.invoke.MethodHandle;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class MessageBusImpl
implements MessageBus {
    static final Logger LOG = Logger.getInstance(MessageBusImpl.class);
    private static final Object NA = new Object();
    final ThreadLocal<JobQueue> messageQueue;
    final int[] order;
    final ConcurrentMap<Topic<?>, Object> publisherCache;
    final Collection<MessageHandlerHolder> subscribers;
    final Map<Topic<?>, List<?>> subscriberCache;
    @Nullable
    final CompositeMessageBus parentBus;
    final RootBus rootBus;
    final MessageBusOwner owner;
    private static final int DISPOSE_IN_PROGRESS = 1;
    private static final int DISPOSED_STATE = 2;
    private int disposeState;
    private Disposable connectionDisposable;
    MessageDeliveryListener messageDeliveryListener;

    MessageBusImpl(@NotNull MessageBusOwner owner, @NotNull CompositeMessageBus parentBus) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(0);
        }
        if (parentBus == null) {
            MessageBusImpl.$$$reportNull$$$0(1);
        }
        this.messageQueue = ThreadLocal.withInitial(JobQueue::new);
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue<MessageHandlerHolder>();
        this.subscriberCache = new ConcurrentHashMap();
        this.connectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        this.parentBus = parentBus;
        this.rootBus = parentBus.rootBus;
        MessageBusImpl p = this;
        while ((p = p.parentBus) != null) {
            p.subscriberCache.clear();
        }
        this.order = parentBus.addChild(this);
    }

    MessageBusImpl(@NotNull MessageBusOwner owner) {
        if (owner == null) {
            MessageBusImpl.$$$reportNull$$$0(2);
        }
        this.messageQueue = ThreadLocal.withInitial(JobQueue::new);
        this.publisherCache = new ConcurrentHashMap();
        this.subscribers = new ConcurrentLinkedQueue<MessageHandlerHolder>();
        this.subscriberCache = new ConcurrentHashMap();
        this.connectionDisposable = Disposer.newDisposable();
        this.owner = owner;
        this.order = ArrayUtil.EMPTY_INT_ARRAY;
        this.rootBus = (RootBus)this;
        this.parentBus = null;
    }

    public final MessageBus getParent() {
        return this.parentBus;
    }

    public final String toString() {
        return "MessageBus(owner=" + this.owner + ", disposeState= " + this.disposeState + ")";
    }

    @NotNull
    public final MessageBusConnection connect() {
        return this.connect(this.connectionDisposable);
    }

    @NotNull
    public final MessageBusConnectionImpl connect(@NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MessageBusImpl.$$$reportNull$$$0(3);
        }
        this.checkNotDisposed();
        MessageBusConnectionImpl connection = new MessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        Disposer.register((Disposable)parentDisposable, (Disposable)connection);
        MessageBusConnectionImpl messageBusConnectionImpl = connection;
        if (messageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(4);
        }
        return messageBusConnectionImpl;
    }

    @NotNull
    public final SimpleMessageBusConnection simpleConnect() {
        this.checkNotDisposed();
        SimpleMessageBusConnectionImpl connection = new SimpleMessageBusConnectionImpl(this);
        this.subscribers.add(connection);
        SimpleMessageBusConnectionImpl simpleMessageBusConnectionImpl = connection;
        if (simpleMessageBusConnectionImpl == null) {
            MessageBusImpl.$$$reportNull$$$0(5);
        }
        return simpleMessageBusConnectionImpl;
    }

    @NotNull
    public final <L> L syncPublisher(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(6);
        }
        this.checkNotDisposed();
        Object object = this.publisherCache.computeIfAbsent(topic, topic1 -> {
            Class listenerClass = topic1.getListenerClass();
            return Proxy.newProxyInstance(listenerClass.getClassLoader(), new Class[]{listenerClass}, this.createPublisher((Topic)topic1, topic1.getBroadcastDirection()));
        });
        if (object == null) {
            MessageBusImpl.$$$reportNull$$$0(7);
        }
        return (L)object;
    }

    @NotNull
    <L> MessagePublisher<L> createPublisher(@NotNull Topic<L> topic, @NotNull Topic.BroadcastDirection direction) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(8);
        }
        if (direction == null) {
            MessageBusImpl.$$$reportNull$$$0(9);
        }
        if (direction == Topic.BroadcastDirection.TO_PARENT) {
            return new ToParentMessagePublisher<L>(topic, this);
        }
        if (direction == Topic.BroadcastDirection.TO_DIRECT_CHILDREN) {
            throw new IllegalArgumentException("Broadcast direction TO_DIRECT_CHILDREN is allowed only for app level message bus. Please publish to app level message bus or change topic broadcast direction to NONE or TO_PARENT");
        }
        LOG.warn("Broadcast direction TO_CHILDREN  is not allowed for module level message bus. Please change to NONE or TO_PARENT");
        return new MessagePublisher<L>(topic, this);
    }

    public final void disposeConnectionChildren() {
        this.disposeState = 1;
        Disposer.disposeChildren((Disposable)this.connectionDisposable, null);
    }

    public final void disposeConnection() {
        Disposer.dispose((Disposable)this.connectionDisposable);
        this.connectionDisposable = null;
    }

    public void dispose() {
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        this.disposeState = 2;
        this.disposeChildren();
        if (this.connectionDisposable != null) {
            Disposer.dispose((Disposable)this.connectionDisposable);
        }
        JobQueue jobs = this.messageQueue.get();
        this.messageQueue.remove();
        if (!jobs.queue.isEmpty()) {
            LOG.error("Not delivered events in the queue: " + jobs);
        }
        if (this.parentBus == null) {
            this.rootBus.myWaitingBuses.remove();
        } else {
            this.parentBus.onChildBusDisposed(this);
        }
    }

    void disposeChildren() {
    }

    public final boolean isDisposed() {
        return this.disposeState == 2 || this.owner.isDisposed();
    }

    public final boolean hasUndeliveredEvents(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(10);
        }
        if (this.isDisposed()) {
            return false;
        }
        Set<MessageBusImpl> waitingBuses = this.rootBus.myWaitingBuses.get();
        if (waitingBuses == null || waitingBuses.isEmpty()) {
            return false;
        }
        for (MessageBusImpl bus : waitingBuses) {
            JobQueue jobQueue = bus.messageQueue.get();
            Message<?> current = jobQueue.current;
            if (current != null && current.topic == topic) {
                return true;
            }
            for (Message<?> message : jobQueue.queue) {
                if (message.topic != topic) continue;
                return true;
            }
        }
        return false;
    }

    private void checkNotDisposed() {
        if (this.isDisposed()) {
            LOG.error("Already disposed: " + this);
        }
    }

    <L> void doComputeSubscribers(@NotNull Topic<L> topic, @NotNull List<? super L> result, boolean subscribeLazyListeners) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(11);
        }
        if (result == null) {
            MessageBusImpl.$$$reportNull$$$0(12);
        }
        for (MessageHandlerHolder subscriber : this.subscribers) {
            if (subscriber.isDisposed()) continue;
            subscriber.collectHandlers(topic, result);
        }
    }

    @NotNull
    <L> List<L> computeSubscribers(@NotNull Topic<L> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(13);
        }
        ArrayList result = new ArrayList();
        this.doComputeSubscribers(topic, result, true);
        List list = result.isEmpty() ? Collections.emptyList() : result;
        if (list == null) {
            MessageBusImpl.$$$reportNull$$$0(14);
        }
        return list;
    }

    private void jobRemoved(@NotNull JobQueue jobQueue) {
        if (jobQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(15);
        }
        if (jobQueue.current == null && jobQueue.queue.isEmpty()) {
            this.rootBus.myWaitingBuses.get().remove(this);
        }
    }

    private static void pumpMessages(@NotNull Set<? extends MessageBusImpl> waitingBuses) {
        if (waitingBuses == null) {
            MessageBusImpl.$$$reportNull$$$0(16);
        }
        ArrayList<MessageBusImpl> liveBuses = new ArrayList<MessageBusImpl>(waitingBuses.size());
        for (MessageBusImpl messageBusImpl : waitingBuses) {
            if (messageBusImpl.isDisposed()) {
                waitingBuses.remove(messageBusImpl);
                LOG.error("Accessing disposed message bus " + messageBusImpl);
                continue;
            }
            liveBuses.add(messageBusImpl);
        }
        if (!liveBuses.isEmpty()) {
            MessageBusImpl.pumpWaitingBuses(liveBuses);
        }
    }

    private static void pumpWaitingBuses(@NotNull List<? extends MessageBusImpl> buses) {
        if (buses == null) {
            MessageBusImpl.$$$reportNull$$$0(17);
        }
        List<Throwable> exceptions = null;
        for (MessageBusImpl messageBusImpl : buses) {
            if (messageBusImpl.isDisposed()) continue;
            JobQueue jobQueue = messageBusImpl.messageQueue.get();
            Message<?> job = jobQueue.current;
            if (job != null) {
                exceptions = messageBusImpl.deliverMessage(job, jobQueue, messageBusImpl.messageDeliveryListener, exceptions);
            }
            while ((job = jobQueue.queue.pollFirst()) != null) {
                exceptions = messageBusImpl.deliverMessage(job, jobQueue, messageBusImpl.messageDeliveryListener, exceptions);
            }
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private <L> List<Throwable> deliverMessage(@NotNull Message<L> job, @NotNull JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (job == null) {
            MessageBusImpl.$$$reportNull$$$0(18);
        }
        if (jobQueue == null) {
            MessageBusImpl.$$$reportNull$$$0(19);
        }
        ClientId oldClientId = ClientId.getCurrentOrNull();
        try {
            ClientId.trySetCurrentClientId(job.clientId);
            jobQueue.current = job;
            List handlers = job.handlers;
            int index = job.currentHandlerIndex;
            int size = handlers.size();
            int lastIndex = size - 1;
            while (index < size) {
                if (index == lastIndex) {
                    jobQueue.current = null;
                    this.jobRemoved(jobQueue);
                }
                ++job.currentHandlerIndex;
                exceptions = MessageBusImpl.invokeListener(job.method, job.methodName, job.args, job.topic, handlers.get(index), messageDeliveryListener, exceptions);
                if (++index == job.currentHandlerIndex) continue;
                List<Throwable> list = exceptions;
                return list;
            }
            List<Throwable> list = exceptions;
            return list;
        }
        finally {
            ClientId.trySetCurrentClientId(oldClientId);
        }
    }

    boolean hasChildren() {
        return false;
    }

    final void notifyOnSubscription(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(20);
        }
        this.subscriberCache.remove(topic);
        if (topic.getBroadcastDirection() != Topic.BroadcastDirection.TO_CHILDREN) {
            return;
        }
        MessageBusImpl parentBus = this;
        while ((parentBus = parentBus.parentBus) != null) {
            parentBus.subscriberCache.remove(topic);
        }
        if (this.hasChildren()) {
            this.notifyOnSubscriptionToTopicToChildren(topic);
        }
    }

    void notifyOnSubscriptionToTopicToChildren(@NotNull Topic<?> topic) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(21);
        }
    }

    protected static boolean clearSubscriberCache(@NotNull MessageBusImpl bus, @Nullable Map<Topic<?>, Object> handlers, @Nullable Topic<?> singleTopic) {
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(22);
        }
        if (handlers == null) {
            if (singleTopic == null) {
                bus.subscriberCache.clear();
                return true;
            }
            return bus.subscriberCache.remove(singleTopic) != null;
        }
        ToChildrenTopicSubscriberCleaner cleaner = new ToChildrenTopicSubscriberCleaner(bus);
        handlers.forEach(cleaner);
        return cleaner.removed;
    }

    void removeEmptyConnectionsRecursively() {
        this.subscribers.removeIf(MessageHandlerHolder::isDisposed);
    }

    boolean notifyConnectionTerminated(Object @NotNull [] topicAndHandlerPairs) {
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(23);
        }
        if (this.disposeState != 0) {
            return false;
        }
        this.rootBus.scheduleEmptyConnectionRemoving();
        return MessageBusImpl.clearSubscriberCacheOnConnectionTerminated(topicAndHandlerPairs, this);
    }

    private static boolean clearSubscriberCacheOnConnectionTerminated(Object @NotNull [] topicAndHandlerPairs, @NotNull MessageBusImpl bus) {
        if (bus == null) {
            MessageBusImpl.$$$reportNull$$$0(24);
        }
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(25);
        }
        boolean isChildClearingNeeded = false;
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            Topic.BroadcastDirection direction;
            Topic topic = (Topic)topicAndHandlerPairs[i];
            if (bus.subscriberCache.remove(topic) != null) {
                bus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if ((direction = topic.getBroadcastDirection()) != Topic.BroadcastDirection.TO_CHILDREN) continue;
            MessageBusImpl parentBus = bus;
            while ((parentBus = parentBus.parentBus) != null) {
                if (parentBus.subscriberCache.remove(topic) == null) continue;
                parentBus.removeDisposedHandlers(topic, topicAndHandlerPairs[i + 1]);
            }
            if (!bus.hasChildren()) continue;
            isChildClearingNeeded = true;
        }
        return isChildClearingNeeded;
    }

    void clearSubscriberCache(Object @NotNull [] topicAndHandlerPairs) {
        if (topicAndHandlerPairs == null) {
            MessageBusImpl.$$$reportNull$$$0(26);
        }
        for (int i = 0; i < topicAndHandlerPairs.length; i += 2) {
            this.subscriberCache.remove(topicAndHandlerPairs[i]);
        }
    }

    final void deliverImmediately(@NotNull MessageBusConnectionImpl connection) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(27);
        }
        if (this.disposeState == 2) {
            LOG.error("Already disposed: " + this);
        }
        if (this.owner.isDisposed()) {
            return;
        }
        JobQueue jobQueue = this.messageQueue.get();
        Deque jobs = jobQueue.queue;
        if (jobs.isEmpty()) {
            return;
        }
        List newJobs = MessageBusImpl.deliverImmediately(connection, jobs);
        if (newJobs == null) {
            return;
        }
        for (int i = newJobs.size() - 1; i >= 0; --i) {
            jobs.addFirst(newJobs.get(i));
        }
        List<Throwable> exceptions = null;
        for (Message job : newJobs) {
            jobs.removeFirstOccurrence(job);
            exceptions = this.deliverMessage(job, jobQueue, this.messageDeliveryListener, exceptions);
        }
        if (exceptions != null) {
            EventDispatcher.throwExceptions(exceptions);
        }
    }

    @Nullable
    private static <L> List<Message<L>> deliverImmediately(@NotNull MessageBusConnectionImpl connection, @NotNull Deque<Message<L>> jobs) {
        if (connection == null) {
            MessageBusImpl.$$$reportNull$$$0(28);
        }
        if (jobs == null) {
            MessageBusImpl.$$$reportNull$$$0(29);
        }
        List newJobs = null;
        Iterator<Message<L>> jobIterator = jobs.iterator();
        while (jobIterator.hasNext()) {
            Message<L> filteredJob;
            Message<L> job = jobIterator.next();
            List connectionHandlers = null;
            Iterator handlerIterator = job.handlers.iterator();
            while (handlerIterator.hasNext()) {
                Object handler = handlerIterator.next();
                if (!connection.isMyHandler(job.topic, handler)) continue;
                handlerIterator.remove();
                if (connectionHandlers == null) {
                    connectionHandlers = new SmartList();
                }
                connectionHandlers.add(handler);
            }
            if (connectionHandlers == null) continue;
            if (job.handlers.isEmpty()) {
                jobIterator.remove();
                filteredJob = job;
                job.handlers.addAll(connectionHandlers);
            } else {
                filteredJob = new Message(job.topic, job.method, job.methodName, job.args, connectionHandlers);
            }
            if (newJobs == null) {
                newJobs = new SmartList();
            }
            newJobs.add(filteredJob);
        }
        return newJobs;
    }

    public final void setMessageDeliveryListener(@Nullable MessageDeliveryListener listener2) {
        if (this.messageDeliveryListener != null && listener2 != null) {
            throw new IllegalStateException("Already set: " + this.messageDeliveryListener);
        }
        this.messageDeliveryListener = listener2;
    }

    @Nullable
    private static <L> List<Throwable> invokeListener(@NotNull MethodHandle methodHandle, @NotNull String methodName, Object[] args, @NotNull Topic<L> topic, @NotNull L handler, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
        if (methodHandle == null) {
            MessageBusImpl.$$$reportNull$$$0(30);
        }
        if (methodName == null) {
            MessageBusImpl.$$$reportNull$$$0(31);
        }
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(32);
        }
        if (handler == null) {
            MessageBusImpl.$$$reportNull$$$0(33);
        }
        try {
            if (handler instanceof MessageHandler) {
                ((MessageHandler)handler).handle(methodHandle, args);
            } else if (messageDeliveryListener == null) {
                MessageBusImpl.invokeMethod(handler, args, methodHandle);
            } else {
                long startTime = System.nanoTime();
                MessageBusImpl.invokeMethod(handler, args, methodHandle);
                messageDeliveryListener.messageDelivered(topic, methodName, handler, System.nanoTime() - startTime);
            }
        }
        catch (AbstractMethodError startTime) {
        }
        catch (Throwable e) {
            if (exceptions == null) {
                exceptions = new ArrayList<Throwable>();
            }
            exceptions.add(e);
        }
        return exceptions;
    }

    private static void invokeMethod(@NotNull Object handler, Object[] args, MethodHandle methodHandle) throws Throwable {
        if (handler == null) {
            MessageBusImpl.$$$reportNull$$$0(34);
        }
        if (args == null) {
            methodHandle.invoke(handler);
        } else {
            methodHandle.bindTo(handler).invokeExact(args);
        }
    }

    void disconnectPluginConnections(@NotNull Predicate<? super Class<?>> predicate) {
        if (predicate == null) {
            MessageBusImpl.$$$reportNull$$$0(35);
        }
        for (MessageHandlerHolder holder : this.subscribers) {
            holder.disconnectIfNeeded(predicate);
        }
        this.subscriberCache.clear();
    }

    private void removeDisposedHandlers(@NotNull Topic<?> topic, @NotNull Object handler) {
        if (topic == null) {
            MessageBusImpl.$$$reportNull$$$0(36);
        }
        if (handler == null) {
            MessageBusImpl.$$$reportNull$$$0(37);
        }
        JobQueue jobQueue = this.messageQueue.get();
        if (!jobQueue.queue.isEmpty() && jobQueue.queue.removeIf(job -> job.topic == topic && job.handlers.removeIf(it -> it == handler) && job.handlers.isEmpty())) {
            this.jobRemoved(jobQueue);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "owner";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentBus";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 6: 
            case 8: 
            case 10: 
            case 11: 
            case 13: 
            case 20: 
            case 21: 
            case 32: 
            case 36: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topic";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "direction";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 15: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobQueue";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "waitingBuses";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buses";
                break;
            }
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "job";
                break;
            }
            case 22: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "bus";
                break;
            }
            case 23: 
            case 25: 
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "topicAndHandlerPairs";
                break;
            }
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "connection";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "jobs";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodHandle";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "methodName";
                break;
            }
            case 33: 
            case 34: 
            case 37: {
                objectArray2 = objectArray3;
                objectArray3[0] = "handler";
                break;
            }
            case 35: {
                objectArray2 = objectArray3;
                objectArray3[0] = "predicate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "connect";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "simpleConnect";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "syncPublisher";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "computeSubscribers";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "connect";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "syncPublisher";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "createPublisher";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "hasUndeliveredEvents";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doComputeSubscribers";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "computeSubscribers";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "jobRemoved";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "pumpMessages";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "pumpWaitingBuses";
                break;
            }
            case 18: 
            case 19: {
                objectArray = objectArray;
                objectArray[2] = "deliverMessage";
                break;
            }
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscription";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "notifyOnSubscriptionToTopicToChildren";
                break;
            }
            case 22: 
            case 26: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCache";
                break;
            }
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "notifyConnectionTerminated";
                break;
            }
            case 24: 
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "clearSubscriberCacheOnConnectionTerminated";
                break;
            }
            case 27: 
            case 28: 
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "deliverImmediately";
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "invokeListener";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "invokeMethod";
                break;
            }
            case 35: {
                objectArray = objectArray;
                objectArray[2] = "disconnectPluginConnections";
                break;
            }
            case 36: 
            case 37: {
                objectArray = objectArray;
                objectArray[2] = "removeDisposedHandlers";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 14: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    static final class RootBus
    extends CompositeMessageBus {
        private final AtomicReference<CompletableFuture<?>> compactionFutureRef;
        private final AtomicInteger emptyConnectionCounter;
        final ThreadLocal<Set<MessageBusImpl>> myWaitingBuses;

        RootBus(@NotNull MessageBusOwner owner) {
            if (owner == null) {
                RootBus.$$$reportNull$$$0(0);
            }
            super(owner);
            this.compactionFutureRef = new AtomicReference();
            this.emptyConnectionCounter = new AtomicInteger();
            this.myWaitingBuses = ThreadLocal.withInitial(() -> new TreeSet((bus1, bus2) -> ArrayUtil.lexicographicCompare((int[])bus1.order, (int[])bus2.order)));
        }

        void scheduleEmptyConnectionRemoving() {
            CompletableFuture<Void> future;
            int counter = this.emptyConnectionCounter.incrementAndGet();
            if (counter < 128 || !this.emptyConnectionCounter.compareAndSet(counter, 0)) {
                return;
            }
            CompletableFuture<?> oldFuture = this.compactionFutureRef.get();
            if (oldFuture == null && !this.compactionFutureRef.compareAndSet(null, future = CompletableFuture.runAsync(() -> {
                this.removeEmptyConnectionsRecursively();
                this.compactionFutureRef.set(null);
            }, AppExecutorUtil.getAppExecutorService()))) {
                future.cancel(false);
            }
        }

        @Override
        public void dispose() {
            CompletableFuture compactionFuture = this.compactionFutureRef.getAndSet(null);
            if (compactionFuture != null) {
                compactionFuture.cancel(false);
            }
            super.dispose();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "owner", "com/intellij/util/messages/impl/MessageBusImpl$RootBus", "<init>"));
        }
    }

    private static final class ToChildrenTopicSubscriberCleaner
    implements BiConsumer<Topic<?>, Object> {
        private final MessageBusImpl bus;
        boolean removed;

        ToChildrenTopicSubscriberCleaner(@NotNull MessageBusImpl bus) {
            if (bus == null) {
                ToChildrenTopicSubscriberCleaner.$$$reportNull$$$0(0);
            }
            this.bus = bus;
        }

        @Override
        public void accept(Topic<?> topic, Object __) {
            Topic.BroadcastDirection direction = topic.getBroadcastDirection();
            if (direction == Topic.BroadcastDirection.TO_CHILDREN && this.bus.subscriberCache.remove(topic) != null) {
                this.removed = true;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "bus", "com/intellij/util/messages/impl/MessageBusImpl$ToChildrenTopicSubscriberCleaner", "<init>"));
        }
    }

    static final class ToParentMessagePublisher<L>
    extends MessagePublisher<L>
    implements InvocationHandler {
        ToParentMessagePublisher(@NotNull Topic<L> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(1);
            }
            super(topic, bus);
        }

        @Override
        boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            if (method == null) {
                ToParentMessagePublisher.$$$reportNull$$$0(2);
            }
            List<Throwable> exceptions = null;
            MessageBusImpl parentBus = this.bus;
            boolean hasHandlers = false;
            do {
                List<?> existing;
                List<Object> handlers;
                if ((handlers = parentBus.subscriberCache.get(this.topic)) == null && (existing = parentBus.subscriberCache.putIfAbsent(this.topic, handlers = parentBus.computeSubscribers(this.topic))) != null) {
                    handlers = existing;
                }
                if (handlers.isEmpty()) continue;
                hasHandlers = true;
                exceptions = this.executeOrAddToQueue(this.topic, method, args, handlers, jobQueue, this.bus.messageDeliveryListener, exceptions);
            } while ((parentBus = parentBus.parentBus) != null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return hasHandlers;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl$ToParentMessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static class MessagePublisher<L>
    implements InvocationHandler {
        @NotNull
        protected final Topic<L> topic;
        @NotNull
        protected final MessageBusImpl bus;

        MessagePublisher(@NotNull Topic<L> topic, @NotNull MessageBusImpl bus) {
            if (topic == null) {
                MessagePublisher.$$$reportNull$$$0(0);
            }
            if (bus == null) {
                MessagePublisher.$$$reportNull$$$0(1);
            }
            this.topic = topic;
            this.bus = bus;
        }

        @Override
        public final Object invoke(Object proxy, Method method, Object[] args) {
            JobQueue jobQueue;
            Set<MessageBusImpl> busQueue;
            if (method.getDeclaringClass() == Object.class) {
                return EventDispatcher.handleObjectMethod((Object)proxy, (Object[])args, (String)method.getName());
            }
            this.bus.checkNotDisposed();
            boolean isImmediateDelivery = this.topic.isImmediateDelivery();
            if (isImmediateDelivery) {
                busQueue = null;
                jobQueue = null;
            } else {
                busQueue = this.bus.rootBus.myWaitingBuses.get();
                jobQueue = this.bus.messageQueue.get();
                MessageBusImpl.pumpMessages(busQueue);
            }
            if (this.publish(method, args, jobQueue) && !isImmediateDelivery) {
                busQueue.add(this.bus);
                MessageBusImpl.pumpMessages(busQueue);
            }
            return NA;
        }

        boolean publish(@NotNull Method method, Object[] args, @Nullable JobQueue jobQueue) {
            List handlers;
            if (method == null) {
                MessagePublisher.$$$reportNull$$$0(2);
            }
            if ((handlers = this.bus.subscriberCache.computeIfAbsent(this.topic, topic1 -> this.bus.computeSubscribers(topic1))).isEmpty()) {
                return false;
            }
            List<Throwable> exceptions = this.executeOrAddToQueue(this.topic, method, args, handlers, jobQueue, this.bus.messageDeliveryListener, null);
            if (exceptions != null) {
                EventDispatcher.throwExceptions(exceptions);
            }
            return true;
        }

        List<Throwable> executeOrAddToQueue(@NotNull Topic<L> topic, @NotNull Method method, Object[] args, @NotNull List<L> handlers, @Nullable JobQueue jobQueue, @Nullable MessageDeliveryListener messageDeliveryListener, @Nullable List<Throwable> exceptions) {
            if (topic == null) {
                MessagePublisher.$$$reportNull$$$0(3);
            }
            if (method == null) {
                MessagePublisher.$$$reportNull$$$0(4);
            }
            if (handlers == null) {
                MessagePublisher.$$$reportNull$$$0(5);
            }
            MethodHandle methodHandle = MethodHandleCache.compute(method, args);
            if (jobQueue == null) {
                for (L handler : handlers) {
                    exceptions = MessageBusImpl.invokeListener(methodHandle, method.getName(), args, topic, handler, messageDeliveryListener, exceptions);
                }
            } else {
                jobQueue.queue.offerLast(new Message<L>(topic, methodHandle, method.getName(), args, handlers));
            }
            return exceptions;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "topic";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "bus";
                    break;
                }
                case 2: 
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "method";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "handlers";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/messages/impl/MessageBusImpl$MessagePublisher";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "publish";
                    break;
                }
                case 3: 
                case 4: 
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "executeOrAddToQueue";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static interface MessageHandlerHolder {
        public <L> void collectHandlers(@NotNull Topic<L> var1, @NotNull List<? super L> var2);

        public void disconnectIfNeeded(@NotNull Predicate<? super Class<?>> var1);

        public boolean isDisposed();
    }
}

