/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.io;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.util.io.BufferExposingByteArrayOutputStream;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.io.HttpUrlConnectionUtilKt;
import com.intellij.util.net.NetUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLConnection;
import java.nio.charset.Charset;
import java.util.regex.Matcher;
import kotlin.Metadata;
import kotlin.jvm.JvmOverloads;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J$\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\n\b\u0002\u0010\t\u001a\u0004\u0018\u00010\nH\u0007J\f\u0010\r\u001a\u00020\u000e*\u00020\bH\u0007\u00a8\u0006\u000f"}, d2={"Lcom/intellij/util/io/HttpUrlConnectionUtil;", "", "()V", "readBytes", "Lcom/intellij/openapi/util/io/BufferExposingByteArrayOutputStream;", "inputStream", "Ljava/io/InputStream;", "connection", "Ljava/net/URLConnection;", "progressIndicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "readString", "", "getCharset", "Ljava/nio/charset/Charset;", "intellij.platform.ide"})
public final class HttpUrlConnectionUtil {
    @NotNull
    public static final HttpUrlConnectionUtil INSTANCE;

    @JvmStatic
    @NotNull
    public static final BufferExposingByteArrayOutputStream readBytes(@NotNull InputStream inputStream, @NotNull URLConnection connection, @Nullable ProgressIndicator progressIndicator) throws IOException, ProcessCanceledException {
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        int contentLength = connection.getContentLength();
        BufferExposingByteArrayOutputStream out = new BufferExposingByteArrayOutputStream(contentLength > 0 ? contentLength : 16384);
        NetUtils.copyStreamContent((ProgressIndicator)progressIndicator, (InputStream)inputStream, (OutputStream)((OutputStream)out), (int)contentLength);
        return out;
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String readString(@NotNull InputStream inputStream, @NotNull URLConnection connection, @Nullable ProgressIndicator progressIndicator) throws IOException, ProcessCanceledException {
        String string;
        Intrinsics.checkNotNullParameter((Object)inputStream, (String)"inputStream");
        Intrinsics.checkNotNullParameter((Object)connection, (String)"connection");
        BufferExposingByteArrayOutputStream byteStream = HttpUrlConnectionUtil.readBytes(inputStream, connection, progressIndicator);
        if (byteStream.size() == 0) {
            string = "";
        } else {
            byte[] byArray = byteStream.getInternalBuffer();
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"byteStream.internalBuffer");
            byte[] byArray2 = byArray;
            int n = 0;
            int n2 = byteStream.size();
            Charset charset = HttpUrlConnectionUtil.getCharset(connection);
            boolean bl = false;
            string = new String(byArray2, n, n2, charset);
        }
        return string;
    }

    public static /* synthetic */ String readString$default(InputStream inputStream, URLConnection uRLConnection, ProgressIndicator progressIndicator, int n, Object object) throws IOException, ProcessCanceledException {
        if ((n & 4) != 0) {
            progressIndicator = null;
        }
        return HttpUrlConnectionUtil.readString(inputStream, uRLConnection, progressIndicator);
    }

    @JvmStatic
    @JvmOverloads
    @NotNull
    public static final String readString(@NotNull InputStream inputStream, @NotNull URLConnection connection) throws IOException, ProcessCanceledException {
        return HttpUrlConnectionUtil.readString$default(inputStream, connection, null, 4, null);
    }

    @JvmStatic
    @NotNull
    public static final Charset getCharset(@NotNull URLConnection $this$getCharset) throws IOException {
        Matcher m;
        Intrinsics.checkNotNullParameter((Object)$this$getCharset, (String)"$this$getCharset");
        String contentType = $this$getCharset.getContentType();
        CharSequence charSequence = contentType;
        boolean bl = false;
        boolean bl2 = false;
        if (!(charSequence == null || charSequence.length() == 0) && (m = HttpUrlConnectionUtilKt.access$getCHARSET_PATTERN$p().matcher(contentType)).find()) {
            try {
                Charset charset = Charset.forName(StringUtil.unquoteString((String)m.group(1)));
                Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"Charset.forName(StringUt\u2026nquoteString(m.group(1)))");
                return charset;
            }
            catch (IllegalArgumentException e) {
                throw (Throwable)new IOException("unknown charset (" + contentType + ')', e);
            }
        }
        return Charsets.UTF_8;
    }

    private HttpUrlConnectionUtil() {
    }

    static {
        HttpUrlConnectionUtil httpUrlConnectionUtil;
        INSTANCE = httpUrlConnectionUtil = new HttpUrlConnectionUtil();
    }
}

