/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.concurrency;

import com.intellij.util.concurrency.Sentinel;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 2}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\b\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010\u000e\n\u0000\u0018\u0000*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002B\u0013\u0012\f\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004\u00a2\u0006\u0002\u0010\u0005J\u0013\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0013J\r\u0010\u0014\u001a\u0004\u0018\u00018\u0000\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0015\u001a\u00020\u0011H\u0016J\b\u0010\u0016\u001a\u00020\u0017H\u0016R\u0016\u0010\u0006\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00028\u00000\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R$\u0010\t\u001a\u00028\u00002\u0006\u0010\t\u001a\u00028\u00008V@VX\u0096\u000e\u00a2\u0006\f\u001a\u0004\b\n\u0010\u000b\"\u0004\b\f\u0010\rR\u0013\u0010\u000e\u001a\u0004\u0018\u00018\u00008F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u000b\u00a8\u0006\u0018"}, d2={"Lcom/intellij/util/concurrency/SynchronizedClearableLazy;", "T", "Lkotlin/Lazy;", "initializer", "Lkotlin/Function0;", "(Lkotlin/jvm/functions/Function0;)V", "computedValue", "Ljava/util/concurrent/atomic/AtomicReference;", "", "value", "getValue", "()Ljava/lang/Object;", "setValue", "(Ljava/lang/Object;)V", "valueIfInitialized", "getValueIfInitialized", "compareAndDrop", "", "expectedValue", "(Ljava/lang/Object;)Z", "drop", "isInitialized", "toString", "", "intellij.platform.concurrency"})
public final class SynchronizedClearableLazy<T>
implements Lazy<T> {
    private final AtomicReference<Object> computedValue;
    private final Function0<T> initializer;

    @Nullable
    public final T getValueIfInitialized() {
        Object value = this.computedValue.get();
        return (T)(value instanceof Sentinel ? null : value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public T getValue() {
        Object currentValue;
        while ((currentValue = this.computedValue.get()) instanceof Sentinel) {
            SynchronizedClearableLazy synchronizedClearableLazy = this;
            boolean bl = false;
            boolean bl2 = false;
            synchronized (synchronizedClearableLazy) {
                boolean bl3 = false;
                currentValue = this.computedValue.get();
                if (!(currentValue instanceof Sentinel)) {
                    Object object = currentValue;
                    return (T)object;
                }
                Object result = this.initializer.invoke();
                if (this.computedValue.compareAndSet(currentValue, result)) {
                    Object object = result;
                    return (T)object;
                }
                Unit unit = Unit.INSTANCE;
            }
        }
        return (T)currentValue;
    }

    public void setValue(T value) {
        this.computedValue.set(value);
    }

    public boolean isInitialized() {
        return !(this.computedValue.get() instanceof Sentinel);
    }

    @NotNull
    public String toString() {
        return String.valueOf(this.computedValue.get());
    }

    @Nullable
    public final T drop() {
        Object oldValue = this.computedValue.getAndSet(new Sentinel());
        return (T)(oldValue instanceof Sentinel ? null : oldValue);
    }

    public final boolean compareAndDrop(T expectedValue) {
        return this.computedValue.compareAndSet(expectedValue, new Sentinel());
    }

    public SynchronizedClearableLazy(@NotNull Function0<? extends T> initializer) {
        Intrinsics.checkNotNullParameter(initializer, (String)"initializer");
        this.initializer = initializer;
        this.computedValue = new AtomicReference<Sentinel>(new Sentinel());
    }
}

