/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ThrowableRunnable;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public final class SlowOperations {
    private static final Logger LOG = Logger.getInstance(SlowOperations.class);
    private static final Set<String> ourReportedTraces = new HashSet<String>();
    private static final String[] misbehavingFrames = new String[]{"org.jetbrains.kotlin.idea.refactoring.introduce.introduceVariable.KotlinIntroduceVariableHandler", "org.jetbrains.kotlin.idea.actions.KotlinAddImportAction", "org.jetbrains.kotlin.idea.codeInsight.KotlinCopyPasteReferenceProcessor", "com.intellij.apiwatcher.plugin.presentation.bytecode.UsageHighlighter"};
    private static boolean ourAllowedFlag = System.getenv("TEAMCITY_VERSION") != null || !ApplicationManager.getApplication().isInternal();

    private SlowOperations() {
    }

    public static void assertSlowOperationsAreAllowed() {
        if (ourAllowedFlag) {
            return;
        }
        if (Registry.is((String)"ide.enable.slow.operations.in.edt")) {
            return;
        }
        Application application = ApplicationManager.getApplication();
        if (application.isUnitTestMode() || !application.isDispatchThread() || application.isWriteAccessAllowed()) {
            return;
        }
        String stackTrace = ExceptionUtil.currentStackTrace();
        if (ContainerUtil.or((Object[])misbehavingFrames, stackTrace::contains) || !ourReportedTraces.add(stackTrace)) {
            return;
        }
        LOG.error("Slow operations are prohibited in the EDT");
    }

    public static <T, E extends Throwable> T allowSlowOperations(@NotNull ThrowableComputable<T, E> computable) throws E {
        if (computable == null) {
            SlowOperations.$$$reportNull$$$0(0);
        }
        if (ourAllowedFlag || !ApplicationManager.getApplication().isDispatchThread()) {
            return (T)computable.compute();
        }
        ourAllowedFlag = true;
        try {
            Object object = computable.compute();
            return (T)object;
        }
        finally {
            ourAllowedFlag = false;
        }
    }

    public static <E extends Throwable> void allowSlowOperations(@NotNull ThrowableRunnable<E> runnable) throws E {
        if (runnable == null) {
            SlowOperations.$$$reportNull$$$0(1);
        }
        SlowOperations.allowSlowOperations(() -> {
            runnable.run();
            return null;
        });
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "computable";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "runnable";
                break;
            }
        }
        objectArray[1] = "com/intellij/util/SlowOperations";
        objectArray[2] = "allowSlowOperations";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

